/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.xml;

import is.hugvit.xml.ParseException;
import is.hugvit.xml.ParserConfig;
import is.hugvit.xml.TokInfo;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

final class MarkupTokenizer {
    public static final int LTSIGN_TOK = 1;
    public static final int GTSIGN_TOK = 2;
    public static final int EQUAL_TOK = 3;
    public static final int STRING_TOK = 4;
    public static final int NAME_TOK = 5;
    public static final int DIRECTIVE_TOK = 6;
    public static final int COMMENT_TOK = 7;
    public static final int SLASH_TOK = 8;
    public static final int TEXT_TOK = 9;
    public static final int CDATA_TOK = 10;
    public static final int INSTRUCTION_TOK = 11;
    public static final int SPACE_TOK = 12;
    public static final int EOF_TOK = 13;
    private static final char EOF_CHAR = '\u0000';
    private static final char LF_CHAR = '\n';
    private boolean verbose;
    private boolean in_tag;
    private boolean in_xsl_tag;
    private char[] nextChar = new char[9];
    private int nextPos = 0;
    private TokInfo[] tokInfo;
    private int tokPos = 0;
    private Reader in;
    private StringBuffer buffer;
    private ParserConfig config;
    Stack tag_stack = new Stack();

    public MarkupTokenizer(int lookahead, ParserConfig config) {
        this.config = config;
        this.tokInfo = new TokInfo[lookahead];
        for (int i = 0; i < lookahead; ++i) {
            this.tokInfo[i] = new TokInfo();
        }
    }

    public void setInput(Reader in) throws ParseException, IOException {
        int i;
        this.in = in;
        for (i = 0; i < this.nextChar.length; ++i) {
            this.get();
        }
        for (i = 0; i < this.tokInfo.length; ++i) {
            this.getTok();
        }
    }

    public final void setVerbose(boolean flag) {
        this.verbose = flag;
        if (flag && this.buffer == null) {
            this.buffer = new StringBuffer(4096);
        }
    }

    private final char peek() {
        return this.nextChar[this.nextPos];
    }

    public final String getTokType(int tok) {
        String s;
        switch (tok) {
            case 1: {
                s = "<";
                break;
            }
            case 2: {
                s = ">";
                break;
            }
            case 3: {
                s = "=";
                break;
            }
            case 4: {
                s = "string";
                break;
            }
            case 5: {
                s = "name";
                break;
            }
            case 6: {
                s = "directive";
                break;
            }
            case 7: {
                s = "comment";
                break;
            }
            case 8: {
                s = "/";
                break;
            }
            case 9: {
                s = "text";
                break;
            }
            case 10: {
                s = "CDATA";
                break;
            }
            case 11: {
                s = "instruction";
                break;
            }
            case 12: {
                s = "space";
                break;
            }
            case 13: {
                s = "EOF";
                break;
            }
            default: {
                s = "";
            }
        }
        return s;
    }

    private final char peek(int i) {
        return this.nextChar[(this.nextPos + i) % this.nextChar.length];
    }

    private final String peek(int start, int n) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            s.append(this.peek(i + start));
        }
        return s.toString();
    }

    private final char get() throws IOException {
        TokInfo t = this.tokInfo[this.tokPos];
        char result = this.nextChar[this.nextPos];
        int c = this.in.read();
        this.nextChar[this.nextPos] = c != -1 ? (char)c : (char)'\u0000';
        this.nextPos = (this.nextPos + 1) % this.nextChar.length;
        if (result == '\n') {
            ++t.lineNo;
            t.linePos = 0;
        } else {
            ++t.linePos;
        }
        if (this.verbose && result != '\u0000') {
            this.buffer.append(result);
        }
        return result;
    }

    private final void get(StringBuffer s, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            s.append(this.get());
        }
    }

    public final int peekTok() {
        return this.tokInfo[this.tokPos].tok;
    }

    public final int peekTok(int i) {
        return this.tokInfo[(this.tokPos + i) % this.tokInfo.length].tok;
    }

    public final String peekString() {
        return this.tokInfo[this.tokPos].nextString.toString();
    }

    public final String peekString(int i) {
        return this.tokInfo[(this.tokPos + i) % this.tokInfo.length].nextString.toString();
    }

    public final String getString() throws ParseException, IOException {
        String result = this.peekString();
        this.getTok();
        return result;
    }

    public final void expected(char ch) throws ParseException {
        this.expected(ch + "");
    }

    private static final String getLine(String s, int x) {
        int i = 0;
        int l = 0;
        int j = s.indexOf("\n");
        while (j >= 0) {
            if (++l == x) {
                return s.substring(i, j);
            }
            i = j + 1;
            j = s.indexOf("\n", i);
        }
        return s.substring(i);
    }

    public final void expected(String ch) throws ParseException {
        int line = this.tokInfo[this.tokPos].lineNo;
        int column = this.tokInfo[this.tokPos].linePos;
        String current_line = null;
        if (this.verbose) {
            current_line = MarkupTokenizer.getLine(this.buffer.toString(), line);
        }
        throw new ParseException("Expected " + ch + " but got \"" + this.peekString() + "\"", line, column, current_line);
    }

    public final void assertTok(int token) throws ParseException {
        if (this.peekTok() != token) {
            this.expected(this.getTokType(token));
        }
    }

    private final void readString(StringBuffer s) throws ParseException, IOException {
        char start = this.get();
        s.append(start);
        while (this.peek() != '\u0000' && this.peek() != start) {
            s.append(this.get());
        }
        if (this.peek() == '\u0000') {
            this.expected(start);
        }
        s.append(this.get());
    }

    private final void readSpace(StringBuffer s) throws IOException {
        s.append(this.get());
        while (Character.isWhitespace(this.peek())) {
            s.append(this.get());
        }
    }

    private final void readDirective(StringBuffer s) throws ParseException, IOException {
        this.get(s, 2);
        while (this.peek() != '\u0000' && this.peek() != '>') {
            s.append(this.get());
        }
        if (this.peek() == '\u0000') {
            this.expected(">");
        }
        s.append(this.get());
    }

    private final void readText(StringBuffer s) throws ParseException, IOException {
        if (this.config.getReadAlternateXSL()) {
            while (this.peek() != '\u0000' && this.peek() != '<' && this.peek() != '>' && !this.peek(0, 5).equals("[xsl:") && !this.peek(0, 6).equals("[/xsl:")) {
                s.append(this.get());
            }
        } else {
            while (this.peek() != '\u0000' && this.peek() != '<' && this.peek() != '>') {
                s.append(this.get());
            }
        }
    }

    private final void readName(StringBuffer s) throws ParseException, IOException {
        s.append(this.get());
        if (this.config.getReadAlternateXSL()) {
            while (this.peek() != '\u0000' && !Character.isWhitespace(this.peek()) && this.peek() != '/' && this.peek() != '>' && this.peek() != '=' && this.peek() != ']') {
                s.append(this.get());
            }
        } else {
            while (this.peek() != '\u0000' && !Character.isWhitespace(this.peek()) && this.peek() != '/' && this.peek() != '>' && this.peek() != '=') {
                s.append(this.get());
            }
        }
        if (this.config.getMicrosoftWord() && s.toString().indexOf(":") == 1) {
            s.delete(0, 2);
        }
    }

    private final void readCDATA(StringBuffer s) throws ParseException, IOException {
        this.get(s, 9);
        while (true) {
            if (this.peek() != '\u0000' && this.peek() != ']') {
                s.append(this.get());
                continue;
            }
            if (this.peek() == '\u0000') {
                this.expected("]]>");
            }
            s.append(this.get());
            if (this.peek() == ']' && this.peek(1) == '>') break;
        }
        this.get(s, 2);
    }

    private final void readComment(StringBuffer s) throws ParseException, IOException {
        this.get(s, 4);
        while (true) {
            if (this.peek() != '\u0000' && this.peek() != '-' && this.peek() != '<') {
                s.append(this.get());
                continue;
            }
            if (this.peek() == '\u0000') {
                this.expected("-->");
            }
            if (this.peek() == '<') {
                s.append(this.get());
                continue;
            }
            s.append(this.get());
            if (this.peek() != '-') continue;
            s.append(this.get());
            while (Character.isWhitespace(this.peek())) {
                s.append(this.get());
            }
            if (this.peek() == '>') break;
        }
        s.append(this.get());
    }

    public final int getTok() throws ParseException, IOException {
        if (this.tokInfo.length > 1) {
            int pos = this.tokPos - 1;
            if (pos < 0) {
                pos = this.tokInfo.length - 1;
            }
            this.tokInfo[this.tokPos].lineNo = this.tokInfo[pos].lineNo;
            this.tokInfo[this.tokPos].linePos = this.tokInfo[pos].linePos;
        }
        StringBuffer str = this.tokInfo[this.tokPos].nextString;
        str.setLength(0);
        int tok = 0;
        while (tok == 0) {
            if (this.peek() == '\u0000') {
                tok = 13;
                str.setLength(0);
                str.append("EOF");
                continue;
            }
            if (this.peek() == '<') {
                str.setLength(0);
                if (this.peek(1) == '!') {
                    if (this.peek(2) == '-' && this.peek(3) == '-') {
                        this.readComment(str);
                        tok = 7;
                        continue;
                    }
                    if (this.peek(2, 7).equals("[CDATA[")) {
                        tok = 10;
                        this.readCDATA(str);
                        continue;
                    }
                    tok = 6;
                    this.readDirective(str);
                    continue;
                }
                if (this.peek(1) == '?') {
                    tok = 11;
                    this.readDirective(str);
                    continue;
                }
                tok = 1;
                str.append(this.get());
                this.in_tag = true;
                continue;
            }
            if (this.peek() == '>') {
                tok = 2;
                str.setLength(0);
                str.append(this.get());
                this.in_tag = false;
                continue;
            }
            if (this.config.getReadAlternateXSL() && this.in_xsl_tag && this.peek() == ']') {
                tok = 2;
                str.setLength(0);
                str.append(">");
                this.get();
                this.in_tag = false;
                this.in_xsl_tag = false;
                continue;
            }
            if (this.config.getReadAlternateXSL() && (this.peek(0, 5).equals("[xsl:") || this.peek(0, 6).equals("[/xsl:"))) {
                tok = 1;
                str.setLength(0);
                this.get();
                str.append("<");
                this.in_tag = true;
                this.in_xsl_tag = true;
                continue;
            }
            if (this.in_tag) {
                if (this.peek() == '/') {
                    tok = 8;
                    str.append(this.get());
                    continue;
                }
                if (this.peek() == '=') {
                    tok = 3;
                    str.append(this.get());
                    continue;
                }
                if (this.peek() == '\"' || this.peek() == '\'') {
                    tok = 4;
                    this.readString(str);
                    continue;
                }
                if (Character.isWhitespace(this.peek())) {
                    tok = 12;
                    this.readSpace(str);
                    continue;
                }
                this.readName(str);
                tok = 5;
                continue;
            }
            this.readText(str);
            tok = 9;
        }
        int result = this.tokInfo[this.tokPos].tok;
        this.tokInfo[this.tokPos].tok = tok;
        this.tokPos = (this.tokPos + 1) % this.tokInfo.length;
        return result;
    }
}

