/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.tomcat;

import is.hugvit.tomcat.AD_User;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;

public final class ActiveDirectoryRealm
implements Realm {
    private Container container;
    private String connectionServer = "localhost";
    private String connectionPort = "389";
    private String connectionDomain = "";
    private String connectionBase;
    private Hashtable h = new Hashtable();
    private long expire_time = 600000L;
    private boolean debug = false;

    public final void setConnectionServer(String s) {
        this.connectionServer = s;
    }

    public final void setConnectionPort(String s) {
        this.connectionPort = s;
    }

    public final void setConnectionDomain(String domain) {
        this.connectionDomain = domain;
        if (this.connectionBase == null) {
            StringBuffer s = new StringBuffer(64);
            StringTokenizer st = new StringTokenizer(domain, ".");
            if (st.hasMoreTokens()) {
                s.append("dc=" + st.nextToken());
                while (st.hasMoreTokens()) {
                    s.append(",dc=" + st.nextToken());
                }
            }
            this.connectionBase = s.toString();
        }
    }

    public final void setConnectionBase(String s) {
        this.connectionBase = s;
    }

    public final void setCacheTime(int i) {
        this.expire_time = i * 60 * 1000;
    }

    public final void setDebug(boolean b) {
        this.debug = b;
    }

    public Container getContainer() {
        return this.container;
    }

    public final void setContainer(Container container) {
        this.container = container;
    }

    public final String getInfo() {
        return this.getClass().getName() + "/1.0";
    }

    private final GenericPrincipal getPrincipal(String user) {
        AD_User u = (AD_User)this.h.get(user = user.toLowerCase());
        if (u != null) {
            long l = System.currentTimeMillis() - u.t;
            if (l < this.expire_time) {
                return u.p;
            }
            this.h.remove(user);
        }
        return null;
    }

    private final void putPrincipal(GenericPrincipal p) {
        this.h.put(p.getName().toLowerCase(), new AD_User(p));
    }

    private static final String getGroupName(String s) {
        int p1 = s.indexOf(61) + 1;
        int p2 = s.indexOf(44);
        if (p2 == -1) {
            p2 = s.length();
        }
        return s.substring(p1, p2).trim();
    }

    private final Attributes getUser(DirContext ctx, String username) throws NamingException {
        Attributes attr = null;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(this.connectionBase, "sAMAccountName=" + username, constraints);
        if (results.hasMore()) {
            SearchResult sr = results.next();
            attr = sr.getAttributes();
        }
        results.close();
        return attr;
    }

    private final ArrayList getRoles(DirContext ctx, String username) throws NamingException {
        ArrayList<String> alist = new ArrayList<String>();
        alist.add("Domain Users");
        Attributes attr = this.getUser(ctx, username);
        if (attr != null) {
            Attribute a = attr.get("memberOf");
            if (a != null) {
                NamingEnumeration<?> ne = a.getAll();
                while (ne.hasMore()) {
                    String s = (String)ne.next();
                    if (s == null) continue;
                    alist.add(ActiveDirectoryRealm.getGroupName(s));
                }
                ne.close();
            }
        } else if (this.debug) {
            System.out.println("User not found");
        }
        return alist;
    }

    private final DirContext createContext(String username, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + this.connectionServer + ':' + this.connectionPort);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", username + '@' + this.connectionDomain);
        env.put("java.naming.security.credentials", password);
        return new InitialDirContext(env);
    }

    public final Principal authenticate(String username, String credentials) {
        if (username == null || username.equals("")) {
            return null;
        }
        GenericPrincipal p = this.getPrincipal(username);
        if (p == null) {
            try {
                try {
                    if (this.debug) {
                        System.out.println("Trying to log in: " + username);
                    }
                    DirContext ctx = this.createContext(username, credentials);
                    if (this.debug) {
                        System.out.println("Success logging in: " + username);
                    }
                    ArrayList alist = this.getRoles(ctx, username);
                    ctx.close();
                    if (this.debug) {
                        System.out.println(username + ".roles=" + alist);
                    }
                    p = new GenericPrincipal((Realm)this, username, credentials, (List)alist);
                    this.putPrincipal(p);
                }
                catch (AuthenticationException e) {
                    if (this.debug) {
                        System.out.println("Authenticate failed for " + username);
                        e.printStackTrace();
                    }
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return p;
    }

    public final boolean hasRole(Principal principal, String role) {
        GenericPrincipal gp = (GenericPrincipal)principal;
        return gp.hasRole(role);
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] securityConstraints) throws IOException {
        return false;
    }

    public final Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, new String(credentials));
    }

    public final Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        return null;
    }

    public final Principal authenticate(X509Certificate[] certs) {
        return null;
    }

    public void backgroundProcess() {
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        return new SecurityConstraint[0];
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] securityConstraints, Context context) throws IOException {
        return false;
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
    }
}

