/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.thread;

import is.hugvit.thread.ThreadData;
import is.hugvit.thread.ThreadDataStore;
import is.hugvit.thread.ThreadItem;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

final class ThreadEngine
implements Runnable {
    private Thread thread;
    private Vector threads = new Vector();
    private boolean running;
    ThreadDataStore ds;
    final Properties param = new Properties();

    ThreadEngine() {
    }

    private final ThreadData getThreadDataByName(Vector v, String name) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ThreadData item = (ThreadData)e.nextElement();
            if (!name.equals(item.getName())) continue;
            return item;
        }
        return null;
    }

    final void refresh() {
        try {
            Vector v1 = this.threads;
            Vector v2 = this.ds.getThreads();
            Vector<ThreadItem> v3 = new Vector<ThreadItem>();
            Enumeration e = v1.elements();
            while (e.hasMoreElements()) {
                ThreadItem item1 = (ThreadItem)e.nextElement();
                ThreadData item2 = this.getThreadDataByName(v2, item1.getName());
                if (item2 == null) {
                    item1.stop();
                    continue;
                }
                item1.update(item2);
                v2.removeElement(item2);
                v3.addElement(item1);
            }
            e = v2.elements();
            while (e.hasMoreElements()) {
                ThreadItem item = new ThreadItem(this.ds);
                item.update((ThreadData)e.nextElement());
                v3.addElement(item);
            }
            this.threads = v3;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void start() {
        this.stop();
        this.refresh();
        this.thread = new Thread(this);
        this.thread.start();
    }

    void stop() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            this.runThreads();
            long min = this.getMinTime();
            try {
                if (min < 0L) continue;
                Thread.sleep(min);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stopThreads();
    }

    private final long getMinTime() {
        long min = 86400000L;
        Enumeration e = this.threads.elements();
        while (e.hasMoreElements()) {
            ThreadItem item = (ThreadItem)e.nextElement();
            long time = item.getSleepTime();
            if (time == -1L || time >= min) continue;
            min = time;
        }
        return min;
    }

    private final void runThreads() {
        Enumeration e = this.threads.elements();
        while (e.hasMoreElements()) {
            ThreadItem item = (ThreadItem)e.nextElement();
            if (!item.isReady()) continue;
            item.start();
        }
    }

    private final void stopThreads() {
        Enumeration e = this.threads.elements();
        while (e.hasMoreElements()) {
            ThreadItem item = (ThreadItem)e.nextElement();
            item.stop();
        }
    }

    final ThreadItem findItem(Object obj) {
        Enumeration e = this.threads.elements();
        while (e.hasMoreElements()) {
            ThreadItem item = (ThreadItem)e.nextElement();
            if (item == obj) {
                return item;
            }
            if (item.runner != obj) continue;
            return item;
        }
        return null;
    }

    final ThreadItem findItemByName(String name) {
        Enumeration e = this.threads.elements();
        while (e.hasMoreElements()) {
            ThreadItem item = (ThreadItem)e.nextElement();
            if (!item.getName().equalsIgnoreCase(name)) continue;
            return item;
        }
        return null;
    }
}

