/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.sql;

import is.hugvit.io.ByteArrayInputStreamEx;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.sql.NativeTypes;
import is.hugvit.sql.Null;
import is.hugvit.util.ArrayListEx;
import is.hugvit.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class SQLUtil {
    private SQLUtil() {
    }

    public static final String getTypeString(int type) {
        for (String key : NativeTypes.stypes.keySet()) {
            Integer i = (Integer)NativeTypes.stypes.get(key);
            if (i != type) continue;
            return key;
        }
        return null;
    }

    public static final int getTypeInt(String type) {
        int p = type.indexOf("(");
        if (p > -1) {
            type = type.substring(0, p);
        }
        return (Integer)NativeTypes.stypes.get(type);
    }

    public static final Object getObject(String value, int type) throws ParseException {
        if (type == 4) {
            return new Integer(value);
        }
        if (type == 92) {
            return new Time(Util.isoToTime(value).getTime());
        }
        if (type == 93) {
            return new Timestamp(Util.isoToDateTime(value).getTime());
        }
        if (type == 91) {
            return new Date(Util.isoToDate(value).getTime());
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public static final String getString(ResultSet rs, int i, int type) throws SQLException {
        value = null;
        if (type == 92) {
            v = rs.getTime(i);
            if (v != null) {
                value = Util.timeToISO(v);
            }
        } else if (type == 93) {
            v = rs.getTimestamp(i);
            if (v != null) {
                value = Util.dateTimeToISO(v);
            }
        } else if (type == 91) {
            v = rs.getDate(i);
            if (v != null) {
                value = Util.dateToISO(v);
            }
        } else if (type == 2005 || type == -1) {
            value = rs.getString(i);
        } else if (type == 2004 || type == -4) {
            try {
                in = rs.getBinaryStream(i);
                if (in == null) ** GOTO lbl33
                out = new ByteArrayOutputStream(1024);
                Util.writeStream(in, out);
                in.close();
                out.close();
                value = out.toString("ISO-8859-1");
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        } else {
            value = type == 12 || type == 1 ? rs.getString(i) : rs.getObject(i);
        }
lbl33:
        // 7 sources

        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static final Hashtable getHashtable(ResultSet rs) throws SQLException {
        ResultSetMetaData rsm = rs.getMetaData();
        int count = rsm.getColumnCount();
        Hashtable<String, String> h = new Hashtable<String, String>();
        for (int i = 1; i <= count; ++i) {
            String name = rsm.getColumnName(i).toLowerCase();
            int type = rsm.getColumnType(i);
            Object obj = type == 1 || type == 2005 || type == -1 || type == 12 ? rs.getString(i) : rs.getObject(i);
            if (obj == null) {
                obj = new Null(type);
            }
            h.put(name, (String)obj);
        }
        return h;
    }

    public static final void setStatement(PreparedStatement stmt, Vector v, int start) throws SQLException, IOException {
        int i = start;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o == null) {
                stmt.setObject(i, null);
            } else if (o instanceof Null) {
                int type = ((Null)o).getType();
                stmt.setNull(i, type);
            } else if (o instanceof Integer) {
                stmt.setInt(i, (Integer)o);
            } else if (o instanceof ByteArrayInputStreamEx) {
                ByteArrayInputStreamEx inx = (ByteArrayInputStreamEx)o;
                stmt.setBinaryStream(i, (InputStream)inx, inx.size());
            } else if (o instanceof InputStream) {
                InputStream in = (InputStream)o;
                ByteArrayOutputStreamEx out = new ByteArrayOutputStreamEx(4096);
                Util.writeStream(in, out);
                ByteArrayInputStreamEx inx = new ByteArrayInputStreamEx(out);
                stmt.setBinaryStream(i, (InputStream)inx, inx.size());
            } else if (o instanceof Time) {
                stmt.setTime(i, (Time)o);
            } else if (o instanceof Timestamp) {
                stmt.setTimestamp(i, (Timestamp)o);
            } else if (o instanceof java.util.Date) {
                java.util.Date d = (java.util.Date)o;
                stmt.setDate(i, new Date(d.getTime()));
            } else if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                String bv = b != false ? "1" : "0";
                stmt.setString(i, bv);
            } else if (o instanceof Vector) {
                String s = Util.expand((Vector)o, ";");
                stmt.setString(i, s);
            } else {
                stmt.setString(i, o.toString());
            }
            ++i;
        }
    }

    public static final Connection connect(String prefix, Properties p) throws SQLException {
        try {
            Driver driver = (Driver)Class.forName(p.getProperty(prefix + "driver")).newInstance();
            return SQLUtil.connect(driver, prefix, p);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public static final Connection connect(Driver driver, String prefix, Properties p) throws SQLException {
        Properties q = new Properties();
        String user = p.getProperty(prefix + "user");
        if (user != null) {
            q.put("user", user);
            String password = p.getProperty(prefix + "password");
            if (password != null) {
                q.put("password", password);
            }
        }
        return driver.connect(p.getProperty(prefix + "connection"), q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getString(Connection c, String sql, String value) throws SQLException {
        PreparedStatement stmt = c.prepareStatement(sql);
        if (value != null) {
            stmt.setString(1, value);
        }
        try (ResultSet rs = stmt.executeQuery();){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        finally {
            stmt.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getStrings(Connection c, String sql, String value) throws SQLException {
        ArrayListEx list = new ArrayListEx();
        PreparedStatement stmt = c.prepareStatement(sql);
        if (value != null) {
            stmt.setString(1, value);
        }
        try (ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        finally {
            stmt.close();
        }
        return list.toStrings();
    }

    public static final String[] getStrings(Connection c, String sql) throws SQLException {
        return SQLUtil.getStrings(c, sql, null);
    }
}

