/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.net;

import is.hugvit.bird.BirdEngine;
import is.hugvit.bird.BirdException;
import is.hugvit.net.IteratorEnumeration;
import is.hugvit.net.URLEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class QueryString {
    private final HashMap table = new HashMap();

    public QueryString(String querystring) throws BirdException {
        try {
            this.init(querystring);
        }
        catch (UnsupportedEncodingException ex) {
            throw new BirdException(ex);
        }
    }

    public QueryString(InputStream in) throws IOException {
        InputStreamReader in2 = new InputStreamReader(in);
        StringBuffer s = new StringBuffer(4096);
        char[] c = new char[4096];
        int count = in2.read(c);
        while (count > 0) {
            s.append(c, 0, count);
            count = in2.read(c);
        }
        this.init(s.toString());
    }

    public QueryString() {
    }

    private final void init(String querystring) throws UnsupportedEncodingException {
        String encoding = (String)BirdEngine.getInstance().getConfig().get("encoding");
        if (querystring != null) {
            StringTokenizer e = new StringTokenizer(querystring, "&");
            while (e.hasMoreElements()) {
                String s;
                String name = s = (String)e.nextElement();
                String[] value = "";
                int pos = s.indexOf(61);
                if (pos > -1) {
                    name = s.substring(0, pos).trim();
                    value = URLDecoder.decode(s.substring(pos + 1), encoding);
                }
                if (this.table.containsKey(name)) {
                    String[] a = this.getAsArray(name, 1);
                    a[a.length - 1] = value;
                    value = a;
                }
                this.table.put(name, value);
            }
        }
    }

    private final String[] getAsArray(String name, int addsize) {
        String[] s;
        Object obj = this.table.get(name);
        if (obj instanceof String[]) {
            String[] t = (String[])obj;
            int l = t.length;
            s = new String[l + addsize];
            System.arraycopy(t, 0, s, 0, l);
        } else {
            s = new String[1 + addsize];
            s[0] = (String)obj;
        }
        return s;
    }

    public final String get(String name) {
        return this.get(name, "");
    }

    public final String get(String name, String def) {
        String value = def;
        Object obj = this.table.get(name);
        if (obj instanceof String) {
            value = (String)obj;
        } else if (obj instanceof String[]) {
            String[] s = (String[])obj;
            value = s[0];
        }
        return value;
    }

    public final String getParameter(String name) {
        return this.get(name, null);
    }

    public final void put(String name, String value) {
        this.table.remove(name);
        this.table.put(name, value);
    }

    public final Enumeration keys() {
        return new IteratorEnumeration(this.table.keySet().iterator());
    }

    public final void put(String name) {
        this.put(name, "");
    }

    public final void put(String name, int value) {
        this.put(name, value + "");
    }

    public final Enumeration getParameterNames() {
        return this.keys();
    }

    public final String[] getParameterValues(String name) {
        Object value = this.table.get(name);
        if (value instanceof String) {
            String[] s = new String[]{(String)value};
            return s;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return null;
    }

    public final boolean contains(String name) {
        return this.table.containsKey(name);
    }

    public final String toString() {
        StringBuffer s = new StringBuffer(this.table.size() * 16);
        Iterator e = this.table.keySet().iterator();
        while (e.hasNext()) {
            String name = (String)e.next();
            String value = (String)this.table.get(name);
            s.append(name);
            s.append('=');
            s.append(URLEncoder.encode(value));
            if (!e.hasNext()) continue;
            s.append('&');
        }
        return s.toString();
    }
}

