/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.net;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HttpUtil {
    private HttpUtil() {
    }

    private static final StringBuffer appendServerURL(HttpServletRequest req) {
        StringBuffer s = new StringBuffer(64);
        s.append(req.getScheme());
        s.append("://");
        s.append(req.getServerName());
        int port = req.getServerPort();
        if (port != 80 && port != 443) {
            s.append(":" + port);
        }
        return s;
    }

    private static final void appendSlash(StringBuffer s) {
        int i = s.length();
        if (i == 0 || s.charAt(i - 1) != '/') {
            s.append('/');
        }
    }

    private static final StringBuffer appendServletURL(HttpServletRequest req, StringBuffer s) {
        int p;
        if (s == null) {
            s = new StringBuffer(64);
        }
        String path = req.getPathInfo();
        String uri = req.getRequestURI();
        if (path != null && !path.equals("/") && (p = uri.lastIndexOf(path)) > -1) {
            uri = uri.substring(0, p);
        }
        if (uri.charAt(uri.length() - 1) == '/') {
            uri = uri.substring(0, uri.length() - 1);
        }
        s.append(uri);
        return s;
    }

    public static final String getServerURL(HttpServletRequest req) {
        return HttpUtil.appendServerURL(req).toString();
    }

    public static final String getServletURL(HttpServletRequest req) {
        StringBuffer s = HttpUtil.appendServerURL(req);
        HttpUtil.appendServletURL(req, s);
        return s.toString();
    }

    public static final String getWebAppURL(HttpServletRequest req) {
        StringBuffer s = HttpUtil.appendServerURL(req);
        String t = HttpUtil.appendServletURL(req, null).toString();
        int p = t.indexOf(47, 1);
        if (p > -1) {
            t = t.substring(0, p);
        }
        s.append(t);
        return s.toString();
    }

    public static final String getURL(HttpServletRequest req) {
        StringBuffer s = HttpUtil.appendServerURL(req);
        s.append(req.getRequestURI());
        String qs = req.getQueryString();
        if (qs != null && !qs.equals("")) {
            s.append('?');
            s.append(qs);
        }
        return s.toString();
    }

    public static final String getPathURL(HttpServletRequest req) {
        StringBuffer s = HttpUtil.appendServerURL(req);
        String uri = req.getRequestURI();
        if (uri.equals("")) {
            s.append('/');
        } else {
            int p = uri.lastIndexOf(47);
            if (p == -1) {
                s.append('/');
            } else {
                s.append(uri.substring(0, p + 1));
            }
        }
        return s.toString();
    }

    public static final String getPathInfo(HttpServletRequest req) {
        String pathinfo = req.getPathInfo();
        if (pathinfo == null || pathinfo.equals("")) {
            return "/";
        }
        if (pathinfo.charAt(0) != '/') {
            pathinfo = '/' + pathinfo;
        }
        return pathinfo;
    }

    public static final Cookie getCookie(HttpServletRequest req, String name) {
        Cookie[] cookie_jar = req.getCookies();
        if (cookie_jar != null) {
            for (int i = cookie_jar.length - 1; i >= 0; --i) {
                Cookie c = cookie_jar[i];
                if (c == null || !c.getName().equalsIgnoreCase(name)) continue;
                return c;
            }
        }
        return null;
    }

    public static final String getCookieValue(HttpServletRequest req, String name) {
        Cookie c = HttpUtil.getCookie(req, name);
        return c == null ? "" : c.getValue();
    }

    public static final Cookie addCookie(HttpServletResponse res, String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(Integer.MAX_VALUE);
        res.addCookie(cookie);
        return cookie;
    }

    public static final void deleteCookie(HttpServletResponse res, String name) {
        Cookie cookie = new Cookie(name, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        res.addCookie(cookie);
    }
}

