/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.log;

import is.hugvit.log.SystemLog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class FileLog
extends SystemLog {
    private PrintWriter out;
    private File dir;
    private File file;
    private String lastdate;
    private String filename;
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private boolean system;

    public FileLog(File file) throws IOException {
        this.file = file;
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
    }

    public FileLog(File dir, String filename, boolean system) throws IOException {
        this.dir = dir;
        this.filename = filename;
        this.doCheck();
        this.system = system;
    }

    private final synchronized void doCheck() {
        try {
            String date = df.format(new Date());
            if (this.lastdate == null || !this.lastdate.equals(date)) {
                this.lastdate = date;
                this.file = new File(this.dir, this.filename + '.' + date + ".txt");
                this.close();
                this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.file.getAbsolutePath(), true)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static final void writeReader(Reader in, Writer out) throws IOException {
        char[] c = new char[4096];
        int count = in.read(c);
        while (count > 0) {
            out.write(c, 0, count);
            count = in.read(c);
        }
    }

    public final String getCurrentLog() throws IOException {
        StringWriter out = new StringWriter();
        FileReader in = new FileReader(this.file);
        FileLog.writeReader(in, out);
        in.close();
        return out.toString();
    }

    public final String getLog(String filename) throws IOException {
        File f = new File(this.dir, filename);
        StringWriter out = new StringWriter();
        FileReader in = new FileReader(f);
        FileLog.writeReader(in, out);
        in.close();
        return out.toString();
    }

    public final File[] getFiles() {
        int i;
        File[] fs = this.dir.listFiles();
        ArrayList<File> l = new ArrayList<File>();
        for (i = 0; i < fs.length; ++i) {
            File f = fs[i];
            String name = f.getName();
            if (!name.startsWith(this.filename + '.')) continue;
            l.add(f);
        }
        fs = new File[l.size()];
        for (i = 0; i < l.size(); ++i) {
            fs[i] = (File)l.get(i);
        }
        return fs;
    }

    @Override
    protected synchronized void println(String msg) {
        this.doCheck();
        this.out.println(msg);
        if (this.system) {
            System.out.println(msg);
        }
    }

    @Override
    protected synchronized void printStackTrace(Exception e) {
        this.doCheck();
        e.printStackTrace(this.out);
        if (this.system) {
            e.printStackTrace();
        }
    }

    @Override
    protected void flush() {
        this.out.flush();
    }

    public final void close() {
        if (this.out != null) {
            this.out.close();
        }
    }
}

