/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.image;

import is.hugvit.image.JpegEncoder;
import is.hugvit.io.ByteArrayInputStreamEx;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.util.Util;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ReplicateScaleFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ImageUtil
extends Component {
    private static final Component comp = new ImageUtil();

    private ImageUtil() {
    }

    public static final Image getImage(byte[] imagedata, int length) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image image = tk.createImage(imagedata, 0, length);
        MediaTracker media = new MediaTracker(comp);
        media.addImage(image, 0);
        try {
            media.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public static final Image getImage(InputStream in) throws IOException {
        Toolkit tk = Toolkit.getDefaultToolkit();
        byte[] buffer = null;
        int size = 0;
        if (in instanceof ByteArrayInputStreamEx) {
            ByteArrayInputStreamEx pin = (ByteArrayInputStreamEx)in;
            buffer = pin.getBuffer();
            size = pin.size();
        } else {
            size = in.available();
            if (size == 0) {
                size = 4096;
            }
            ByteArrayOutputStreamEx out = new ByteArrayOutputStreamEx(size);
            Util.writeStream(in, out);
            buffer = out.getBuffer();
            size = out.size();
        }
        Image image = tk.createImage(buffer, 0, size);
        MediaTracker media = new MediaTracker(comp);
        media.addImage(image, 0);
        try {
            media.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public static final int getWidth(Image image) {
        return image.getWidth(comp);
    }

    public static final int getHeight(Image image) {
        return image.getHeight(comp);
    }

    public static final Image scale(Image source, int pixels) {
        int w = source.getWidth(comp);
        int h = source.getHeight(comp);
        if (w <= pixels && h <= pixels) {
            return source;
        }
        double x = h > w ? (double)h : (double)w;
        x = (double)pixels / x;
        w = (int)((double)w * x);
        h = (int)((double)h * x);
        w = w < 1 ? 1 : w;
        h = h < 1 ? 1 : h;
        ReplicateScaleFilter replicate = new ReplicateScaleFilter(w, h);
        FilteredImageSource prod = new FilteredImageSource(source.getSource(), replicate);
        Image image = comp.createImage(prod);
        MediaTracker media = new MediaTracker(comp);
        media.addImage(image, 0);
        try {
            media.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public static final void saveImageJPG(Image source, OutputStream out, int quality) {
        JpegEncoder jpg = new JpegEncoder(source, quality, out);
        jpg.Compress();
    }
}

