/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.gdf;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class Document {
    private final Hashtable h = new Hashtable();
    private static final DateFormat df_iso = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat dtf_iso = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private static final DateFormat tf_iso = new SimpleDateFormat("'T'HHmmss");

    public final void put(String name, Object obj) {
        if (obj != null) {
            this.h.put(name, obj);
        }
    }

    public final void clear() {
        this.h.clear();
    }

    public final void put(Hashtable t) {
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = t.get(name);
            if (value == null) continue;
            this.h.put(name, value);
        }
    }

    public final Object get(String name) {
        return this.h.get(name);
    }

    public final String getString(String name) {
        return (String)this.h.get(name);
    }

    public final Hashtable getHashtable() {
        return this.h;
    }

    public final void put(Element doc) {
        for (Element item : doc.selectNodes("item")) {
            String name = item.attributeValue("name");
            List items = item.elements();
            if (items.size() <= 0) continue;
            Element e = (Element)items.get(0);
            String ename = e.getName();
            Object value = e.getText();
            if (ename.equals("number")) {
                value = new Integer(value.toString());
            } else if (ename.equals("datetime")) {
                try {
                    value = df_iso.parse(value.toString());
                }
                catch (ParseException ex) {
                    continue;
                }
            }
            this.h.put(name, value);
        }
    }

    private static final String getType(Object obj) {
        if (obj instanceof Date) {
            return "datetime";
        }
        if (obj instanceof Integer) {
            return "number";
        }
        if (obj instanceof Double) {
            return "number";
        }
        return "text";
    }

    private static final void addItem(Element item, String type, Object obj) {
        item.addElement(type).addText(obj.toString());
    }

    private final void addObject(Element item, Object obj) {
        if (obj instanceof Timestamp) {
            obj = dtf_iso.format((Date)obj);
            Document.addItem(item, "datetime", obj);
        } else if (obj instanceof Time) {
            obj = tf_iso.format((Date)obj);
            Document.addItem(item, "datetime", obj);
        } else if (obj instanceof Date) {
            obj = df_iso.format((Date)obj);
            Document.addItem(item, "datetime", obj);
        } else if (obj instanceof Integer || obj instanceof Double) {
            Document.addItem(item, "number", obj);
        } else {
            Document.addItem(item, "text", obj);
        }
    }

    final Element addElement(Element root) {
        Element doc = root.addElement("document");
        Enumeration it = this.h.keys();
        while (it.hasMoreElements()) {
            String name = (String)it.nextElement();
            Object obj = this.h.get(name);
            if (obj == null) continue;
            Element item = doc.addElement("item");
            item.addAttribute("name", name);
            if (name.equals("body")) {
                String body = "<html>" + obj + "</html>";
                try {
                    org.dom4j.Document html = DocumentHelper.parseText((String)body);
                    item.add(html.getRootElement());
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (obj instanceof Vector) {
                Vector v = (Vector)obj;
                if (v.isEmpty()) continue;
                String type = Document.getType(v.firstElement());
                Element list = item.addElement(type + "list");
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    this.addObject(list, e.nextElement());
                }
                continue;
            }
            this.addObject(item, obj);
        }
        return doc;
    }
}

