/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.ConstantField;
import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataSourceImpl;
import is.hugvit.datapump.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XMLDataSource
extends DataSourceImpl {
    private Iterator iterator;
    protected DateFormat dateformat = DateFormat.getDateInstance(3);
    protected DateFormat timeformat;

    public XMLDataSource() {
        this.dateformat.setLenient(true);
        this.timeformat = DateFormat.getTimeInstance(3);
        this.timeformat.setLenient(true);
    }

    @Override
    public void open() throws DataException {
        try {
            String url = this.param.getProperty("url");
            String path = this.param.getProperty("path");
            if (url == null) {
                throw new DataException("url parameter not specified");
            }
            if (path == null) {
                throw new DataException("path parameter not specified");
            }
            String df = this.param.getProperty("dateformat");
            if (df != null) {
                this.dateformat = new SimpleDateFormat(df);
                this.dateformat.setLenient(true);
            }
            SAXReader reader = new SAXReader();
            Document doc = reader.read(url);
            this.iterator = doc.selectNodes(path).iterator();
        }
        catch (Exception e) {
            throw new DataException(e);
        }
    }

    @Override
    public boolean getRecord(Hashtable h) throws DataException {
        try {
            if (!this.iterator.hasNext()) {
                return false;
            }
            Element r = (Element)this.iterator.next();
            Enumeration e = this.fields.elements();
            while (e.hasMoreElements()) {
                Field f = (Field)e.nextElement();
                String alias = f.getAliasOrName();
                Object value = null;
                if (f instanceof ConstantField) {
                    if (f instanceof ConstantField) {
                        value = ((ConstantField)f).getValue();
                    }
                } else {
                    Element n = r.element(f.getName());
                    String s = n.getText();
                    if (f.getType() == 1) {
                        if (!s.equals("")) {
                            value = new Integer(s);
                        }
                    } else if (f.getType() == 2) {
                        if (!s.equals("")) {
                            s = s.replace(',', '.');
                            value = new Double(s);
                        } else {
                            value = null;
                        }
                    } else {
                        value = f.getType() == 3 ? (!s.equals("") ? this.dateformat.parse(s) : null) : (f.getType() == 9 ? (!s.equals("") ? this.timeformat.parse(s) : null) : s);
                    }
                }
                if (value == null) continue;
                h.put(alias, value);
            }
            return true;
        }
        catch (ParseException e) {
            throw new DataException(e);
        }
    }
}

