/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataTargetImpl;
import is.hugvit.datapump.Field;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WebServiceDataTarget
extends DataTargetImpl {
    private Service service;

    public WebServiceDataTarget() {
        this.dateformat = DateFormat.getDateInstance(1);
    }

    @Override
    public void open() throws DataException {
        super.open();
        this.service = new Service();
        this.service.setMaintainSession(true);
    }

    @Override
    public void close() throws DataException {
        this.service = null;
    }

    @Override
    public void putRecord(Hashtable h) throws DataException {
        try {
            String service_url = this.param.getProperty("url");
            String method = this.param.getProperty("method");
            String username = this.param.getProperty("username");
            String password = this.param.getProperty("password");
            String cookie = this.param.getProperty("cookie");
            String type = this.param.getProperty("type");
            String action = this.param.getProperty("soapaction");
            String paramname = this.param.getProperty("parameter_name");
            String namespace = this.param.getProperty("namespace");
            if (type == null) {
                type = "xml";
            }
            if (paramname == null) {
                paramname = "xml";
            }
            URL url = new URL(service_url);
            Call call = (Call)this.service.createCall();
            call.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            if (username != null) {
                call.setProperty("javax.xml.rpc.security.auth.username", (Object)username);
                call.setProperty("javax.xml.rpc.security.auth.password", (Object)password);
            }
            if (cookie != null) {
                call.setProperty("Cookie", (Object)cookie);
            }
            call.setTargetEndpointAddress(url);
            if (action != null) {
                call.setSOAPActionURI(action);
            }
            QName qname = new QName(namespace, method);
            call.setOperationName(qname);
            Object[] p = new Object[1];
            if (type.equals("xml")) {
                Document doc = DocumentHelper.createDocument();
                Element root = doc.addElement("document");
                Enumeration e = this.fields.elements();
                while (e.hasMoreElements()) {
                    Field field = (Field)e.nextElement();
                    Object value = this.getValue(h, field);
                    String t = "string";
                    if (value instanceof Integer) {
                        t = "integer";
                    } else if (value instanceof Double) {
                        t = "double";
                    } else if (value instanceof Date) {
                        t = "date";
                        value = this.dateformat.format((Date)value);
                    }
                    Element item = root.addElement("item");
                    item.addAttribute("name", field.getName());
                    item.addAttribute("type", t);
                    String s = "";
                    if (value != null) {
                        s = value.toString();
                    }
                    item.addText(s);
                }
                StringWriter s = new StringWriter(8192);
                doc.write((Writer)s);
                String xml = s.toString();
                this.log.debug("xml=" + xml);
                qname = new QName(namespace, paramname);
                call.addParameter(qname, XMLType.XSD_STRING, ParameterMode.IN);
                p[0] = xml;
            } else {
                Enumeration e = this.fields.elements();
                p = new Object[this.fields.size()];
                int i = 0;
                while (e.hasMoreElements()) {
                    Field field = (Field)e.nextElement();
                    Object value = this.getValue(h, field);
                    String name = field.getName();
                    p[i] = value;
                    ++i;
                    QName t = XMLType.XSD_STRING;
                    if (value instanceof Integer) {
                        t = XMLType.XSD_INT;
                    } else if (value instanceof Double) {
                        t = XMLType.XSD_DOUBLE;
                    } else if (value instanceof Date) {
                        t = XMLType.XSD_DATE;
                    }
                    qname = new QName(namespace, name);
                    call.addParameter(qname, t, ParameterMode.IN);
                }
                this.log.debug("parameters=" + Arrays.asList(p));
            }
            this.log.debug("Calling web service: " + method);
            call.invoke(p);
        }
        catch (Exception e) {
            throw new DataException(e);
        }
    }
}

