/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataTargetImpl;
import is.hugvit.datapump.Field;
import is.hugvit.util.Util;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TextDataTarget
extends DataTargetImpl {
    protected Vector ord_fields = new Vector();
    protected BufferedWriter out;
    protected String delimeter = ";";
    protected boolean header;
    protected boolean first = true;
    protected boolean quoted = true;

    @Override
    public void addField(Field field) {
        this.ord_fields.addElement(field);
        super.addField(field);
    }

    @Override
    public void open() throws DataException {
        super.open();
        try {
            String filename = this.param.getProperty("filename");
            if (filename == null) {
                throw new DataException("filename parameter not specified");
            }
            String d = this.param.getProperty("delimeter");
            if (d != null) {
                this.delimeter = d;
            }
            this.header = (d = this.param.getProperty("header")) != null && d.equals("true");
            d = this.param.getProperty("quoted");
            if (d != null) {
                this.quoted = d.equals("true");
            }
            this.out = new BufferedWriter(new FileWriter(filename));
        }
        catch (IOException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void close() throws DataException {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void putRecord(Hashtable h) throws DataException {
        try {
            StringBuffer s = new StringBuffer(256);
            StringBuffer t = new StringBuffer(256);
            Enumeration e = this.ord_fields.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                Field f = (Field)e.nextElement();
                String alias = f.getAliasOrName();
                if (i != 0) {
                    t.append(this.delimeter);
                    s.append(this.delimeter);
                }
                t.append(alias);
                Object value = this.getValue(h, f);
                if (value != null) {
                    String v = value.toString();
                    boolean quote = false;
                    if (this.quoted) {
                        if (v.indexOf(this.delimeter) > -1) {
                            quote = true;
                        } else if (Util.hasControlChar(v)) {
                            quote = true;
                        }
                    }
                    if (quote) {
                        v = "\"" + Util.replace(v, "\"", "\"\"") + "\"";
                    }
                    s.append(v);
                }
                ++i;
            }
            if (this.header && this.first) {
                this.out.write(t.toString());
                this.out.newLine();
                this.first = false;
            }
            this.out.write(s.toString());
            this.out.newLine();
        }
        catch (Exception e) {
            throw new DataException(e);
        }
    }
}

