/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.ConstantField;
import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataSourceImpl;
import is.hugvit.datapump.Field;
import is.hugvit.io.WildcardFilenameFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TextDataSource
extends DataSourceImpl {
    protected BufferedReader in;
    protected Vector ord_fields = new Vector();
    protected File dir;
    protected String[] files;
    protected int index;
    protected char delimeter = (char)59;
    protected boolean is_csv = false;
    protected DateFormat dateformat = DateFormat.getDateInstance(3);
    protected DateFormat timeformat;

    public TextDataSource() {
        this.dateformat.setLenient(true);
        this.timeformat = DateFormat.getTimeInstance(3);
        this.timeformat.setLenient(true);
    }

    @Override
    public void open() throws DataException {
        super.open();
        try {
            String type;
            String df;
            String filename = this.param.getProperty("filename");
            if (filename == null) {
                throw new DataException("filename parameter not specified");
            }
            String s = this.param.getProperty("delimeter");
            if (s != null) {
                this.delimeter = s.charAt(0);
            }
            if ((df = this.param.getProperty("dateformat")) != null) {
                this.dateformat = new SimpleDateFormat(df);
                this.dateformat.setLenient(true);
            }
            this.is_csv = (type = this.param.getProperty("type")) != null && type.equals("csv");
            File file = new File(filename);
            this.dir = new File(file.getParent());
            this.files = this.dir.list(new WildcardFilenameFilter(file.getName()));
            if (this.files.length > 0) {
                this.in = new BufferedReader(new FileReader(new File(this.dir, this.files[this.index])));
            }
        }
        catch (IOException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void close() throws DataException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void addField(Field field) {
        this.ord_fields.addElement(field);
        super.addField(field);
    }

    private static final Object getFixed(Field f, String line) {
        String value = "";
        int start = f.getPropertyInt("start") - 1;
        if (start == -1) {
            start = 0;
        }
        int width = f.getPropertyInt("width");
        int end = f.getPropertyInt("end");
        if (start < line.length()) {
            if (width == 0 && end == 0) {
                value = line.substring(start).trim();
            } else {
                if (width != 0) {
                    end = start + width;
                }
                if (end > line.length()) {
                    end = line.length();
                }
                value = line.substring(start, end).trim();
            }
        }
        return value;
    }

    private final String[] getDelimeted(String line) {
        String[] s = new String[]{"", ""};
        if (!line.equals("")) {
            char c = line.charAt(0);
            if (c == '\"') {
                StringBuffer t = new StringBuffer(line.length());
                int len = line.length();
                int pos = 1;
                while (pos < len) {
                    if ((c = line.charAt(pos++)) == '\"') {
                        if (pos >= len) continue;
                        char v = line.charAt(pos);
                        if (v == '\"') {
                            t.append('\"');
                            ++pos;
                            continue;
                        }
                        pos += 2;
                        break;
                    }
                    t.append(c);
                }
                s[0] = t.toString();
                s[1] = line.substring(pos);
            } else {
                int p = line.indexOf(this.delimeter);
                if (p != -1) {
                    s[0] = line.substring(0, p);
                    s[1] = line.substring(p + 1);
                } else {
                    s[0] = line.substring(0);
                }
            }
        }
        return s;
    }

    private final void fillRecord(String line, Hashtable h) throws Exception {
        Enumeration e = this.ord_fields.elements();
        while (e.hasMoreElements()) {
            Object s;
            Field f = (Field)e.nextElement();
            String alias = f.getAliasOrName();
            Object value = "";
            if (f instanceof ConstantField) {
                ConstantField cf = (ConstantField)f;
                value = cf.getValue();
            } else if (this.is_csv) {
                s = this.getDelimeted(line);
                value = s[0];
                line = s[1];
            } else {
                value = TextDataSource.getFixed(f, line);
            }
            if (value != null) {
                if (f.getType() == 1) {
                    if (!(value instanceof Integer)) {
                        value = new Integer(value.toString());
                    }
                } else if (f.getType() == 3) {
                    s = (String)value;
                    value = !((String)s).equals("") ? this.dateformat.parse((String)s) : null;
                } else if (f.getType() == 9) {
                    s = (String)value;
                    value = !((String)s).equals("") ? this.timeformat.parse((String)s) : null;
                } else if (f.getType() == 2) {
                    s = (String)value;
                    if (!((String)s).equals("")) {
                        s = ((String)s).replace(',', '.');
                        value = new Double((String)s);
                    } else {
                        value = null;
                    }
                }
            }
            if (value == null) continue;
            h.put(alias, value);
        }
    }

    private final String getNextLine() throws IOException {
        String line;
        while ((line = this.in.readLine()) == null || line.equals("")) {
            this.in.close();
            String delete = this.param.getProperty("delete");
            if (delete != null && delete.equals("true")) {
                File file = new File(this.dir, this.files[this.index]);
                this.log.debug("Deleting file " + file.getAbsolutePath());
                file.delete();
            }
            ++this.index;
            if (this.index >= this.files.length) {
                return null;
            }
            this.in = new BufferedReader(new FileReader(new File(this.dir, this.files[this.index])));
        }
        return line;
    }

    @Override
    public boolean getRecord(Hashtable h) throws DataException {
        try {
            String line;
            if (this.in != null && (line = this.getNextLine()) != null) {
                this.fillRecord(line, h);
                return true;
            }
            return false;
        }
        catch (DataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataException(e);
        }
    }
}

