/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.DataException;
import is.hugvit.datapump.Field;
import is.hugvit.datapump.SQLDataSource;
import is.hugvit.sql.Null;
import is.hugvit.sql.SQLUtil;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StoredProcedureTarget
extends SQLDataSource {
    private CallableStatement cs;

    @Override
    public void open() throws DataException {
        try {
            super.open();
            String sql = this.param.getProperty("sql");
            this.log.debug("sql=" + sql);
            this.cs = this.conn.prepareCall(sql);
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void close() throws DataException {
        try {
            if (this.cs != null) {
                this.cs.close();
            }
            super.close();
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
    }

    private final Vector getValues(Hashtable h) throws DataException {
        Vector<Object> v = new Vector<Object>();
        Enumeration e = this.fields.elements();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            Object obj = this.getValue(h, f);
            if (obj == null) {
                obj = new Null(f.getSQLType());
            }
            v.addElement(obj);
        }
        return v;
    }

    @Override
    public void putRecord(Hashtable h) throws DataException {
        try {
            Vector k = this.getValues(h);
            this.log.debug("values=" + k);
            SQLUtil.setStatement(this.cs, k, 1);
            this.cs.executeUpdate();
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
        catch (IOException e) {
            throw new DataException(e);
        }
    }
}

