/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.DataException;
import is.hugvit.datapump.Field;
import is.hugvit.datapump.NotesDataSource;
import is.hugvit.io.FileInputStreamEx;
import is.hugvit.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.View;

public class NotesDataTarget
extends NotesDataSource {
    protected boolean test;
    protected boolean compute = true;
    protected boolean cache = true;
    protected Hashtable keyview = new Hashtable();

    private final void putValues(Document doc, Hashtable h) throws NotesException, IOException, DataException {
        if (this.log.getLevel() <= 0) {
            this.log.debug("values=" + h);
        }
        Enumeration e = this.fields.elements();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            Object obj = this.getValue(h, f);
            if (obj == null) {
                doc.removeItem(f.getName());
                continue;
            }
            if (obj instanceof Date) {
                DateTime dt = this.session.createDateTime((Date)obj);
                doc.replaceItemValue(f.getName(), (Object)dt);
                continue;
            }
            if (obj instanceof Item) {
                doc.removeItem(f.getName());
                doc.copyItem((Item)obj, f.getName());
                continue;
            }
            if (obj instanceof InputStream) {
                InputStream in = (InputStream)obj;
                doc.removeItem(f.getName());
                doc.removeItem(f.getName());
                RichTextItem rt = doc.createRichTextItem(f.getName());
                String filename = "file";
                if (in instanceof FileInputStreamEx) {
                    FileInputStreamEx fin = (FileInputStreamEx)in;
                    filename = fin.getFile().getName();
                }
                File file = Util.createTempFile(filename);
                FileOutputStream out = new FileOutputStream(file);
                Util.writeStream(in, out);
                in.close();
                out.close();
                rt.embedObject(1454, "", file.getAbsolutePath(), null);
                file.delete();
                continue;
            }
            Item item = doc.replaceItemValue(f.getName(), obj);
            if (f.getType() == 5) {
                item.setReaders(true);
                continue;
            }
            if (f.getType() != 6) continue;
            item.setAuthors(true);
        }
        if (this.method == 2 && this.synch != null) {
            doc.replaceItemValue(this.synch, (Object)new Integer(1));
        }
    }

    private final void createRecord(Hashtable h, Vector k) throws NotesException, IOException, DataException {
        if (this.doc != null) {
            this.doc.recycle();
        }
        this.doc = this.db.createDocument();
        this.doc.replaceItemValue("Form", (Object)this.param.getProperty("form"));
        this.putValues(this.doc, h);
        if (this.compute) {
            try {
                this.doc.computeWithForm(true, false);
            }
            catch (NotesException nex) {
                this.log.error("Could not compute doc: " + this.param.getProperty("form") + ".  " + nex.getMessage());
                throw nex;
            }
        }
        if (!this.test) {
            if (k != null) {
                this.log.debug("Creating doc " + k);
            }
            this.doc.save(true);
        }
        if (this.cache) {
            this.keyview.put(k.toString().toLowerCase(), "");
        }
        this.view.refresh();
    }

    private final void updateRecord(Hashtable h, int method) throws NotesException, IOException, DataException {
        Vector k = this.getKeyValues(h);
        if (this.doc != null) {
            this.doc.recycle();
            this.doc = null;
        }
        this.doc = this.getDocumentByKey(k);
        if (this.doc == null) {
            if (method != 5) {
                this.createRecord(h, k);
            }
        } else if (method != 6) {
            this.putValues(this.doc, h);
            if (this.compute) {
                this.doc.computeWithForm(true, false);
            }
            if (!this.test) {
                this.log.debug("Updating doc " + k);
                this.doc.save(true);
            }
        }
    }

    private final void deleteAllDocs(View view) throws NotesException {
        this.log.debug("Deleting all docs in view: " + view.getName());
        Document doc = view.getFirstDocument();
        while (doc != null) {
            Document temp = doc;
            doc = view.getNextDocument(doc);
            if (!this.test) {
                temp.remove(true);
            }
            temp.recycle();
        }
    }

    private final void synchAllDocs(View view) throws NotesException {
        if (this.synch != null) {
            this.log.debug("Resetting synch in view: " + view.getName());
            Integer value = new Integer(0);
            Document doc = view.getFirstDocument();
            int count = 0;
            while (doc != null) {
                ++count;
                doc.replaceItemValue(this.synch, (Object)value);
                doc.save(true);
                Document temp = doc;
                doc = view.getNextDocument(doc);
                temp.recycle();
            }
            this.log.debug("Resetted sync for " + count + " docs");
        }
    }

    private final void cacheKeyView() throws NotesException {
        if (!this.cache) {
            return;
        }
        this.log.info("Caching key view...");
        Document doc = this.view.getFirstDocument();
        while (doc != null) {
            Vector<Object> v = new Vector<Object>();
            Enumeration e = this.keys.elements();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Item item = doc.getFirstItem(name);
                if (item != null) {
                    if (item.getType() == 1024) {
                        DateTime dt = item.getDateTimeValue();
                        v.addElement(dt.toJavaDate());
                    } else if (item.getType() == 768) {
                        v.addElement(new Integer(item.getValueInteger()));
                    } else {
                        v.addElement(item.getValueString());
                    }
                }
                String s = v.toString().toLowerCase();
                this.log.debug("Caching " + s);
                this.keyview.put(s, "");
            }
            Document temp = doc;
            doc = this.view.getNextDocument(doc);
            temp.recycle();
        }
        this.log.info("Caching Done");
    }

    private final Document getDocumentByKey(Vector k) throws NotesException {
        String s = k.toString().toLowerCase();
        if (this.cache && this.keyview.get(s) == null) {
            this.log.debug("getDocumentByKey:Not found " + s);
            return null;
        }
        return this.view.getDocumentByKey(k, true);
    }

    @Override
    public void open() throws DataException {
        super.open();
        String s = this.param.getProperty("compute");
        if (s != null && s.equals("false")) {
            this.compute = false;
        }
        if ((s = this.param.getProperty("cache")) != null && s.equals("false")) {
            this.cache = false;
        }
        if ((s = this.getParameter("test")) == null) {
            s = "";
        }
        this.test = s.equals("true");
        if (this.test) {
            this.log.debug("Test enabled");
        }
        try {
            if (this.method == 3 || this.method == 4) {
                this.deleteAllDocs(this.view);
            } else if (this.method == 2) {
                this.synchAllDocs(this.view);
            }
            if (this.method == 1 || this.method == 2 || this.method == 5) {
                this.cacheKeyView();
            }
        }
        catch (NotesException e) {
            throw new DataException(e.text, (Exception)((Object)e));
        }
    }

    @Override
    public void stop() throws DataException {
        try {
            if (this.method == 2 && this.view != null) {
                String viewname = this.view.getName();
                this.view.recycle();
                this.view = this.db.getView(viewname);
                Document doc = this.view.getFirstDocument();
                int count = 0;
                int tcount = 0;
                while (doc != null) {
                    Document temp;
                    int i;
                    ++tcount;
                    boolean remove = false;
                    if (doc.hasItem(this.synch) && (i = doc.getItemValueInteger(this.synch)) == 0) {
                        remove = true;
                    }
                    if (remove) {
                        temp = doc;
                        doc = this.view.getNextDocument(doc);
                        temp.remove(true);
                        ++count;
                        continue;
                    }
                    temp = doc;
                    doc = this.view.getNextDocument(doc);
                    temp.recycle();
                }
                this.log.debug("Deleted " + count + " out of " + tcount + " docs in view: " + this.view.getName());
            }
        }
        catch (NotesException e) {
            throw new DataException(e.text, (Exception)((Object)e));
        }
    }

    @Override
    public void putRecord(Hashtable h) throws DataException {
        try {
            if (this.method == 1 || this.method == 2 || this.method == 5 || this.method == 6) {
                this.updateRecord(h, this.method);
            } else {
                this.createRecord(h, new Vector());
            }
        }
        catch (NotesException e) {
            throw new DataException(e.text, (Exception)((Object)e));
        }
        catch (DataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataException(e);
        }
    }
}

