/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.ConstantField;
import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataTargetImpl;
import is.hugvit.datapump.Field;
import is.hugvit.io.FileInputStreamEx;
import is.hugvit.util.Util;
import java.io.InputStream;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.RichTextItem;
import lotus.domino.Session;
import lotus.domino.View;

public class NotesDataSource
extends DataTargetImpl {
    protected Session session;
    protected Database db;
    protected View view;
    protected Document doc;
    private Document nextdoc;
    private boolean init = true;

    private static final Session createSession(boolean init, String host, String user, String password) throws NotesException {
        if (init) {
            NotesThread.sinitThread();
        }
        try {
            return NotesFactory.createSession((String)host, (String)user, (String)password);
        }
        catch (NotesException e) {
            if (init) {
                NotesThread.stermThread();
            }
            throw e;
        }
    }

    private static final void recycle(Session session, boolean init) {
        if (session != null) {
            try {
                session.recycle();
            }
            catch (NotesException notesException) {
                // empty catch block
            }
            if (init) {
                NotesThread.stermThread();
            }
        }
    }

    public Session getSession() {
        return this.session;
    }

    public Database getDatabase() {
        return this.db;
    }

    @Override
    public void open() throws DataException {
        super.open();
        try {
            String host = this.param.getProperty("host");
            String user = this.param.getProperty("user");
            String password = this.param.getProperty("password");
            this.init = host == null;
            String i = this.param.getProperty("init");
            if (i != null) {
                this.init = i.equals("true");
            }
            this.session = NotesDataSource.createSession(this.init, host, user, password);
            String server = this.param.getProperty("server");
            if (server == null) {
                server = "";
            }
            String dbname = this.param.getProperty("database");
            this.db = this.session.getDatabase(server, dbname);
            if (this.db == null) {
                throw new DataException("Database " + dbname + " not found");
            }
            String viewname = this.param.getProperty("view");
            this.view = this.db.getView(viewname);
            if (this.view == null) {
                throw new DataException("View " + viewname + " not found");
            }
            this.doc = null;
        }
        catch (NotesException e) {
            throw new DataException(e.text, (Exception)((Object)e));
        }
    }

    @Override
    public void close() throws DataException {
        NotesDataSource.recycle(this.session, this.init);
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public void backTagRecord(Hashtable h) throws DataException {
        try {
            if (!this.backtag.isEmpty()) {
                Enumeration e = this.backtag.elements();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    Object obj = h.get(name);
                    this.doc.replaceItemValue(name, obj);
                }
                this.doc.save();
            }
        }
        catch (NotesException e) {
            throw new DataException(e.text, (Exception)((Object)e));
        }
    }

    private static final InputStream getInputStream(Vector v) throws NotesException {
        if (v != null && v.size() > 0) {
            EmbeddedObject e = (EmbeddedObject)v.firstElement();
            return new FileInputStreamEx(e.getInputStream(), e.getSource());
        }
        return null;
    }

    @Override
    public boolean getRecord(Hashtable h) throws DataException {
        try {
            while (true) {
                if (this.doc == null) {
                    this.doc = this.view.getFirstDocument();
                } else {
                    this.doc.recycle();
                    this.doc = this.nextdoc;
                }
                if (this.doc == null) {
                    return false;
                }
                this.nextdoc = this.view.getNextDocument(this.doc);
                if (!this.doc.hasItem("$Conflict")) break;
                this.log.warn("Found Replication conflict document:" + this.doc.getUniversalID());
            }
            Enumeration e = this.fields.elements();
            while (e.hasMoreElements()) {
                DateTime dt;
                Object o;
                Vector v;
                Field f = (Field)e.nextElement();
                Object obj = null;
                if (f instanceof ConstantField) {
                    obj = ((ConstantField)f).getValue();
                } else if (f.getType() == 0) {
                    String name = f.getName();
                    String s = "";
                    if (name.startsWith("@")) {
                        Vector v2 = this.session.evaluate(name, this.doc);
                        if (v2.size() > 0) {
                            s = v2.firstElement().toString();
                        }
                    } else {
                        Item item = this.doc.getFirstItem(name);
                        if (item != null) {
                            if (item.getType() == 1) {
                                RichTextItem rt = (RichTextItem)item;
                                s = rt.getFormattedText(false, Integer.MAX_VALUE, Integer.MAX_VALUE);
                            } else {
                                s = item.getValueString();
                                if (s != null) {
                                    s = Util.replace(s, "\u0000", "\n");
                                }
                            }
                        }
                    }
                    if (s == null) {
                        s = "";
                    }
                    obj = s;
                } else if (f.getType() == 1) {
                    obj = new Integer(this.doc.getItemValueInteger(f.getName()));
                } else if (f.getType() == 2) {
                    obj = new Double(this.doc.getItemValueDouble(f.getName()));
                } else if (f.getType() == 3) {
                    v = this.doc.getItemValue(f.getName());
                    if (v != null && v.size() > 0 && (o = v.firstElement()) instanceof DateTime) {
                        dt = (DateTime)o;
                        obj = dt.toJavaDate();
                    }
                } else if (f.getType() == 9) {
                    v = this.doc.getItemValue(f.getName());
                    if (v != null && v.size() > 0 && (o = v.firstElement()) instanceof DateTime) {
                        dt = (DateTime)o;
                        obj = new Time(dt.toJavaDate().getTime());
                    }
                } else if (f.getType() == 10) {
                    v = this.doc.getItemValue(f.getName());
                    if (v != null && v.size() > 0 && (o = v.firstElement()) instanceof DateTime) {
                        dt = (DateTime)o;
                        obj = new Timestamp(dt.toJavaDate().getTime());
                    }
                } else if (f.getType() == 7) {
                    if (f.getName().equals("$FILE")) {
                        Item item = this.doc.getFirstItem(f.getName());
                        if (item != null) {
                            String filename = item.getValueString();
                            EmbeddedObject eo = this.doc.getAttachment(filename);
                            obj = new FileInputStreamEx(eo.getInputStream(), eo.getSource());
                        }
                    } else {
                        RichTextItem rt = (RichTextItem)this.doc.getFirstItem(f.getName());
                        if (rt != null) {
                            obj = NotesDataSource.getInputStream(rt.getEmbeddedObjects());
                        }
                    }
                } else {
                    obj = f.getType() == 8 ? this.doc.getFirstItem(f.getName()) : this.doc.getItemValue(f.getName());
                }
                if (obj == null) continue;
                String alias = f.getAlias();
                if (alias == null) {
                    alias = f.getName();
                }
                h.put(alias, obj);
            }
            return true;
        }
        catch (NotesException e) {
            throw new DataException(e.text, (Exception)((Object)e));
        }
    }
}

