/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataTargetImpl;
import is.hugvit.net.SMTP;
import is.hugvit.net.SMTPException;
import java.io.IOException;
import java.util.Hashtable;

public class EmailDataTarget
extends DataTargetImpl {
    private SMTP mail;
    private int count;
    private int maxcount;
    private int max;
    private int retry;
    private int retry_interval;

    @Override
    public void open() throws DataException {
        this.max = this.getParameterInt("max", -1);
        this.retry = this.getParameterInt("retry", 6);
        this.retry_interval = this.getParameterInt("retry_interval", 10);
        try {
            this.mail = this.getSMTP();
        }
        catch (IOException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void close() throws DataException {
        try {
            if (this.mail != null) {
                this.mail.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final SMTP getSMTP() throws IOException {
        String charset;
        String host = this.getParameter("host");
        if (host.equals("")) {
            host = null;
        }
        SMTP mail = new SMTP(host);
        String contenttype = this.getParameter("contenttype");
        if (!contenttype.equals("")) {
            mail.setContentType(contenttype);
        }
        if (!(charset = this.getParameter("charset")).equals("")) {
            mail.setCharset(charset);
        }
        this.log.debug("opening new socket");
        return mail;
    }

    private final void sendMail(Hashtable h, SMTP mail) throws IOException {
        mail.setFrom((String)h.get("from"));
        String fromname = (String)h.get("fromname");
        if (fromname != null) {
            mail.setFromName(fromname);
        }
        mail.setSubject((String)h.get("subject"));
        mail.setBody((String)h.get("body"));
        mail.send((String)h.get("sendto"));
    }

    private static final void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void putRecord(Hashtable h) throws DataException {
        block8: {
            String sendto = (String)h.get("sendto");
            try {
                ++this.maxcount;
                ++this.count;
                if (this.maxcount >= this.max) {
                    SMTP temp = this.getSMTP();
                    this.close();
                    this.mail = temp;
                    this.maxcount = 0;
                }
                try {
                    this.sendMail(h, this.mail);
                }
                catch (SMTPException e1) {
                    this.log.warn("[" + this.count + "] Skipping: " + sendto + " (" + e1.getMessage() + ")");
                    this.close();
                    this.mail = this.getSMTP();
                    this.maxcount = 0;
                }
            }
            catch (IOException e2) {
                IOException e = e2;
                this.log.warn("[" + this.count + "] " + sendto + ", retrying... (" + e.getMessage() + ")");
                boolean success = false;
                for (int i = 0; i < this.retry; ++i) {
                    EmailDataTarget.sleep(this.retry_interval * 1000);
                    try {
                        this.close();
                        this.mail = this.getSMTP();
                        this.sendMail(h, this.mail);
                        success = true;
                        break;
                    }
                    catch (IOException e3) {
                        e = e3;
                        continue;
                    }
                }
                if (success) break block8;
                throw new DataException("[" + this.count + "] " + sendto, e);
            }
        }
    }
}

