/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.ConstantField;
import is.hugvit.datapump.Criteria;
import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataSourceImpl;
import is.hugvit.datapump.DataTarget;
import is.hugvit.datapump.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DataTargetImpl
extends DataSourceImpl
implements DataTarget {
    protected int method;
    protected String synch = "SYNCH";
    protected boolean done;
    protected Criteria criteria;
    protected DateFormat dateformat = DateFormat.getDateInstance(3);

    protected DataTargetImpl() {
        this.dateformat.setLenient(true);
    }

    @Override
    public void open() throws DataException {
        String df = this.param.getProperty("dateformat");
        if (df != null) {
            this.dateformat = new SimpleDateFormat(df);
            this.dateformat.setLenient(true);
        }
    }

    @Override
    public void setCriteria(Criteria c) {
        this.criteria = c;
    }

    @Override
    public Criteria getCriteria() {
        return this.criteria;
    }

    protected final Vector getKeyValues(Hashtable h) {
        Vector v = new Vector();
        Enumeration e = this.keys.elements();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Field f = (Field)this.fields.get(key);
            String alias = f.getAlias();
            if (alias == null) {
                alias = key;
            }
            Object value = h.get(alias);
            v.addElement(value);
        }
        return v;
    }

    protected final Object getValue(Hashtable h, Field f) throws DataException {
        try {
            String s;
            if (f instanceof ConstantField) {
                return ((ConstantField)f).getValue();
            }
            String alias = f.getAlias();
            if (alias == null) {
                alias = f.getName();
            }
            Object v = h.get(alias);
            int type = f.getType();
            if (v != null && Field.getType(v) != type && !(s = v.toString()).equals("")) {
                if (type == 2) {
                    s = s.replace(',', '.');
                    v = new Double(s);
                } else if (type == 1) {
                    v = new Integer(s);
                } else if (type == 3) {
                    v = this.dateformat.parse(s);
                }
            }
            return v;
        }
        catch (ParseException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void putRecord(Hashtable h) throws DataException {
    }

    @Override
    public void setMethod(int method) {
        this.method = method;
    }

    @Override
    public int getMethod() {
        return this.method;
    }

    @Override
    public void setSynch(String name) {
        this.synch = name;
    }
}

