/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.licence;

import java.security.MessageDigest;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LicenceModule {
    private String name;
    private String version;
    private String validFrom;
    private String validTo;
    private String licenceKey;
    private int numberOfUsers = -66;
    private boolean isValid = false;

    public LicenceModule(String name, String version, String key) {
        this.name = name;
        this.version = version;
        this.licenceKey = key;
    }

    public LicenceModule() {
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getValidTo() {
        return this.validTo;
    }

    public void setValidTo(String validTo) {
        this.validTo = validTo;
    }

    public String getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(String validFrom) {
        this.validFrom = validFrom;
    }

    public String getLicenceKey() {
        return this.licenceKey;
    }

    public void setLicenceKey(String licenceKey) {
        this.licenceKey = licenceKey;
    }

    public int getNumberOfUsers() {
        return this.numberOfUsers;
    }

    public void setNumberOfUsers(int numberOfUsers) {
        this.numberOfUsers = numberOfUsers;
    }

    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"module");
        if (this.name != null) {
            el.addElement("name").setText(this.name);
        }
        if (this.licenceKey != null) {
            el.addElement("licencekey").setText(this.licenceKey);
        }
        if (this.numberOfUsers == -66) {
            el.addElement("users").setText("Unlimited");
        } else {
            el.addElement("users").setText("" + this.numberOfUsers);
        }
        if (this.validFrom != null) {
            el.addElement("validfrom").setText(this.validFrom);
        }
        if (this.validTo != null) {
            el.addElement("validto").setText(this.validTo);
        }
        if (this.version != null) {
            el.addElement("version").setText(this.version);
        }
        el.addElement("isvalid").setText(this.isValid ? "true" : "false");
        return el;
    }

    public void validateLicence(String serverId, String customerId) {
        String validKey = this.generateKey(serverId, customerId);
        if (validKey.equals(this.licenceKey)) {
            this.isValid = true;
        }
    }

    private String generateKey(String serverId, String customerId) {
        try {
            String seed = "holeinone" + customerId + serverId + this.name;
            if (this.numberOfUsers != -66) {
                seed = seed + this.numberOfUsers;
            }
            if (!"".equalsIgnoreCase(this.validFrom)) {
                seed = seed + this.validFrom;
            }
            if (!"".equalsIgnoreCase(this.validTo)) {
                seed = seed + this.validTo;
            }
            seed = seed + this.version;
            byte[] buffer = seed.getBytes("UTF-8");
            byte[] result = null;
            StringBuffer buf = null;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            result = new byte[md5.getDigestLength()];
            md5.reset();
            md5.update(buffer);
            result = md5.digest();
            buf = new StringBuffer(result.length * 2);
            for (int i = 0; i < result.length; ++i) {
                int intVal = result[i] & 0xFF;
                if (intVal < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(intVal));
            }
            return buf.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

