/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.licence;

import is.hugvit.bird.BirdComponentBase;
import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.core.BirdInstallHelper;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.bird.licence.LicenceService;
import java.io.InputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class Install
extends BirdComponentBase {
    private static final Properties p = new Properties();
    static ResourceBundle lang;
    private static Document idoc;

    @Override
    public Properties getInfo() {
        return p;
    }

    @Override
    public void install(BirdSession context) throws BirdException {
        lang = ResourceBundle.getBundle("is.hugvit.bird.licence.bird_licence", context.getLocale());
        BirdDatabase db = context.getDatabase();
        this.loadInstallXML();
        BirdInstallHelper helper = new BirdInstallHelper(idoc, lang, this);
        helper.Install(context, db);
        BirdUtil.insertMenu(db, "administrator", lang.getString("menu.licence"), "bird:licence", "bird_licence.html", "licence.gif");
    }

    @Override
    public void start(BirdSession context) throws BirdException {
        super.start(context);
        lang = ResourceBundle.getBundle("is.hugvit.bird.licence.bird_licence", context.getLocale());
        LicenceService.init(context.getDatabase());
    }

    @Override
    public void stop(BirdSession context) throws BirdException {
        super.stop(context);
    }

    @Override
    public void uninstall(BirdSession context) throws BirdException {
        BirdDatabase db = context.getDatabase();
        BirdUtil.deleteMenu(db, "bird:licence");
        this.loadInstallXML();
        BirdInstallHelper helper = new BirdInstallHelper(idoc, lang, this);
        helper.Uninstall(context, context.getDatabase(), false);
    }

    private void loadInstallXML() throws BirdException {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("install.xml");
            SAXReader reader = new SAXReader();
            idoc = reader.read(is);
        }
        catch (Exception ex) {
            throw new BirdException("Could not read the install.xml", ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                throw new BirdException(ex);
            }
        }
    }

    static {
        p.put("name", "Bird:Licence Manager");
        p.put("version", "1.0.0");
    }
}

