/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.core;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.util.Util;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public final class WebXmlMenu
extends WebElementBase {
    private static final OutputFormat format;
    private static ResourceBundle lang;
    private static int idCounter;

    @Override
    public void doGet(WebContext context) throws BirdException {
        try {
            String top_name;
            Element page_menu;
            idCounter = 0;
            HttpServletRequest req = context.getRequest();
            DocumentFactory dfact = new DocumentFactory();
            Document doc = dfact.createDocument();
            Element root = doc.addElement("tree");
            root.addAttribute("id", "0");
            WebXmlMenu.doMenu(context, root);
            if (lang == null) {
                lang = ResourceBundle.getBundle("is.hugvit.bird.client.bird_client", context.getSession().getLocale());
            }
            if ((page_menu = WebXmlMenu.getItem(root, top_name = lang.getString("menu.pages"))) != null) {
                Connection dc = (Connection)context.getAttribute("bird.connection");
                String id = req.getParameter("id");
                if (id == null) {
                    id = "";
                }
                page_menu.addElement("id").addText("");
                WebXmlMenu.doFolders(dc, page_menu, "", id, context);
            } else {
                System.out.println("Warning: No page menu root found. (" + top_name + ")");
            }
            HttpServletResponse res = context.getResponseExclusive();
            res.setContentType("application/xml; charset=UTF-8");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(doc);
            writer.close();
            out.close();
        }
        catch (Exception ex) {
            throw new BirdException(ex);
        }
    }

    private static final Element addItem(Element folder, String name, String url, String id) {
        Element item = folder.addElement("item");
        item.addAttribute("text", name);
        if (url != null) {
            item.addAttribute("url", url);
            Element elurl = item.addElement("userdata");
            elurl.addAttribute("name", "url");
            elurl.setText(url);
        }
        item.addAttribute("id", ++idCounter + "");
        return item;
    }

    private static final Element addBranch(Element root, String name, String url, String id) {
        Element folder = root;
        StringTokenizer e = new StringTokenizer(name, "\\");
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            Element f = (Element)folder.selectSingleNode("item[@text='" + n + "']");
            if (f == null) {
                folder = WebXmlMenu.addItem(folder, n, url, id);
                continue;
            }
            folder = f;
        }
        return folder;
    }

    private static final Element getItem(Element root, String name) {
        Element folder = root;
        int i = name.lastIndexOf("\\");
        if (i > -1) {
            String path = name.substring(0, i);
            name = name.substring(i + 1);
            StringTokenizer e = new StringTokenizer(path, "\\");
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                folder = (Element)folder.selectSingleNode("item[@text='" + n + "']");
            }
        }
        if (folder == null) {
            return null;
        }
        Element item = (Element)folder.selectSingleNode("item[@text='" + name + "']");
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doMenu(WebContext context, Element menu) throws BirdException {
        try {
            Connection dc = (Connection)context.getAttribute("bird.connection");
            try (PreparedStatement stmt = dc.prepareStatement("select name,url,role,icon from bird_menu order by name");
                 ResultSet rd = stmt.executeQuery();){
                while (rd.next()) {
                    String name = rd.getString(1);
                    String url = rd.getString(2);
                    String[] role = Util.splitArray(rd.getString(3), ";");
                    String icon = rd.getString(4);
                    if (!context.isUserInAllRoles(role)) continue;
                    Element folder = menu;
                    int i = name.lastIndexOf("\\");
                    if (i > -1) {
                        folder = WebXmlMenu.addBranch(menu, name.substring(0, i), null, null);
                        name = name.substring(i + 1);
                    }
                    Element item = WebXmlMenu.addItem(folder, name, url, null);
                    if (icon == null || icon.equals("")) continue;
                    item.addAttribute("im0", icon);
                }
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doFolders(Connection dc, Element folder, String parent, String fid, WebContext context) throws BirdException {
        try {
            PreparedStatement stmt = dc.prepareStatement("select role,id,title from bird_page where type='FOLDER' and folder=? order by sort");
            stmt.setString(1, parent);
            ResultSet rd = stmt.executeQuery();
            try {
                while (rd.next()) {
                    Element icon;
                    String[] role = Util.splitArray(rd.getString(1), ";");
                    String id = rd.getString(2);
                    String name = rd.getString(3);
                    if (!context.isUserInAllRoles(role)) continue;
                    Element item = WebXmlMenu.addItem(folder, name, "bird_pages.html?id=" + id, id);
                    Element mx = item.addElement("userdata");
                    mx.setText("folder");
                    mx.addAttribute("name", "type");
                    Element mx2 = item.addElement("userdata");
                    mx2.setText(id);
                    mx2.addAttribute("name", "folder_id");
                    if (id.equals(fid)) {
                        item.addAttribute("open", "1");
                    }
                    if ((icon = folder.element("icon")) != null) {
                        item.addAttribute("im0", icon.getText());
                    } else {
                        item.addAttribute("im0", "folderClosed.gif");
                        item.addAttribute("im1", "folderOpen.gif");
                        item.addAttribute("im2", "folderClosed.gif");
                    }
                    WebXmlMenu.doFolders(dc, item, id, fid, context);
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    static {
        idCounter = 0;
        format = OutputFormat.createCompactFormat();
        format.setEncoding("UTF-8");
        format.setSuppressDeclaration(false);
        format.setOmitEncoding(false);
    }
}

