/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.core;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WebBirdForm
extends WebForm {
    protected String table = "";
    protected String redirect = "";

    public final void setTable(String table) {
        this.table = table;
    }

    public final void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    @Override
    public void doDelete(WebContext context, Form data) throws BirdException {
        String id = data.getID();
        if (!id.equals("")) {
            try {
                Connection dc = (Connection)context.getAttribute("bird.connection");
                PreparedStatement stmt = dc.prepareStatement("delete from " + this.table + " where id=?");
                stmt.setString(1, data.getID());
                stmt.executeUpdate();
                stmt.close();
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
        context.setRedirectPage(this.redirect);
    }

    @Override
    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            if (data.isCreate()) {
                return true;
            }
            Connection dc = (Connection)context.getAttribute("bird.connection");
            Vector f = new Vector();
            Enumeration e = this.fields.keys();
            while (e.hasMoreElements()) {
                f.addElement(e.nextElement());
            }
            String s = Util.expand(f, ",");
            PreparedStatement stmt = dc.prepareStatement("select " + s + " from " + this.table + " where id=?");
            stmt.setString(1, data.getID());
            ResultSet rd = stmt.executeQuery();
            if (rd.next()) {
                int i = 1;
                Enumeration e2 = this.fields.keys();
                while (e2.hasMoreElements()) {
                    String name = (String)e2.nextElement();
                    Field field = (Field)this.fields.get(name);
                    if (field.getType() == 5) {
                        data.put(name, Util.split(rd.getString(i), ";"));
                    } else if (field.getType() == 0) {
                        data.put(name, rd.getString(i));
                    } else {
                        data.put(name, rd.getObject(i));
                    }
                    ++i;
                }
            }
            rd.close();
            return true;
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    @Override
    public void doSave(WebContext context, Form data) throws BirdException {
        Connection c = (Connection)context.getAttribute("bird.connection");
        Hashtable h = data.getHashtable();
        h.put("modified", new Timestamp(System.currentTimeMillis()));
        h.put("modified_by", context.getRequest().getRemoteUser());
        if (data.isCreate()) {
            h.put("id", UID.getUID());
            BirdUtil.insert(c, this.table, h);
        } else {
            Hashtable<String, String> key = new Hashtable<String, String>();
            key.put("id", data.getID());
            BirdUtil.update(c, this.table, h, key);
        }
        context.setRedirectPage(this.redirect);
    }
}

