/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;

public final class WebUser
extends WebElementBase {
    @Override
    public final void doGet(WebContext context) throws BirdException {
        HttpServletRequest req = context.getRequest();
        String user = req.getRemoteUser();
        if (this.isWebSphere(context.getSession().getServletContext())) {
            context.getRootElement().addAttribute("websphere", "true");
        }
        if (user != null) {
            Element root = context.getRootElement();
            Element u = root.addElement("bird_user");
            u.addElement("name").addText(user);
            Element r = u.addElement("roles");
            if (context.isUserInRole("super_administrator")) {
                r.addElement("super_administrator");
            }
            if (context.isUserInRole("designer")) {
                r.addElement("designer");
            }
            if (context.isUserInRole("administrator")) {
                r.addElement("administrator");
            }
            if (context.isUserInRole("editor")) {
                r.addElement("editor");
            }
        }
    }

    private final boolean isWebSphere(ServletContext context) {
        String serverInfo = context.getServerInfo();
        if (serverInfo != null) {
            return serverInfo.toLowerCase().contains("websphere");
        }
        return false;
    }
}

