/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.net.HttpUtil;
import is.hugvit.util.Util;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;

public final class WebServer
extends WebElementBase {
    @Override
    public final void doGet(WebContext context) throws BirdException {
        BirdSession session = context.getSession();
        HttpServletRequest req = context.getRequest();
        Element root = context.getRootElement();
        String baseurl = HttpUtil.getServletURL(req);
        Element item = root.addElement("bird_server");
        item.addElement("baseurl").addText(baseurl);
        String encoding = (String)session.getConfig().get("encoding");
        item.addElement("encoding").addText(encoding);
        item.addElement("dateformat").addText(Util.getShortDatePattern());
        String locale = context.getSession().getLocale().getLanguage();
        if (locale != null && !"".equals(locale)) {
            item.addElement("locale").addText(locale);
        }
        String format = Util.getDatePattern(3, context.getSession().getLocale());
        String dhtmlx = Util.convertToDhtmlxDateFormat(format);
        item.addElement("dateformatdhtmlx").addText(dhtmlx);
    }
}

