/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.util.Util;
import is.hugvit.xml.XMLUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.dom4j.Element;

public final class WebSQLQuery
extends WebElementBase {
    public WebSQLQuery() {
        this.desc = "Runs a general sql query and returns the result in the following xml format:<resultset><row><field1>fieldvalue1</field1><field2>fieldvalue2</field2></row></resultset>";
    }

    private static final Connection getConnection(WebContext context) throws Exception {
        String password;
        String pool = context.getParameter("pool");
        if (pool != null) {
            return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + pool);
        }
        String driver = context.getParameter("driver");
        if (driver == null) {
            return null;
        }
        Driver d = (Driver)Class.forName(driver).newInstance();
        String connstring = context.getParameter("connection");
        Properties p = new Properties();
        String user = context.getParameter("user");
        if (user != null) {
            p.put("user", user);
        }
        if ((password = context.getParameter("password")) != null) {
            p.put("password", password);
        }
        return d.connect(connstring, p);
    }

    private static final String extractParameters(String sql, ArrayList v) {
        StringBuffer s = new StringBuffer(sql.length());
        int p1 = sql.indexOf(123);
        int p2 = 0;
        while (p1 > -1) {
            s.append(sql.substring(p2, p1));
            s.append('?');
            p2 = sql.indexOf(125, p1 + 1);
            String name = sql.substring(p1 + 1, p2);
            v.add(name);
            p1 = sql.indexOf(123, ++p2);
        }
        s.append(sql.substring(p2));
        return s.toString();
    }

    private static final boolean setStatementValues(ArrayList v, HttpServletRequest req, PreparedStatement stmt) throws SQLException, ParseException {
        HttpSession session = req.getSession();
        for (int i = 0; i < v.size(); ++i) {
            String t;
            String s = (String)v.get(i);
            if (s.charAt(0) == '%') {
                java.util.Date date = new java.util.Date();
                t = req.getParameter(s.substring(1));
                if (t == null) {
                    java.util.Date d2 = (java.util.Date)session.getAttribute(s.substring(1));
                    if (d2 == null) {
                        return false;
                    }
                    date = d2;
                } else if (!t.equals("")) {
                    date = Util.isoToDate(t);
                }
                stmt.setDate(i + 1, new Date(date.getTime()));
                continue;
            }
            if (s.charAt(0) == '#') {
                int n = 0;
                t = req.getParameter(s.substring(1));
                if (t == null) {
                    Integer j = (Integer)session.getAttribute(s.substring(1));
                    if (j == null) {
                        return false;
                    }
                    n = j;
                } else if (!t.equals("")) {
                    n = Integer.parseInt(t);
                }
                stmt.setInt(i + 1, n);
                continue;
            }
            String value = req.getParameter(s);
            if (value == null && (value = (String)session.getAttribute(s)) == null) {
                return false;
            }
            stmt.setString(i + 1, value);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doGet(WebContext context) throws BirdException {
        try {
            boolean newconn = true;
            Connection c = WebSQLQuery.getConnection(context);
            try {
                String root;
                if (c == null) {
                    c = (Connection)context.getAttribute("bird.connection");
                    newconn = false;
                }
                if ((root = context.getParameter("root")) == null) {
                    root = "resultset";
                }
                Element result = context.getRootElement().addElement(root);
                int max = context.getParameterInt("max", 0);
                String name = context.getParameter("name");
                if (name != null) {
                    result.addAttribute("name", name);
                }
                HttpServletRequest req = context.getRequest();
                String sql = context.getParameter("sql");
                if (sql == null) {
                    return;
                }
                ArrayList v = new ArrayList();
                sql = WebSQLQuery.extractParameters(sql, v);
                try (PreparedStatement stmt = c.prepareStatement(sql);){
                    stmt.setMaxRows(max);
                    if (!WebSQLQuery.setStatementValues(v, req, stmt)) {
                        return;
                    }
                    try (ResultSet rs = stmt.executeQuery();){
                        Properties p = new Properties();
                        Map param = context.getParameters();
                        for (String key : param.keySet()) {
                            if (!key.startsWith("format.")) continue;
                            String value = (String)param.get(key);
                            p.put(key.substring(7), value);
                        }
                        String row = context.getParameter("row", "row");
                        XMLUtil.toXML(result, rs, p, row);
                    }
                }
            }
            finally {
                if (newconn) {
                    c.close();
                }
            }
        }
        catch (BirdException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }
}

