/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.net.HttpUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public final class WebRSS
extends WebElementBase {
    private static final String RSS = "http://purl.org/rss/1.0/";
    private static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String DC = "http://purl.org/dc/elements/1.1/";
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final OutputFormat format = OutputFormat.createCompactFormat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doGet(WebContext context) throws BirdException {
        try {
            HttpServletRequest req = context.getRequest();
            String server = HttpUtil.getPathURL(req);
            String listname = context.getParameter("list", "");
            int count = context.getParameterInt("count", 0);
            Connection dc = (Connection)context.getAttribute("bird.connection");
            DocumentFactory dfact = new DocumentFactory();
            Element root = dfact.createElement("rdf:RDF");
            root.addNamespace("rss", RSS);
            root.addNamespace("rdf", RDF);
            root.addNamespace("dc", DC);
            Document doc = dfact.createDocument(root);
            Element channel = root.addElement("rss:channel");
            channel.addAttribute("rdf:about", server);
            channel.addElement("rss:title").addText(listname);
            channel.addElement("rss:link").addText(server);
            Element seq = channel.addElement("rss:items").addElement("rdf:Seq");
            StringBuffer s = new StringBuffer(128);
            s.append("select ");
            s.append("title,name,pagedate,description,listimage");
            s.append(",author");
            s.append(" from bird_page ");
            s.append("where type='PAGE' and visible='1' and status='APPROVED' and lists like ? and (startdate is null or startdate<=?) and (enddate is null or enddate>=?)");
            s.append(" order by pagedate desc");
            try (PreparedStatement stmt = dc.prepareStatement(s.toString());){
                stmt.setMaxRows(count);
                Date now = new Date(System.currentTimeMillis());
                stmt.setString(1, '%' + listname + ";%");
                stmt.setDate(2, now);
                stmt.setDate(3, now);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        String title = rs.getString(1);
                        String name = rs.getString(2);
                        Date date = rs.getDate(3);
                        String desc = rs.getString(4);
                        String author = rs.getString(6);
                        String url = server + '/' + name;
                        seq.addElement("rdf:li").addAttribute("rdf:resource", url);
                        Element item = channel.addElement("item");
                        item.addAttribute("rdf:about", url);
                        item.addElement("rss:title").addText(title);
                        item.addElement("rss:link").addText(url);
                        if (desc != null) {
                            item.addElement("rss:description").addText(desc);
                        }
                        if (author != null) {
                            item.addElement("dc:creator").addText(author);
                        }
                        item.addElement("dc:date").addText(df.format(date));
                    }
                }
            }
            HttpServletResponse res = context.getResponseExclusive();
            res.setContentType("application/xml; charset=UTF-8");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(doc);
            writer.close();
            out.close();
        }
        catch (IOException e) {
            throw new BirdException(e);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    static {
        format.setEncoding("UTF-8");
        format.setSuppressDeclaration(false);
        format.setOmitEncoding(false);
    }
}

