/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.net.URLEncoder;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;

public final class WebPageIndex
extends WebElementBase {
    private static final String INDEX = "select distinct(upper(substr((title),1,1))) from bird_page where type='PAGE' and visible='1' and not (name like 'admin/%') order by upper(substr((title),1,1))";
    private static final String PAGES = "select title,name,pagedate,description from bird_page where type='PAGE' and visible='1' and not (name like 'admin/%') and upper(substr(title,1,1))=? order by title";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doIndex(Element root, Connection c) throws SQLException {
        try (PreparedStatement stmt = c.prepareStatement(INDEX);){
            Element r = root.addElement("bird_index");
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String s = rs.getString(1);
                    Element t = r.addElement("char");
                    t.addText(s);
                    t.addAttribute("encoded", URLEncoder.encode(s));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doPages(WebContext context, Element root, Connection c, String chr) throws SQLException {
        DateFormat df = DateFormat.getDateInstance(3);
        String dateformat = context.getParameter("dateformat");
        if (dateformat != null) {
            df = new SimpleDateFormat(dateformat);
        }
        stmt.setString(1, chr);
        try (PreparedStatement stmt = c.prepareStatement(PAGES);){
            Element r = root.addElement("bird_pages");
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Element item = r.addElement("page");
                    item.addElement("title").addText(rs.getString(1));
                    item.addElement("name").addText(rs.getString(2));
                    Date d = rs.getDate(3);
                    Element date = item.addElement("date");
                    date.addText(Util.dateToISO(d));
                    date.addAttribute("text", df.format(d));
                    String desc = rs.getString(4);
                    if (desc == null) continue;
                    item.addElement("description").addText(desc);
                }
            }
        }
    }

    @Override
    public final void doGet(WebContext context) throws BirdException {
        try {
            Element root = context.getRootElement();
            Connection c = (Connection)context.getAttribute("bird.connection");
            WebPageIndex.doIndex(root, c);
            HttpServletRequest req = context.getRequest();
            String param = context.getParameter("param", "c");
            String chr = req.getParameter(param);
            if (chr != null && !chr.equals("")) {
                WebPageIndex.doPages(context, root, c, chr.toUpperCase());
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }
}

