/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;

public final class WebNotesSession
extends WebElementBase {
    private Session session;

    static final Session createSession(String server, String user, String password) throws NotesException {
        if (server == null) {
            NotesThread.sinitThread();
        }
        try {
            return NotesFactory.createSession((String)server, (String)user, (String)password);
        }
        catch (NotesException e) {
            if (server == null) {
                NotesThread.stermThread();
            }
            throw e;
        }
    }

    static final void recycle(Session session, boolean thread_session) throws NotesException {
        if (session != null) {
            try {
                session.recycle();
            }
            finally {
                if (thread_session) {
                    NotesThread.stermThread();
                }
            }
        }
    }

    @Override
    public final void init(WebContext context) throws BirdException {
        try {
            String server = context.getParameter("server");
            String user = context.getParameter("user");
            String password = context.getParameter("password");
            this.session = WebNotesSession.createSession(server, user, password);
            context.setAttribute("notes.session", this.session);
        }
        catch (NotesException e) {
            throw new BirdException(e.text, (Exception)((Object)e));
        }
    }

    @Override
    public final void destroy(WebContext context) throws BirdException {
        try {
            String server = context.getParameter("server");
            WebNotesSession.recycle(this.session, server == null);
        }
        catch (NotesException e) {
            throw new BirdException(e.text, (Exception)((Object)e));
        }
    }
}

