/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.Field;
import is.hugvit.bird.WebContext;
import is.hugvit.io.FileInputStreamEx;
import is.hugvit.net.MultipartRequest;
import is.hugvit.net.QueryString;
import is.hugvit.net.ServletMultipartRequest;
import is.hugvit.sql.Null;
import is.hugvit.util.HashtableEx;
import is.hugvit.util.PropertiesEx;
import is.hugvit.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;

public final class Form {
    private HashtableEx h = new HashtableEx();
    private String name = "";
    private String action = "";
    private String id = "";
    private String error = "";
    private String message = "";
    private DateFormat timeformat = new SimpleDateFormat("HH:mm");
    private DateFormat dateformatloc = DateFormat.getDateInstance(3, Locale.getDefault());
    private DateFormat dateformat = DateFormat.getDateInstance(3);
    private DateFormat datetimeformat = DateFormat.getDateTimeInstance(3, 3);
    private boolean usenull = true;
    private static final int MAX_SIZE = 0xFA00000;
    private MultipartRequest mp;

    Form() {
    }

    Form(boolean usenull) {
        this.usenull = usenull;
    }

    Form(String name) {
        this.name = name;
    }

    Form(String name, HttpServletRequest req) throws IOException {
        this.name = name;
        if (req.getContentType() != null && req.getContentType().startsWith("multipart/form-data")) {
            File dir = Util.getTempDirectory();
            this.mp = dir.exists() ? new ServletMultipartRequest(req, dir.getAbsolutePath(), 0xFA00000) : new ServletMultipartRequest(req, 0xFA00000);
            Enumeration e = this.mp.getParameterNames();
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                this.h.put(n, this.mp.getParameterObject(n));
            }
        } else {
            ServletInputStream in = req.getInputStream();
            QueryString qs2 = new QueryString((InputStream)in);
            in.close();
            Enumeration e = qs2.getParameterNames();
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                this.addParam(n, qs2.getParameterValues(n));
            }
        }
    }

    final boolean validateAndConvert(Hashtable fields, WebContext context) {
        Enumeration e = fields.elements();
        while (e.hasMoreElements()) {
            Field field = (Field)e.nextElement();
            String name = field.getName();
            int type = field.getType();
            String value = this.getString(name);
            if (field.getRequired() && value.equals("")) {
                this.setError(name);
                return false;
            }
            if (type == 2) {
                boolean b = value.equals("1");
                this.h.put(name, new Boolean(b));
                continue;
            }
            if (type == 5) {
                Object obj = this.h.get(name);
                if (obj == null) {
                    this.h.put(name, new Vector());
                }
                if (!(obj instanceof String)) continue;
                Vector v = new Vector();
                if (!value.equals("")) {
                    v.addElement(obj);
                }
                this.h.put(name, v);
                continue;
            }
            if (type == 1) {
                if (value.equals("")) {
                    if (!this.usenull) continue;
                    this.h.put(name, new Null(4));
                    continue;
                }
                try {
                    this.h.put(name, new Integer(Integer.parseInt(value)));
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.setError(name);
                    return false;
                }
            }
            if (type == 3) {
                if (value.equals("")) {
                    if (!this.usenull) continue;
                    this.h.put(name, new Null(92));
                    continue;
                }
                try {
                    Date date = this.timeformat.parse(value);
                    this.h.put(name, new Time(date.getTime()));
                    continue;
                }
                catch (ParseException ex) {
                    this.setError(name);
                    return false;
                }
            }
            if (type == 7) {
                if (value.equals("")) {
                    if (!this.usenull) continue;
                    this.h.put(name, new Null(93));
                    continue;
                }
                try {
                    Date date = this.datetimeformat.parse(value);
                    this.h.put(name, new Timestamp(date.getTime()));
                    continue;
                }
                catch (ParseException ex) {
                    this.setError(name);
                    return false;
                }
            }
            if (type != 4) continue;
            if (value.equals("")) {
                if (!this.usenull) continue;
                this.h.put(name, new Null(91));
                continue;
            }
            try {
                Date date = this.dateformatloc.parse(value);
                this.h.put(name, new Date(date.getTime()));
            }
            catch (ParseException ex) {
                try {
                    Date date = this.dateformat.parse(value);
                    this.h.put(name, new Date(date.getTime()));
                }
                catch (ParseException pex) {
                    Date date = this.parseDate(value, context);
                    if (date != null) {
                        this.h.put(name, new Date(date.getTime()));
                        continue;
                    }
                    System.out.println(pex.getMessage());
                    this.setError(name);
                    return false;
                }
            }
        }
        return true;
    }

    private final void addParam(String n, String[] s) {
        if (s.length == 1) {
            this.h.put(n, s[0]);
        } else {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < s.length; ++i) {
                v.addElement(s[i]);
            }
            this.h.put(n, v);
        }
    }

    public final String getString(String name) {
        return this.getString(name, "");
    }

    public final InputStream getInputStream(String strName) throws IOException {
        InputStream in = null;
        if (this.mp != null) {
            File file = this.mp.getFile(strName);
            in = file != null ? new FileInputStreamEx(file) : this.mp.getInputStream(strName);
        }
        return in;
    }

    public final String getFilename(String strName) {
        String name = null;
        if (this.mp != null) {
            name = this.mp.getFileSystemName(strName);
        }
        return name;
    }

    public final Hashtable getHtFiles() {
        Hashtable htFiles = null;
        if (this.mp != null) {
            htFiles = this.mp.getHtFiles();
        }
        return htFiles;
    }

    public final String getString(String name, String def) {
        Object obj = this.h.get(name);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Vector) {
            Vector v = (Vector)obj;
            return (String)v.firstElement();
        }
        return obj.toString();
    }

    public final boolean getBoolean(String name) {
        Object obj = this.h.get(name);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        String s = (String)this.h.get(name);
        if (s == null) {
            s = "";
        }
        return s.equals("1") || s.equals("true");
    }

    public final int getInt(String name) {
        Object obj = this.h.get(name);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return i;
        }
        return Integer.parseInt(obj.toString());
    }

    public final Date getDate(String name) {
        Object obj = this.h.get(name);
        if (obj instanceof Date) {
            return (Date)obj;
        }
        return null;
    }

    public final Time getTime(String name) {
        Object obj = this.h.get(name);
        if (obj instanceof Time) {
            return (Time)obj;
        }
        return null;
    }

    public final Timestamp getTimestamp(String name) {
        Object obj = this.h.get(name);
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        return null;
    }

    public final Object get(String name) {
        return this.h.get(name);
    }

    public final void put(String name, String s) {
        if (s == null) {
            s = "";
        }
        this.h.put(name, s);
    }

    public final void put(String name, int x) {
        this.h.put(name, new Integer(x));
    }

    public final void putNull(String name) {
        this.h.put(name, (Object)null);
    }

    public final void put(String name, Object obj) {
        this.h.put(name, obj);
    }

    public final void put(Hashtable t) {
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.h.put(key, t.get(key));
        }
    }

    public final void put(String name, Vector v) {
        this.h.put(name, v);
    }

    public final Vector getVector(String name) {
        Object obj = this.h.get(name);
        if (obj instanceof String) {
            Vector v = new Vector();
            v.addElement(obj);
            return v;
        }
        return (Vector)obj;
    }

    public final Hashtable getHashtable() {
        return this.h;
    }

    public final boolean isCreate() {
        return this.action.equals("create");
    }

    public final boolean isEdit() {
        return this.action.equals("edit");
    }

    public final boolean isOpen() {
        return this.action.equals("open");
    }

    public final String getAction() {
        return this.action;
    }

    public final void setAction(String action) {
        this.action = action;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setID(String id) {
        this.id = id;
    }

    public final void setMessage(String s) {
        this.message = s;
    }

    public final String getID() {
        return this.id;
    }

    public final boolean contains(String name) {
        return this.h.containsKey(name);
    }

    public final void setError(String error) {
        this.error = error;
    }

    public final void remove(String name) {
        this.h.remove(name);
    }

    public final void clear() {
        this.h.clear();
    }

    public final Enumeration keys() {
        return this.h.keys();
    }

    public final void recycle() {
        if (this.mp != null) {
            Enumeration e = this.mp.getFileParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                File file = this.mp.getFile(name);
                if (file == null) continue;
                file.delete();
            }
        }
    }

    public final String toString() {
        return this.h.toString();
    }

    final void toXML(Element root, Hashtable fields) {
        Element form = root.addElement("form");
        if (!this.name.equals("")) {
            form.addAttribute("name", this.name);
        }
        if (!this.action.equals("")) {
            form.addAttribute("action", this.action);
        }
        if (!this.error.equals("")) {
            form.addAttribute("error", this.error);
        }
        if (!this.message.equals("")) {
            form.addAttribute("message", this.message);
            String m = this.message.replace('\"', '\'');
            m = Util.replace(m, "\r\n", "\\n");
            form.addAttribute("message_javascript", m);
        }
        if (!this.id.equals("")) {
            form.addAttribute("id", this.id);
        }
        Enumeration e = this.h.keys();
        while (e.hasMoreElements()) {
            String value;
            String name = (String)e.nextElement();
            Object o = this.h.get(name);
            if (o instanceof Vector) {
                Enumeration e2 = ((Vector)o).elements();
                while (e2.hasMoreElements()) {
                    form.addElement(name).addText((String)e2.nextElement());
                }
                continue;
            }
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                value = b != false ? "1" : "0";
                form.addElement(name).addText(value);
                continue;
            }
            if (o instanceof Date) {
                Field field = (Field)fields.get(name);
                value = this.dateformat.format((Date)o);
                if (field != null) {
                    if (field.getType() == 3) {
                        value = this.timeformat.format((Date)o);
                    } else if (field.getType() == 7) {
                        value = this.datetimeformat.format((Date)o);
                    }
                }
                form.addElement(name).addText(value);
                continue;
            }
            if (o instanceof Properties) {
                Properties p = (Properties)o;
                form.addElement(name).addText(PropertiesEx.toString(p));
                continue;
            }
            if (o == null) continue;
            form.addElement(name).addText(o.toString());
        }
    }

    final Date parseDate(String value, WebContext context) {
        Date date = null;
        try {
            date = this.dateformat.parse(value);
        }
        catch (ParseException e) {
            DateFormat dt = DateFormat.getDateInstance(3, context.getSession().getLocale());
            try {
                date = dt.parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }
}

