/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdBaseObject;
import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.image.ImageUtil;
import is.hugvit.io.ByteArrayInputStreamEx;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import javax.servlet.ServletContext;

public final class BirdFile
extends BirdBaseObject {
    private static final int PREVIEW_SIZE = 40;
    public static final String IMAGE = "IMAGE";

    BirdFile(BirdDatabase db, boolean is_new) {
        super(db);
        this.is_new = is_new;
    }

    public final void setName(String value) {
        this.h.put("name", value);
    }

    public final String getName() {
        return (String)this.h.get("name");
    }

    public final String getFolder() {
        return (String)this.h.get("folder");
    }

    public final String getFilename() {
        return (String)this.h.get("filename");
    }

    public final void setFolder(String value) {
        this.h.put("folder", value);
    }

    public final void setFilename(String value) {
        this.h.put("filename", value);
    }

    public final void setType(String value) {
        this.h.put("type", value);
    }

    public final void setPrivate(boolean value) {
        if (value) {
            this.h.put("isprivate", "1");
        } else {
            this.h.put("isprivate", "0");
        }
    }

    public final void setBody(InputStream in) {
        this.h.put("body", in);
    }

    public final void setEncoding(String encoding) {
        this.h.put("encoding", encoding);
    }

    public final InputStream getBody() {
        return (InputStream)this.h.get("body");
    }

    public final int getWidth() {
        Integer i = (Integer)this.h.get("width");
        if (i != null) {
            return i;
        }
        return 0;
    }

    public final int getHeight() {
        Integer i = (Integer)this.h.get("height");
        if (i != null) {
            return i;
        }
        return 0;
    }

    public final void delete() throws BirdException {
        try (Connection c = this.db.connect();){
            PreparedStatement stmt = c.prepareStatement("delete from bird_file where id=?");
            stmt.setString(1, (String)this.h.get("id"));
            stmt.executeUpdate();
            stmt.close();
            this.db.engine.cache.invalidate_files();
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    private static final String validFilename(String s) {
        char[] s1 = new char[]{'\u00e1', '\u00e9', '\u00f0', '\u00ed', '\u00f3', '\u00fa', '\u00fd', '\u00fe', '\u00e6', '\u00f6', '\u00c1', '\u00c9', '\u00d0', '\u00cd', '\u00d3', '\u00da', '\u00dd', '\u00de', '\u00c6', '\u00d6', ' ', '\'', '\"'};
        String[] s2 = new String[]{"a", "e", "d", "i", "o", "u", "y", "th", "ae", "o", "A", "E", "D", "I", "O", "U", "Y", "TH", "AE", "O", "", "", ""};
        StringBuffer t = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String u = String.valueOf(c);
            for (int j = 0; j < s1.length; ++j) {
                if (c != s1[j]) continue;
                u = s2[j];
                break;
            }
            t.append(u);
        }
        return t.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() throws BirdException {
        try (Connection c = this.db.connect();){
            InputStream in = (InputStream)this.h.get("body");
            this.h.put("modified", new Timestamp(System.currentTimeMillis()));
            if (this.db.context != null) {
                String user = this.db.context.getRequest().getRemoteUser();
                if (user == null) {
                    user = "";
                }
                this.h.put("modified_by", user);
            }
            if (this.is_new) {
                this.h.put("id", UID.getUID());
                if (!this.h.containsKey("category")) {
                    this.h.put("category", "");
                }
                if (!this.h.containsKey("folder")) {
                    this.h.put("folder", "");
                }
                if (in == null) {
                    this.h.put("size", new Integer(0));
                }
            }
            if (in != null) {
                boolean is_image;
                String filename = (String)this.h.get("filename");
                filename = BirdFile.validFilename(filename);
                this.h.put("filename", filename);
                if (!this.h.containsKey("name")) {
                    this.h.put("name", Util.changeFileExt(filename, ""));
                }
                int size = in.available();
                this.h.put("size", new Integer(size));
                String mime = null;
                ServletContext ctx = this.db.engine.servletcontext;
                if (ctx != null) {
                    mime = ctx.getMimeType(filename.toLowerCase());
                }
                boolean bl = is_image = mime != null && mime.startsWith("image/");
                if (!this.h.containsKey("type") && mime != null) {
                    String type = "ATTACHMENT";
                    if (is_image) {
                        type = IMAGE;
                    } else if (mime.startsWith("text/")) {
                        type = "CODE";
                    }
                    this.h.put("type", type);
                }
                if (is_image) {
                    try {
                        in.reset();
                    }
                    catch (IOException e) {
                        ByteArrayOutputStreamEx out = new ByteArrayOutputStreamEx(size);
                        Util.writeStream(in, out);
                        in.close();
                        in = new ByteArrayInputStreamEx(out);
                        this.h.put("body", in);
                    }
                    Image source = ImageUtil.getImage(in);
                    in.reset();
                    int ww = ImageUtil.getWidth(source);
                    int hh = ImageUtil.getHeight(source);
                    this.h.put("width", new Integer(ww));
                    this.h.put("height", new Integer(hh));
                    Image dest = ImageUtil.scale(source, 40);
                    this.h.put("pwidth", new Integer(ImageUtil.getWidth(dest)));
                    this.h.put("pheight", new Integer(ImageUtil.getHeight(dest)));
                    ByteArrayOutputStreamEx pout = new ByteArrayOutputStreamEx(2048);
                    ImageUtil.saveImageJPG(dest, pout, 60);
                    this.h.put("psize", new Integer(pout.size()));
                    this.h.put("pfilename", Util.changeFileExt(filename, ".jpg"));
                    ByteArrayInputStreamEx pin = new ByteArrayInputStreamEx(pout);
                    this.h.put("pbody", pin);
                }
            }
            BirdUtil.updateRole(c, "role", this.h);
            if (this.is_new) {
                BirdUtil.insert(c, "bird_file", this.h);
            } else {
                Hashtable key = new Hashtable();
                key.put("id", this.h.get("id"));
                BirdUtil.update(c, "bird_file", this.h, key);
                this.db.engine.cache.invalidate_files();
            }
            if (in != null) {
                in.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
        catch (IOException e) {
            throw new BirdException(e);
        }
    }
}

