/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdCache;
import is.hugvit.bird.BirdComponent;
import is.hugvit.bird.BirdConfig;
import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.DefaultRealm;
import is.hugvit.bird.FileInfo;
import is.hugvit.bird.PageXSL;
import is.hugvit.bird.PageXSL_Error;
import is.hugvit.bird.Realm;
import is.hugvit.bird.WebContextImpl;
import is.hugvit.bird.WebElementData;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.bird.core.Install;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.log.Log;
import is.hugvit.log.NullLog;
import is.hugvit.log.SystemLog;
import is.hugvit.net.HttpUtil;
import is.hugvit.net.MultipartRequest;
import is.hugvit.net.ServletEntityResolver;
import is.hugvit.util.ArrayListEx;
import is.hugvit.util.HashMapEx;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.StackKeyedObjectPoolFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;

public final class BirdEngine
implements BirdSession {
    private static final String SYS_PROTOCOL = "java.protocol.handler.pkgs";
    private static final String XML_TYPE = "application/xml";
    private static final String GENERIC_TYPE = "application/octet-stream";
    private static final String DATASTORE_FILENAME = "bird_config.properties";
    private static final String PAGE_NOT_FOUND = "Page not found";
    private static BirdEngine engine;
    private AbandonedObjectPool pool;
    private AbandonedConfig abandoned_config;
    private HashMapEx components;
    private RequestDispatcher forward_servlet;
    Properties parameters = new Properties();
    ServletContext servletcontext;
    String ds_name;
    BirdCache cache;
    SystemLog log = new SystemLog();
    TransformerFactory transfactory;
    boolean use_request;
    final BirdConfig bird_config = new BirdConfig();
    String auth_method = "Basic";
    String realm_name = "";
    private Realm realm = new DefaultRealm();
    private Document web_xml;
    private long page_hits;
    private long file_hits;
    private Date started;
    private Locale locale;

    BirdEngine() {
        this.log.setLevel(1);
        this.started = new Date();
        this.cache = new BirdCache();
        this.components = new HashMapEx();
    }

    final void init(ServletConfig config) throws BirdException {
        try {
            Properties p = System.getProperties();
            String value = "is.hugvit.net";
            String s = p.getProperty(SYS_PROTOCOL);
            if (s != null) {
                value = s + '|' + value;
            }
            p.put(SYS_PROTOCOL, value);
        }
        catch (SecurityException p) {
            // empty catch block
        }
        try {
            File file;
            this.servletcontext = config.getServletContext();
            this.forward_servlet = this.servletcontext.getNamedDispatcher("ForwardServlet");
            this.use_request = BirdEngine.getUseRequest(this.servletcontext);
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String n = (String)en.nextElement();
                String v = config.getInitParameter(n);
                this.parameters.put(n, v);
            }
            String filename = this.parameters.getProperty("config");
            InputStream in = filename != null ? new FileInputStream(filename) : this.servletcontext.getResourceAsStream("/WEB-INF/bird_config.properties");
            if (in == null) {
                throw new BirdException("Configuration for datastore not found");
            }
            this.parameters.load(in);
            in.close();
            String dir = this.parameters.getProperty("dir.web-inf");
            if (dir != null && (file = new File(dir, "web.xml")).exists()) {
                SAXReader reader = new SAXReader();
                this.web_xml = reader.read(file);
            }
            if (this.web_xml == null && this.servletcontext != null && (in = this.servletcontext.getResourceAsStream("/WEB-INF/web.xml")) != null) {
                SAXReader reader = new SAXReader();
                reader.setEntityResolver((EntityResolver)new ServletEntityResolver(reader.getEntityResolver()));
                this.web_xml = reader.read(in);
                in.close();
                Element root = this.web_xml.getRootElement();
                Element login_config = root.element("login-config");
                if (login_config != null) {
                    this.auth_method = login_config.elementText("auth-method");
                    if (this.auth_method == null) {
                        this.auth_method = "Basic";
                    }
                    this.realm_name = login_config.elementText("realm-name");
                    if (this.realm_name == null) {
                        this.realm_name = "";
                    }
                }
            }
            this.initEngine(this.parameters);
        }
        catch (BirdException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    private static final boolean getUseRequest(ServletContext context) {
        try {
            context.getMajorVersion();
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
    }

    @Override
    public final Document getWebXML() {
        return this.web_xml;
    }

    private static final ServletException createServletException(Exception e) {
        return new ServletException((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initEngine(Properties p) throws BirdException {
        try {
            String realm_class;
            String log_level;
            engine = this;
            String loc = p.getProperty("locale");
            if (loc == null) {
                this.locale = Locale.getDefault();
            } else {
                int pos = loc.indexOf(95);
                String language = loc.substring(0, pos);
                String country = loc.substring(pos + 1);
                this.locale = new Locale(language, country);
            }
            this.ds_name = p.getProperty("ds.name");
            if (this.ds_name == null) {
                this.ds_name = "bird";
            }
            if ((log_level = p.getProperty("log_level")) != null) {
                this.log.setLevel(NullLog.getLogLevel(log_level));
            }
            if ((realm_class = p.getProperty("realm.classname")) != null) {
                this.realm = (Realm)Class.forName(realm_class).newInstance();
            }
            this.realm.setSession(this);
            BirdDatabase db = new BirdDatabase(this, null);
            this.initPool(db, p);
            try (Connection dc = db.connect();){
                Vector modules;
                this.bird_config.load(dc);
                this.uninstallOlderVersion(dc, Install.class.getName());
                this.uninstallOlderVersion(dc, "is.hugvit.bird.client.Install");
                this.uninstallOlderVersion(dc, "is.hugvit.bird.thread.Install");
                this.uninstallOlderVersion(dc, "is.hugvit.bird.datapump.Install");
                this.uninstallOlderVersion(dc, "is.hugvit.bird.pool.Install");
                this.uninstallOlderVersion(dc, "is.hugvit.bird.gdr.Install");
                this.uninstallOlderVersion(dc, "is.hugvit.bird.licence.Install");
                this.install_comp(dc, Install.class.getName(), false);
                this.install_comp(dc, "is.hugvit.bird.client.Install", true);
                this.install_comp(dc, "is.hugvit.bird.thread.Install", true);
                this.install_comp(dc, "is.hugvit.bird.datapump.Install", true);
                this.install_comp(dc, "is.hugvit.bird.pool.Install", true);
                this.install_comp(dc, "is.hugvit.bird.gdr.Install", true);
                this.install_comp(dc, "is.hugvit.bird.licence.Install", true);
                String autoModules = p.getProperty("modules.install");
                if (autoModules != null && (modules = Util.split(autoModules, ",")).size() > 0) {
                    for (String installClass : modules) {
                        this.log.info("Auto installing module: " + installClass);
                        this.install_comp(dc, installClass.trim(), true);
                    }
                }
                db.FixDatabase(dc, this.log);
                this.startComponents(dc);
            }
            this.refreshConfig(true);
            this.log.info("Bird v" + Install.VERSION + " started");
        }
        catch (BirdException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    private final void initPool(BirdDatabase db, Properties p) throws Exception {
        String connProps;
        String driver_name = p.getProperty("ds.driver");
        Class.forName(driver_name).newInstance();
        String connstring = p.getProperty("ds.connection");
        String user = p.getProperty("ds.user");
        String password = p.getProperty("ds.password");
        if (password == null) {
            password = "";
        }
        Properties up = new Properties();
        if (user != null) {
            up.put("user", user);
            up.put("password", password);
        }
        if ((connProps = p.getProperty("ds.properties")) != null) {
            try {
                String[] propPairs;
                for (String s : propPairs = connProps.split(";")) {
                    String[] va = s.split(",");
                    up.put(va[0], va[1]);
                }
            }
            catch (Exception ex) {
                this.getLog().error("Error in \"ds.properties\" syntax");
            }
        }
        this.abandoned_config = new AbandonedConfig();
        this.abandoned_config.setLogAbandoned(true);
        this.abandoned_config.setRemoveAbandoned(true);
        this.abandoned_config.setRemoveAbandonedTimeout(300);
        this.pool = new AbandonedObjectPool(null, this.abandoned_config);
        this.pool.setMaxIdle(4);
        this.pool.setMaxActive(4);
        this.pool.setTestOnBorrow(false);
        this.pool.setTestOnReturn(false);
        this.pool.setTestWhileIdle(true);
        this.pool.setMaxWait(10000L);
        this.pool.setTimeBetweenEvictionRunsMillis(120000L);
        this.pool.setNumTestsPerEvictionRun(3);
        this.pool.setMinEvictableIdleTimeMillis(3600000L);
        this.pool.setWhenExhaustedAction((byte)1);
        DriverManagerConnectionFactory cf = new DriverManagerConnectionFactory(connstring, up);
        StackKeyedObjectPoolFactory kf = new StackKeyedObjectPoolFactory(5);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)cf, (ObjectPool)this.pool, (KeyedObjectPoolFactory)kf, null, false, true, this.abandoned_config);
        Class.forName("org.apache.commons.dbcp.PoolingDriver");
        PoolingDriver pdriver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        pdriver.registerPool(this.ds_name, (ObjectPool)this.pool);
        db.createTables(this.log);
        pcf.setValidationQuery("select count(*) from bird_info");
    }

    final void destroy() throws BirdException {
        try {
            Enumeration e = this.components.elements();
            while (e.hasMoreElements()) {
                BirdComponent bc = (BirdComponent)e.nextElement();
                Properties p = bc.getInfo();
                bc.stop(this);
                this.log.debug("Stopping " + p.getProperty("name"));
            }
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            driver.closePool(this.ds_name);
            this.pool.close();
            if (this.isTomcat(this.getServletContext())) {
                Enumeration<Driver> drivers = DriverManager.getDrivers();
                while (drivers.hasMoreElements()) {
                    Driver drv = drivers.nextElement();
                    try {
                        DriverManager.deregisterDriver(drv);
                        this.log.info(String.format("Deregistering JDBC driver: %s", drv.getClass().getCanonicalName()));
                    }
                    catch (SQLException ex) {
                        this.log.info(String.format("Error deregistering JDBC driver %s", drv.getClass().getCanonicalName()));
                    }
                }
            }
            this.log.info("Bird stopped");
        }
        catch (BirdException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    public static final BirdEngine getInstance() {
        return engine;
    }

    final Connection connect() throws SQLException {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + this.ds_name);
    }

    @Override
    public final Realm getRealm() {
        return this.realm;
    }

    final String getMetaGenerator() {
        return "Bird v" + Install.VERSION;
    }

    private final BirdComponent install_comp(Connection dc, String classname, boolean ignore_error) throws Exception {
        if (!this.isComponentInstalled(dc, classname)) {
            BirdComponent c;
            try {
                c = (BirdComponent)Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                if (ignore_error) {
                    return null;
                }
                throw e;
            }
            c.install(this);
            Properties p = c.getInfo();
            Hashtable<String, String> h = new Hashtable<String, String>();
            h.put("id", UID.getUID());
            h.put("name", p.getProperty("name"));
            h.put("classname", c.getClass().getName());
            h.put("version", p.getProperty("version"));
            BirdUtil.insert(dc, "bird_comp", h);
            this.log.info("Installing: " + p.getProperty("name"));
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void installComponent(String classname) throws BirdException {
        try (Connection dc = this.connect();){
            BirdComponent c = this.install_comp(dc, classname, false);
            if (c != null) {
                c.start(this);
                this.components.put(classname, c);
            }
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void uninstallOlderVersion(Connection dc, String classname) throws Exception {
        BirdComponent c = null;
        boolean uninstall = true;
        try {
            String version;
            c = (BirdComponent)Class.forName(classname).newInstance();
            PreparedStatement stmt = dc.prepareStatement("select version from bird_comp where classname=?");
            stmt.setString(1, classname);
            ResultSet rs = stmt.executeQuery();
            try {
                if (!rs.next()) {
                    return;
                }
                version = rs.getString(1);
            }
            finally {
                rs.close();
                stmt.close();
            }
            uninstall = !version.equals(c.getInfo().getProperty("version"));
        }
        catch (Exception version) {
            // empty catch block
        }
        if (uninstall) {
            if (c != null) {
                c.uninstall(this);
                this.log.info("UnInstalling: " + classname);
            }
            PreparedStatement stmt = dc.prepareStatement("delete from bird_comp where classname=?");
            stmt.setString(1, classname);
            stmt.executeUpdate();
            stmt.close();
        }
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void uninstallComponent(String classname) throws BirdException {
        try (Connection dc = this.connect();){
            BirdComponent c = (BirdComponent)this.components.get(classname);
            if (c == null) {
                c = (BirdComponent)Class.forName(classname).newInstance();
            }
            c.stop(this);
            this.components.remove(c);
            c.uninstall(this);
            PreparedStatement stmt = dc.prepareStatement("delete from bird_comp where classname=?");
            stmt.setString(1, classname);
            stmt.executeUpdate();
            stmt.close();
            this.log.info("UnInstalling: " + classname);
            this.cache.invalidate();
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    @Override
    public final void refreshComponents() throws BirdException {
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            BirdComponent bc = (BirdComponent)e.nextElement();
            bc.refresh(this);
            this.log.debug("Refreshing " + bc.getInfo().getProperty("name"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startComponents(Connection dc) throws BirdException {
        block9: {
            try {
                PreparedStatement stmt = dc.prepareStatement("select name,classname from bird_comp");
                ResultSet rd = stmt.executeQuery();
                block7: while (true) {
                    while (rd.next()) {
                        String name = rd.getString(1);
                        String classname = rd.getString(2);
                        try {
                            BirdComponent bc = (BirdComponent)Class.forName(classname).newInstance();
                            this.components.put(classname, bc);
                            bc.start(this);
                            this.log.debug("Starting " + name);
                            continue block7;
                        }
                        catch (Exception e) {
                            this.log.error("Unable to start: " + name, e);
                        }
                    }
                    break block9;
                    {
                        continue block7;
                        break;
                    }
                    break;
                }
                finally {
                    rd.close();
                    stmt.close();
                }
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
    }

    @Override
    public final Log getLog() {
        return this.log;
    }

    @Override
    public final BirdDatabase getDatabase() {
        return new BirdDatabase(this, null);
    }

    @Override
    public final Hashtable getConfig() {
        Hashtable h = this.bird_config.getConfig();
        h.put("version", Install.VERSION);
        h.put("page_hits", new Long(this.page_hits));
        h.put("file_hits", new Long(this.file_hits));
        h.put("start_date", this.started);
        h.put("xsl_class", this.transfactory.getClass().getName());
        return h;
    }

    @Override
    public final void putConfig(Hashtable h) throws BirdException {
        try (Connection c = this.connect();){
            this.bird_config.putConfig(h);
            this.bird_config.save(c);
            this.refreshConfig(false);
        }
        catch (BirdException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    private final void refreshConfig(boolean start) throws Exception {
        this.log.setName(this.bird_config.getName());
        String classname = this.bird_config.getXSLParserClassname();
        if (!classname.equals("")) {
            try {
                this.transfactory = (TransformerFactory)Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                classname = "";
                this.log.error(e);
            }
        }
        if (classname.equals("")) {
            this.transfactory = TransformerFactory.newInstance();
        }
        this.cache.xsl_cache.setSize(this.bird_config.getTemplates());
        this.cache.file_cache.setSize(this.bird_config.getFiles());
        this.pool.setMaxActive(this.bird_config.getMaxActive());
        this.pool.setMaxIdle(this.bird_config.getMaxIdle());
        this.pool.setWhenExhaustedAction(this.bird_config.getExhaustedAction());
        this.pool.setMaxWait((long)(this.bird_config.getMaxWait() * 1000));
        this.abandoned_config.setRemoveAbandonedTimeout(this.bird_config.getAbandonedTimeout());
        if (!start) {
            this.log.setLevel(this.bird_config.getLogLevel());
        }
        String encoding = this.bird_config.getEncoding();
        boolean cp1252 = this.bird_config.getCP1252();
        if (!cp1252 && encoding.equals("ISO-8859-1") && Util.isSupportedCharset("CP1252")) {
            encoding = "CP1252";
        }
        MultipartRequest.setEncoding(encoding);
        MultipartRequest.setCP1252Convert(cp1252);
        this.cache.invalidate();
    }

    @Override
    public final ServletContext getServletContext() {
        return this.servletcontext;
    }

    @Override
    public final Properties getParameters() {
        return this.parameters;
    }

    private final boolean canGZIP(HttpServletRequest req, String mime, int size) {
        if (!this.bird_config.useGZIP()) {
            return false;
        }
        boolean useGZIP = false;
        if (size > 1024 && size < 524288000 && mime != null && mime.startsWith("text/")) {
            String encoding = req.getHeader("Accept-Encoding");
            useGZIP = encoding != null && encoding.indexOf("gzip") != -1;
            String range = req.getHeader("Range");
            if (range != null) {
                useGZIP = false;
            }
        }
        return useGZIP;
    }

    private final int[] parseRange(String range, int size) {
        try {
            String s;
            int p = range.indexOf("bytes=");
            if (p > -1 && (p = (s = range.substring(p + 6).trim()).indexOf(45)) > -1) {
                int[] i = new int[]{0, size - 1};
                String s1 = s.substring(0, p).trim();
                String s2 = s.substring(p + 1).trim();
                if (s1.equals("")) {
                    i[1] = size - Integer.parseInt(s2);
                } else if (s2.equals("")) {
                    i[0] = Integer.parseInt(s1);
                } else {
                    i[0] = Integer.parseInt(s1);
                    i[1] = Integer.parseInt(s2);
                }
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private final void writeResponse(HttpServletRequest req, HttpServletResponse res, String mime, InputStream in, int size) throws IOException {
        String range = req.getHeader("Range");
        if (range == null) {
            res.setHeader("Accept-Ranges", "bytes");
        }
        if (mime != null) {
            res.setContentType(mime);
        }
        if (this.canGZIP(req, mime, size)) {
            res.setHeader("Content-Encoding", "gzip");
            ByteArrayOutputStreamEx byteout = new ByteArrayOutputStreamEx(size / 2);
            GZIPOutputStream gzipout = new GZIPOutputStream(byteout);
            Util.writeStream(in, gzipout);
            ((OutputStream)gzipout).close();
            res.setContentLength(byteout.size());
            ServletOutputStream rout = res.getOutputStream();
            rout.write(byteout.getBuffer(), 0, byteout.size());
            rout.close();
        } else {
            int[] r;
            if (range != null && (r = this.parseRange(range, size)) != null) {
                in.skip(r[0]);
                int range_size = r[1] - r[0] + 1;
                res.setStatus(206);
                res.setContentLength(range_size);
                res.setHeader("Content-Range", "bytes " + r[0] + '-' + r[1] + '/' + size);
                ServletOutputStream rout = res.getOutputStream();
                Util.writeStream(in, (OutputStream)rout, range_size);
                rout.close();
                return;
            }
            res.setContentLength(size);
            ServletOutputStream rout = res.getOutputStream();
            Util.writeStream(in, (OutputStream)rout);
            rout.close();
        }
    }

    private final void writeResponse(HttpServletRequest req, HttpServletResponse res, String mime, ByteArrayOutputStreamEx out) throws IOException {
        if (mime != null) {
            res.setContentType(mime);
        }
        if (this.canGZIP(req, mime, out.size())) {
            res.setHeader("Content-Encoding", "gzip");
            ByteArrayOutputStreamEx byteout = new ByteArrayOutputStreamEx(out.size() / 2);
            GZIPOutputStream gzipout = new GZIPOutputStream(byteout);
            ((OutputStream)gzipout).write(out.getBuffer(), 0, out.size());
            ((OutputStream)gzipout).close();
            res.setContentLength(byteout.size());
            ServletOutputStream rout = res.getOutputStream();
            rout.write(byteout.getBuffer(), 0, byteout.size());
            rout.close();
        } else {
            res.setContentLength(out.size());
            ServletOutputStream rout = res.getOutputStream();
            rout.write(out.getBuffer(), 0, out.size());
            rout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isComponentInstalled(Connection c, String classname) throws BirdException {
        boolean bl;
        PreparedStatement stmt = c.prepareStatement("select classname from bird_comp where classname=?");
        stmt.setString(1, classname);
        ResultSet rs = stmt.executeQuery();
        try {
            bl = rs.next();
        }
        catch (Throwable throwable) {
            try {
                rs.close();
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
        rs.close();
        stmt.close();
        return bl;
    }

    private static final String getURL(HttpServletRequest req, String page) {
        StringBuffer s = new StringBuffer(HttpUtil.getServletURL(req));
        s.append('/');
        s.append(page);
        return s.toString();
    }

    final String getURL(WebContextImpl wc, String page) {
        String name = this.cache.getPageNameByAlias(wc, page);
        if (name != null) {
            page = name;
        }
        return BirdEngine.getURL(wc.getRequest(), page);
    }

    static final String getPageName(String path) {
        String name = "";
        if (path != null && !path.equals("")) {
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            name = path.startsWith("admin/$pages/") ? path.substring(13) : path;
        }
        return name.toLowerCase();
    }

    private static final String getFileName(String pathinfo) {
        int i = pathinfo.lastIndexOf(47);
        return pathinfo.substring(i + 1);
    }

    private static final String getFilePathName(String pathinfo) {
        int i = pathinfo.indexOf("/files/");
        if (i == -1) {
            return "";
        }
        int j = pathinfo.indexOf("$preview/", i += 7);
        if (j != -1) {
            i = j + 9;
        }
        if ((j = pathinfo.lastIndexOf(47)) < i) {
            j = i;
        }
        return pathinfo.substring(i, j);
    }

    private static final String getLine(String s, int x) {
        if (s == null) {
            return "";
        }
        int i = 0;
        int l = 0;
        int j = s.indexOf(10);
        while (j >= 0) {
            if (++l == x) {
                return s.substring(i, j);
            }
            i = j + 1;
            j = s.indexOf(10, i);
        }
        return s.substring(i);
    }

    private static final void clearCacheHeaders(HttpServletResponse res) {
        if (res.containsHeader("Cache-Control")) {
            res.setHeader("Cache-Control", "public");
        }
        if (res.containsHeader("Pragma")) {
            res.setHeader("Pragma", "");
        }
        if (res.containsHeader("Expires")) {
            res.setHeader("Expires", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doFile(HttpServletRequest req, HttpServletResponse res) throws IOException, SQLException, ServletException {
        ++this.file_hits;
        long begin = System.currentTimeMillis();
        String pathinfo = HttpUtil.getPathInfo(req);
        String name = BirdEngine.getFilePathName(pathinfo);
        String filename = BirdEngine.getFileName(pathinfo);
        boolean preview = pathinfo.indexOf("/files/$preview/") > -1;
        try (Connection conn = this.connect();){
            StringBuffer s = new StringBuffer(128);
            s.append("select modified,encoding,role,");
            if (preview) {
                s.append("psize,pbody from bird_file where name=? and pfilename=?");
            } else {
                s.append("size,body from bird_file where name=? and filename=?");
            }
            try (PreparedStatement stmt = conn.prepareStatement(s.toString());){
                stmt.setMaxRows(1);
                stmt.setString(1, name);
                stmt.setString(2, filename);
                try (ResultSet rs = stmt.executeQuery();){
                    String mime;
                    WebContextImpl wcontext;
                    String[] roles;
                    if (!rs.next()) {
                        this.log.warn("File " + pathinfo + " not found");
                        res.sendError(404, "File not found");
                        return;
                    }
                    Timestamp modified = rs.getTimestamp(1);
                    String encoding = rs.getString(2);
                    if (encoding == null || encoding.equals("")) {
                        encoding = "ISO-8859-1";
                    }
                    if ((roles = Util.splitArray(rs.getString(3), ";")).length > 0 && !(wcontext = new WebContextImpl(this, req, res, true)).isUserInAllRoles(roles)) {
                        this.log.debug("UnAuthorized: " + filename + " user=" + wcontext.getRemoteUser());
                        wcontext.setStatusUnAuthorizedEx();
                        return;
                    }
                    int size = rs.getInt(4);
                    if (modified != null) {
                        FileInfo f = new FileInfo();
                        f.name = pathinfo;
                        f.modified = ((Date)modified).getTime();
                        this.cache.putFileInfo(f);
                        long ifmodified = req.getDateHeader("If-Modified-Since");
                        if (ifmodified != -1L && f.modified <= ifmodified) {
                            res.setStatus(304);
                            return;
                        }
                        res.setDateHeader("Last-Modified", ((Date)modified).getTime());
                    }
                    if ((mime = this.servletcontext.getMimeType(filename)) == null) {
                        mime = GENERIC_TYPE;
                    }
                    BirdEngine.clearCacheHeaders(res);
                    try (InputStream in = rs.getBinaryStream(5);){
                        try {
                            String content_type = mime.startsWith("text/") ? mime + "; charset=" + encoding : mime;
                            this.writeResponse(req, res, content_type, in, size);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (this.log.getLevel() != 0) return;
        long end = System.currentTimeMillis();
        this.log.debug("Time:file:" + filename + "=" + (end - begin));
    }

    private final void doErrorPage(WebContextImpl wcontext, PageXSL pxsl, PageXSL orgpage, Exception e) throws Exception {
        TransformerException te;
        Throwable t;
        StringBuffer msg = new StringBuffer(1024);
        while (e instanceof TransformerException && (t = (te = (TransformerException)e).getException()) != null && t instanceof Exception) {
            e = (Exception)t;
        }
        if (e instanceof SAXParseException) {
            SAXParseException se = (SAXParseException)e;
            int linenum = se.getLineNumber();
            msg.append("Error parsing XSL in line " + linenum + ": " + e.getMessage() + '\n');
            if (orgpage != null) {
                msg.append('\n');
                msg.append(BirdEngine.getLine(orgpage.xsl, linenum) + '\n');
            }
        } else {
            msg.append(e.getMessage());
        }
        wcontext.setAttribute("message", msg.toString());
        wcontext.setAttribute("exception", e);
        this.doPage(pxsl, wcontext, false);
    }

    private final boolean doMethod(ArrayListEx list, WebContextImpl wcontext, WebElementData wed2, boolean is_post) throws Exception {
        for (WebElementData wed : list) {
            wcontext.assign(wed);
            try {
                if (is_post) {
                    wed.we.doPost(wcontext);
                } else if (wed != wed2) {
                    wed.doGet(wcontext, this.log);
                }
            }
            catch (BirdException ex) {
                if (this.bird_config.getIgnoreError() && !wcontext.is_admin) {
                    ex.printStackTrace();
                }
                throw ex;
            }
            if (wcontext.redirect != null) {
                this.log.debug("Redirecting to: " + wcontext.redirect);
                wcontext.res.sendRedirect(wcontext.redirect);
                return false;
            }
            if (!wcontext.cont_flag) {
                return false;
            }
            if (!is_post || !wcontext.element_taken) continue;
            return this.doMethod(list, wcontext, wed, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPage(PageXSL pxsl, WebContextImpl wcontext, boolean is_post) throws Exception {
        long modified;
        ByteArrayOutputStreamEx out;
        long begin;
        boolean is_debug;
        block11: {
            ArrayListEx list;
            block10: {
                is_debug = this.log.getLevel() == 0;
                begin = System.currentTimeMillis();
                out = pxsl.getLastOutput();
                if (out != null) break block11;
                list = pxsl.getWebElements();
                try {
                    for (WebElementData wed : list) {
                        wcontext.assign(wed);
                        wed.we.init(wcontext);
                    }
                    if (this.doMethod(list, wcontext, null, is_post)) break block10;
                }
                catch (Throwable throwable) {
                    for (int i = list.size() - 1; i >= 0; --i) {
                        WebElementData wed = (WebElementData)list.get(i);
                        wcontext.assign(wed);
                        wed.we.destroy(wcontext);
                    }
                    throw throwable;
                }
                for (int i = list.size() - 1; i >= 0; --i) {
                    WebElementData wed = (WebElementData)list.get(i);
                    wcontext.assign(wed);
                    wed.we.destroy(wcontext);
                }
                return;
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                WebElementData wed;
                wed = (WebElementData)list.get(i);
                wcontext.assign(wed);
                wed.we.destroy(wcontext);
            }
            if (is_debug) {
                long end = System.currentTimeMillis();
                this.log.debug("Time:XML=" + (end - begin));
            }
            if (wcontext.is_debug_xml) {
                out = new ByteArrayOutputStreamEx(4096);
                String encoding = this.bird_config.getEncoding();
                OutputFormat format = new OutputFormat("", true, encoding);
                XMLWriter xw = new XMLWriter((OutputStream)out, format);
                xw.write(wcontext.doc);
                this.writeResponse(wcontext.req, wcontext.res, "application/xml; charset=" + encoding, out);
                return;
            }
            begin = System.currentTimeMillis();
            out = pxsl.transform(this, wcontext.doc);
        }
        if ((modified = pxsl.getLastModified()) != -1L) {
            wcontext.res.setDateHeader("Last-Modified", modified);
        }
        begin = System.currentTimeMillis();
        this.writeResponse(wcontext.req, wcontext.res, "text/html; charset=" + this.bird_config.getEncoding(), out);
        if (is_debug) {
            long end = System.currentTimeMillis();
            this.log.debug("Time:Writing=" + (end - begin));
        }
    }

    final void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        String pathinfo = HttpUtil.getPathInfo(req).toLowerCase();
        try {
            if (pathinfo.equals("/")) {
                res.sendRedirect(BirdEngine.getURL(req, this.bird_config.getMainPage()));
                return;
            }
            if (pathinfo.equals("/admin") || pathinfo.equals("/admin/")) {
                res.sendRedirect(BirdEngine.getURL(req, "admin/bird_index.html"));
                return;
            }
            if (pathinfo.indexOf("/files/") > -1) {
                this.doFile(req, res);
                return;
            }
            this.doGetPost(req, res);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.use_request) {
                throw BirdEngine.createServletException(e);
            }
            throw new ServletException(e.getMessage());
        }
    }

    final void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        this.doGetPost(req, res);
    }

    final long getLastModified(HttpServletRequest req) {
        String pathinfo = HttpUtil.getPathInfo(req).toLowerCase();
        if (!pathinfo.equals("/")) {
            if (pathinfo.indexOf("/files/") > -1) {
                FileInfo f = this.cache.getFileInfo(pathinfo);
                if (f != null) {
                    return f.modified;
                }
            } else {
                String pagename = BirdEngine.getPageName(pathinfo);
                PageXSL p = this.cache.getPageByName(pagename);
                if (p != null) {
                    return p.getLastModified();
                }
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void doGetPost(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        WebContextImpl wcontext;
        boolean is_debug;
        PageXSL p;
        long begin;
        block26: {
            boolean unauthorized;
            block25: {
                ++this.page_hits;
                begin = System.currentTimeMillis();
                p = null;
                is_debug = this.log.getLevel() == 0;
                wcontext = new WebContextImpl(this, req, res, false);
                wcontext.createConnection();
                if (is_debug) {
                    this.log.debug("PageName=" + wcontext.pagename);
                }
                unauthorized = wcontext.pagename.equals(this.bird_config.getUnAuthorizedPage());
                p = this.cache.getPageByName(wcontext.pagename);
                if (p == null || wcontext.is_debug_xsl) {
                    p = PageXSL.createPage(this, wcontext, wcontext.pagename);
                    if (p == null) {
                        this.log.warn("Page " + wcontext.pathinfo + " not found");
                        res.sendError(404, PAGE_NOT_FOUND);
                        wcontext.destroy();
                        return;
                    }
                    if (wcontext.is_debug_xsl && !unauthorized) {
                        String encoding = this.bird_config.getEncoding();
                        String s = p.getXSL();
                        ByteArrayOutputStreamEx out = new ByteArrayOutputStreamEx(s.getBytes(encoding));
                        this.writeResponse(req, res, "application/xml; charset=" + encoding, out);
                        wcontext.destroy();
                        return;
                    }
                    long s = System.currentTimeMillis();
                    p.parse(this);
                    if (is_debug) {
                        long e = System.currentTimeMillis();
                        this.log.debug("Time:XSL=" + (e - s));
                    }
                    this.cache.putPage(p);
                    if (is_debug) {
                        this.log.debug("Caching XSL: " + wcontext.pagename);
                    }
                }
                if (wcontext.is_admin_page || p.isVisible()) break block25;
                this.log.debug("Page " + wcontext.pathinfo + " is not visible");
                res.sendError(404, PAGE_NOT_FOUND);
                wcontext.destroy();
                return;
            }
            if (unauthorized) {
                wcontext.setStatusUnAuthorizedEx();
                break block26;
            }
            if (p.isInRole(wcontext)) break block26;
            this.log.debug("UnAuthorized: " + wcontext.pagename + " user=" + wcontext.getRemoteUser());
            wcontext.setStatusUnAuthorizedEx();
            wcontext.destroy();
            return;
        }
        try {
            try {
                this.doPage(p, wcontext, wcontext.is_post);
            }
            catch (Exception e) {
                try {
                    if (wcontext.pagename.startsWith("admin/")) {
                        throw e;
                    }
                    wcontext.clear();
                    PageXSL temp = PageXSL.createPage(this, wcontext, this.bird_config.getErrorPage());
                    if (temp == null) {
                        throw e;
                    }
                    PageXSL orgp = p;
                    p = temp;
                    long s1 = System.currentTimeMillis();
                    p.parse(this);
                    long e1 = System.currentTimeMillis();
                    this.log.debug("Time:XSL=" + (e1 - s1));
                    this.doErrorPage(wcontext, p, orgp, e);
                    if (!(e instanceof IOException)) {
                        this.log.error(e);
                    }
                }
                catch (Exception e2) {
                    try {
                        PageXSL_Error errp = new PageXSL_Error(this);
                        wcontext.clear();
                        this.doErrorPage(wcontext, errp, p, e2);
                        if (!(e instanceof IOException)) {
                            this.log.error(e);
                        }
                    }
                    catch (Exception e3) {
                        if (!(e3 instanceof IOException)) {
                            this.log.error("Bird:Original error:" + e2.getMessage(), e2);
                            this.log.error("Bird:Internal error:Error generating error page:" + e3.getMessage(), e3);
                            throw new ServletException((Throwable)e3);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            wcontext.destroy();
        }
        if (!is_debug) return;
        long end = System.currentTimeMillis();
        this.log.debug("Time:doGetPost=" + (end - begin));
    }

    private final boolean isTomcat(ServletContext context) {
        String serverInfo = context.getServerInfo();
        if (serverInfo != null) {
            return serverInfo.toLowerCase().contains("tomcat");
        }
        return false;
    }
}

