/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdElement;
import is.hugvit.bird.BirdEngine;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.BirdMenu;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.BirdPageType;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.BirdTemplate;
import is.hugvit.bird.WebContextImpl;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.io.ByteArrayInputStreamEx;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.io.FileEx;
import is.hugvit.io.OpenInputStream;
import is.hugvit.log.Log;
import is.hugvit.sql.NativeTypes;
import is.hugvit.sql.Null;
import is.hugvit.sql.SQLUtil;
import is.hugvit.util.Base64;
import is.hugvit.util.HashMapEx;
import is.hugvit.util.HashtableEx;
import is.hugvit.util.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class BirdDatabase {
    private static final DocumentFactory df = new DocumentFactory();
    static final Hashtable page_fields = new Hashtable();
    BirdEngine engine;
    Log log;
    WebContextImpl context;

    BirdDatabase(BirdEngine engine, WebContextImpl context) {
        this.engine = engine;
        this.log = engine.log;
        this.context = context;
    }

    final void createTables(Log log) throws BirdException, SQLException {
        Hashtable<String, String> h;
        try {
            if (!this.tableExists("bird_info")) {
                h = new Hashtable<String, String>();
                h.put("name", "VARCHAR(255)");
                h.put("nvalue", "VARCHAR(255)");
                this.createTable("bird_info", h);
                this.createIndex("BIRD_IINFO", "BIRD_INFO", "NAME");
                log.info("Creating table BIRD_INFO");
            }
        }
        catch (Exception e) {
            log.log(0, "bird_info", e);
        }
        try {
            if (!this.tableExists("bird_file")) {
                h = new Hashtable();
                h.put("id", "VARCHAR(64)");
                h.put("name", "VARCHAR(255)");
                h.put("filename", "VARCHAR(255)");
                h.put("description", "LONG VARCHAR");
                h.put("category", "VARCHAR(255)");
                h.put("type", "VARCHAR(50)");
                h.put("role", "VARCHAR(255)");
                h.put("width", "INTEGER");
                h.put("height", "INTEGER");
                h.put("pwidth", "INTEGER");
                h.put("pheight", "INTEGER");
                h.put("size", "INTEGER");
                h.put("psize", "INTEGER");
                h.put("modified", "TIMESTAMP");
                h.put("modified_by", "VARCHAR(100)");
                h.put("alt", "VARCHAR(255)");
                h.put("pfilename", "VARCHAR(255)");
                h.put("pbody", "BLOB");
                h.put("body", "BLOB");
                h.put("extid", "varchar(255)");
                h.put("encoding", "varchar(100)");
                h.put("folder", "varchar(255)");
                h.put("isprivate", "char(1)");
                this.createTable("bird_file", h);
                this.createIndex("BIRD_IFILE1", "bird_file", "name,filename");
                log.info("Creating table BIRD_FILE");
            }
        }
        catch (Exception e) {
            log.log(0, "bird_file", e);
        }
        try {
            this.alterTableAdd("BIRD_FILE", "isprivate", "char(1)");
            this.alterTableAdd("BIRD_FILE", "extid", "varchar(255)");
            this.alterTableAdd("BIRD_FILE", "encoding", "varchar(100)");
            this.alterTableAdd("BIRD_FILE", "folder", "varchar(255)");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!this.tableExists("bird_menu")) {
                h = new Hashtable();
                h.put("id", "VARCHAR(64)");
                h.put("name", "VARCHAR(255)");
                h.put("alias", "VARCHAR(50)");
                h.put("url", "VARCHAR(255)");
                h.put("role", "VARCHAR(255)");
                h.put("icon", "VARCHAR(100)");
                h.put("modified", "TIMESTAMP");
                h.put("modified_by", "VARCHAR(100)");
                h.put("isprivate", "char(1)");
                this.createTable("bird_menu", h);
                this.createIndex("BIRD_IMENU", "bird_menu", "NAME");
                log.info("Creating table BIRD_MENU");
            }
        }
        catch (Exception e) {
            log.log(0, "bird_menu", e);
        }
        try {
            this.alterTableAdd("BIRD_MENU", "isprivate", "char(1)");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!this.tableExists("bird_page")) {
                this.createTable("bird_page", page_fields);
                this.createIndex("BIRD_IPAGE1", "bird_page", "name");
                this.createIndex("BIRD_IPAGE2", "bird_page", "alias");
                this.createIndex("BIRD_IPAGE3", "bird_page", "folder");
                this.createIndex("BIRD_IPAGE4", "bird_page", "type,name");
                this.createIndex("BIRD_IPAGE5", "bird_page", "type");
                log.info("Creating table BIRD_PAGE");
            }
        }
        catch (Exception e) {
            log.log(2, "bird_page", e);
        }
        try {
            this.alterTableAdd("BIRD_PAGE", "isprivate", "char(1)");
            this.alterTableAdd("BIRD_PAGE", "webrole", "varchar(255)");
            this.alterTableAdd("BIRD_PAGE", "alttitle", "varchar(255)");
            this.alterTableAdd("BIRD_PAGE", "defstatus", "varchar(50)");
            this.alterTableAdd("BIRD_PAGE", "extid", "varchar(255)");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!this.tableExists("bird_list")) {
                h = new Hashtable();
                h.put("id", "VARCHAR(64)");
                h.put("name", "VARCHAR(255)");
                h.put("type", "VARCHAR(255)");
                h.put("template", "VARCHAR(255)");
                h.put("element", "VARCHAR(255)");
                h.put("sort", "VARCHAR(50)");
                h.put("direction", "VARCHAR(50)");
                h.put("showdesc", "CHAR(1)");
                h.put("showdate", "CHAR(1)");
                h.put("showbody", "CHAR(1)");
                h.put("modified", "TIMESTAMP");
                h.put("modified_by", "VARCHAR(100)");
                h.put("dateformat", "VARCHAR(50)");
                h.put("datetype", "VARCHAR(50)");
                this.createTable("bird_list", h);
                this.createIndex("BIRD_ILIST", "bird_list", "NAME");
                log.info("Creating table BIRD_LIST");
            }
        }
        catch (Exception e) {
            log.log(0, "bird_list", e);
        }
        try {
            this.alterTableAdd("BIRD_LIST", "showbody", "char(1)");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!this.tableExists("bird_pagetype")) {
                h = new Hashtable();
                h.put("id", "VARCHAR(64)");
                h.put("name", "VARCHAR(255)");
                h.put("head", "CLOB");
                h.put("role", "VARCHAR(255)");
                h.put("modified", "TIMESTAMP");
                h.put("modified_by", "VARCHAR(100)");
                h.put("templates", "LONG VARCHAR");
                h.put("doctype", "VARCHAR(100)");
                h.put("type", "VARCHAR(50)");
                h.put("elements", "LONG VARCHAR");
                h.put("seqname", "VARCHAR(50)");
                h.put("lifetime", "INTEGER");
                h.put("lists", "LONG VARCHAR");
                h.put("body", "CLOB");
                h.put("folder", "VARCHAR(100)");
                h.put("isprivate", "char(1)");
                this.createTable("bird_pagetype", h);
                this.createIndex("BIRD_IPAGETYPE", "bird_pagetype", "NAME");
                log.info("Creating table BIRD_PAGETYPE");
            }
        }
        catch (Exception e) {
            log.log(0, "bird_pagetype", e);
        }
        try {
            this.alterTableAdd("BIRD_PAGETYPE", "isprivate", "char(1)");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!this.tableExists("bird_template")) {
                h = new Hashtable();
                h.put("id", "VARCHAR(64)");
                h.put("name", "VARCHAR(255)");
                h.put("type", "VARCHAR(50)");
                h.put("role", "VARCHAR(255)");
                h.put("modified", "TIMESTAMP");
                h.put("modified_by", "VARCHAR(100)");
                h.put("body", "CLOB");
                h.put("isprivate", "char(1)");
                this.createTable("bird_template", h);
                this.createIndex("BIRD_ITEMPLATE", "bird_template", "NAME");
                log.info("Creating table BIRD_TEMPLATE");
            }
        }
        catch (Exception e) {
            log.log(0, "bird_template", e);
        }
        try {
            this.alterTableAdd("BIRD_TEMPLATE", "isprivate", "char(1)");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!this.tableExists("bird_element")) {
                h = new Hashtable();
                h.put("id", "VARCHAR(64)");
                h.put("name", "VARCHAR(255)");
                h.put("role", "VARCHAR(255)");
                h.put("modified", "TIMESTAMP");
                h.put("modified_by", "VARCHAR(100)");
                h.put("classname", "VARCHAR(255)");
                h.put("parameters", "LONG VARCHAR");
                h.put("isprivate", "char(1)");
                this.createTable("bird_element", h);
                this.createIndex("BIRD_IELEMENT", "bird_element", "NAME");
                log.info("Creating table BIRD_ELEMENT");
            }
        }
        catch (Exception e) {
            log.log(0, "bird_element", e);
        }
        try {
            this.alterTableAdd("bird_element", "isprivate", "char(1)");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!this.tableExists("bird_comp")) {
                h = new Hashtable();
                h.put("id", "VARCHAR(64)");
                h.put("name", "VARCHAR(255)");
                h.put("classname", "VARCHAR(255)");
                h.put("version", "VARCHAR(50)");
                h.put("modified", "TIMESTAMP");
                h.put("modified_by", "VARCHAR(100)");
                this.createTable("bird_comp", h);
                this.createIndex("BIRD_ICOMP", "bird_comp", "CLASSNAME");
                log.info("Creating table BIRD_COMP");
            }
        }
        catch (Exception e) {
            log.log(0, "bird_comp", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getInfoString(Connection c, String name) throws SQLException {
        String result = "";
        try (PreparedStatement stmt = c.prepareStatement("select nvalue from bird_info where name=?");){
            stmt.setString(1, name);
            try (ResultSet rs = stmt.executeQuery();){
                String s;
                if (rs.next() && (s = rs.getString(1)) != null) {
                    result = s;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setInfoString(Connection c, String name, String value) throws SQLException {
        PreparedStatement select_stmt = c.prepareStatement("select nvalue from bird_info where name=?");
        PreparedStatement insert_stmt = c.prepareStatement("insert into bird_info (name,nvalue) values (?,?)");
        PreparedStatement update_stmt = c.prepareStatement("update bird_info set nvalue=? where name=?");
        try {
            select_stmt.setString(1, name);
            ResultSet rs = select_stmt.executeQuery();
            boolean found = rs.next();
            rs.close();
            if (found) {
                update_stmt.setString(1, value);
                update_stmt.setString(2, name);
                update_stmt.executeUpdate();
            } else {
                insert_stmt.setString(1, name);
                insert_stmt.setString(2, value);
                insert_stmt.executeUpdate();
            }
        }
        finally {
            select_stmt.close();
            insert_stmt.close();
            update_stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean FixTable(Connection c, String table, Log log) throws SQLException {
        boolean result = false;
        PreparedStatement stmt1 = c.prepareStatement("select id,name,body from " + table + " where body like '%bird:%'");
        PreparedStatement stmt2 = c.prepareStatement("update " + table + " set body=?,modified=?,modified_by=? where id=?");
        try {
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            stmt2.setTimestamp(2, ts);
            stmt2.setString(3, "");
            try (ResultSet rs = stmt1.executeQuery();){
                while (rs.next()) {
                    result = true;
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    String body = rs.getString(3);
                    log.info("Fixing " + name + " in " + table);
                    body = Util.replace(body, "bird:", "bird_");
                    stmt2.setString(1, body);
                    stmt2.setString(4, id);
                    stmt2.executeUpdate();
                }
            }
        }
        finally {
            stmt1.close();
            stmt2.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean FixFiles(Connection c, Log log) throws Exception {
        boolean result = false;
        HashMapEx cat = new HashMapEx();
        String rootid = null;
        PreparedStatement stmt1 = c.prepareStatement("select id,filename,category from bird_file where folder is null and not (category is null)");
        PreparedStatement stmt2 = c.prepareStatement("update bird_file set modified=?,modified_by=?,category=?,folder=? where id=?");
        try {
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            stmt2.setTimestamp(1, ts);
            stmt2.setString(2, "");
            stmt2.setNull(3, 12);
            try (ResultSet rs = stmt1.executeQuery();){
                while (rs.next()) {
                    result = true;
                    if (rootid == null) {
                        BirdPage p = this.createPage();
                        p.setTitle("files");
                        p.setVisible(false);
                        p.setTypeFolder();
                        p.save();
                        rootid = p.getID();
                    }
                    String id = rs.getString(1);
                    String filename = rs.getString(2);
                    String category = rs.getString(3);
                    String folder = rootid;
                    if (!category.equals("") && (folder = (String)cat.get(category)) == null) {
                        BirdPage p = this.createPage();
                        p.setTitle(category);
                        p.setTypeFolder();
                        p.setFolder(rootid);
                        p.save();
                        folder = p.getID();
                        cat.put(category, folder);
                    }
                    log.info("Fixing file " + filename);
                    stmt2.setString(4, folder);
                    stmt2.setString(5, id);
                    stmt2.executeUpdate();
                }
            }
        }
        finally {
            stmt1.close();
            stmt2.close();
        }
        return result;
    }

    final void FixDatabase(Connection c, Log log) throws Exception {
        boolean fix_files;
        boolean fix_database = BirdDatabase.getInfoString(c, "bird:fixdatabase").equals("1");
        if (!fix_database) {
            boolean b1 = BirdDatabase.FixTable(c, "bird_template", log);
            boolean b2 = BirdDatabase.FixTable(c, "bird_pagetype", log);
            boolean b3 = BirdDatabase.FixTable(c, "bird_page", log);
            if (b1 || b2 || b3) {
                BirdDatabase.setInfoString(c, "bird:fixdatabase", "1");
            }
        }
        if (!(fix_files = BirdDatabase.getInfoString(c, "bird:fixfiles").equals("1")) && this.FixFiles(c, log)) {
            BirdDatabase.setInfoString(c, "bird:fixfiles", "1");
        }
    }

    public final BirdSession getSession() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public final boolean tableExists(String name) throws SQLException, BirdException {
        try (Connection c = this.connect();){
            boolean bl;
            Statement stmt = c.createStatement();
            try {
                ResultSet rs = stmt.executeQuery("select count(*) from " + name);
                rs.close();
                bl = true;
            }
            catch (SQLException e) {
                boolean bl2 = false;
                stmt.close();
                c.close();
                return bl2;
                {
                    catch (Throwable throwable) {
                        stmt.close();
                        throw throwable;
                    }
                }
            }
            stmt.close();
            return bl;
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createTable(String name, Hashtable fields) throws BirdException {
        try (Connection c = this.connect();){
            NativeTypes nt = new NativeTypes(c);
            try (Statement stmt = c.createStatement();){
                StringBuffer s = new StringBuffer(128);
                s.append("create table ");
                s.append(name);
                s.append(" (");
                Vector<String> v = new Vector<String>();
                Enumeration e = fields.keys();
                while (e.hasMoreElements()) {
                    String n = (String)e.nextElement();
                    String t = ((String)fields.get(n)).toLowerCase();
                    boolean nullable = true;
                    if (t.endsWith(" not null")) {
                        t = t.substring(0, t.length() - 9);
                        nullable = false;
                    }
                    if (!t.startsWith("char") && !t.startsWith("varchar")) {
                        t = nt.getString(t);
                    }
                    if (!nullable) {
                        t = t + " not null";
                    }
                    v.addElement(n + " " + t);
                }
                s.append(Util.expand(v, ","));
                s.append(')');
                this.log.debug(s.toString());
                stmt.executeUpdate(s.toString());
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    private static final void executeUpdate(Connection c, String sql) throws SQLException, BirdException {
        try (Statement stmt = c.createStatement();){
            stmt.executeUpdate(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createIndex(String name, String table, String key) throws SQLException, BirdException {
        try (Connection c = this.connect();){
            StringBuffer s = new StringBuffer(128);
            s.append("create index ");
            s.append(name);
            s.append(" on ");
            s.append(table);
            s.append('(');
            s.append(key);
            s.append(')');
            this.log.debug(s.toString());
            BirdDatabase.executeUpdate(c, s.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alterTableSetPrimary(String table, String col_name, String key_name) throws SQLException, BirdException {
        try (Connection c = this.connect();){
            StringBuffer s = new StringBuffer(128);
            s.append("alter table ");
            s.append(table);
            NativeTypes nt = new NativeTypes(c);
            s.append(" ADD CONSTRAINT ");
            s.append(key_name);
            s.append(" PRIMARY KEY ( ");
            s.append(col_name);
            s.append(" ) ");
            this.log.info(s.toString());
            BirdDatabase.executeUpdate(c, s.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alterTableSetUnique(String table, String col_name, String key_name) throws SQLException, BirdException {
        try (Connection c = this.connect();){
            StringBuffer s = new StringBuffer(128);
            s.append("alter table ");
            s.append(table);
            s.append(" ADD CONSTRAINT ");
            s.append(key_name);
            s.append(" UNIQUE ( ");
            s.append(col_name);
            s.append(" ) ");
            this.log.info(s.toString());
            BirdDatabase.executeUpdate(c, s.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alterTableSetForeignKey(String table, String col_name, String key_name, String refTable, String refcol_name) throws SQLException, BirdException {
        try (Connection c = this.connect();){
            StringBuffer s = new StringBuffer(128);
            s.append("alter table ");
            s.append(table);
            s.append(" ADD CONSTRAINT ");
            s.append(key_name);
            s.append(" FOREIGN KEY ( ");
            s.append(col_name);
            s.append(" ) ");
            s.append(" REFERENCES ");
            s.append(refTable + " ( ");
            s.append(refcol_name);
            s.append(" ) ");
            this.log.info(s.toString());
            BirdDatabase.executeUpdate(c, s.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void alterTableAdd(String table, String name, String type) throws SQLException, BirdException {
        try (Connection c = this.connect();){
            StringBuffer s = new StringBuffer(128);
            s.append("alter table ");
            s.append(table);
            s.append(" add column ");
            s.append(name);
            s.append(' ');
            NativeTypes nt = new NativeTypes(c);
            type = nt.getString(type);
            s.append(type);
            BirdDatabase.executeUpdate(c, s.toString());
        }
    }

    public final BirdPage createPage() throws BirdException {
        return new BirdPage(this, true);
    }

    public final BirdPage createPage(String pagetype) throws BirdException {
        return new BirdPage(this, pagetype);
    }

    public final BirdFile createFile() {
        return new BirdFile(this, true);
    }

    public final BirdPageType createPageType() {
        return new BirdPageType(this);
    }

    public final BirdPageType createPageType(BirdPageType pt) {
        BirdPageType ptnew = new BirdPageType(this);
        ptnew.put(pt.h);
        return ptnew;
    }

    public final BirdElement createElement() {
        return new BirdElement(this);
    }

    public final BirdMenu createMenu() {
        return new BirdMenu(this);
    }

    public final BirdTemplate createTemplate() {
        return new BirdTemplate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BirdPage getPageByName(String name) throws BirdException {
        BirdPage birdPage;
        BirdPage page = null;
        Connection c = this.connect();
        try {
            PreparedStatement stmt = c.prepareStatement("select id,title,folder,role from bird_page where type='PAGE' and name=?");
            stmt.setString(1, name);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                page = new BirdPage(this, false);
                page.put("name", name);
                page.put("id", rs.getString(1));
                page.put("title", rs.getString(2));
                page.put("folder", rs.getString(3));
                page.role = rs.getString(4);
            }
            rs.close();
            stmt.close();
            birdPage = page;
        }
        catch (Throwable throwable) {
            try {
                c.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
        c.close();
        return birdPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BirdPageType getPageTypeBy(String where, String s) throws BirdException {
        BirdPageType birdPageType;
        BirdPageType pt = null;
        Connection c = this.connect();
        try {
            PreparedStatement stmt = c.prepareStatement("select * from bird_pagetype where " + where + "=?");
            stmt.setString(1, s);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                Hashtable h = SQLUtil.getHashtable(rs);
                pt = new BirdPageType(this, false);
                pt.put(h);
            }
            rs.close();
            stmt.close();
            birdPageType = pt;
        }
        catch (Throwable throwable) {
            try {
                c.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
        c.close();
        return birdPageType;
    }

    public final BirdPageType getPageTypeByName(String name) throws BirdException {
        return this.getPageTypeBy("name", name);
    }

    public final BirdPageType getPageTypeByID(String id) throws BirdException {
        return this.getPageTypeBy("id", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BirdPage getPageByID(String id) throws BirdException {
        BirdPage birdPage;
        BirdPage page = null;
        Connection c = this.connect();
        try {
            PreparedStatement stmt = c.prepareStatement("select title,folder,name,role from bird_page where id=?");
            stmt.setString(1, id);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                page = new BirdPage(this, false);
                page.put("id", id);
                page.put("title", rs.getString(1));
                page.put("folder", rs.getString(2));
                page.put("name", rs.getString(3));
                page.role = rs.getString(4);
            }
            rs.close();
            stmt.close();
            birdPage = page;
        }
        catch (Throwable throwable) {
            try {
                c.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
        c.close();
        return birdPage;
    }

    public final BirdPage getPageByExternalID(String id) throws BirdException {
        return this.getPageByExternalID(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BirdPage getPageByExternalID(String id, boolean includeallitems) throws BirdException {
        BirdPage birdPage;
        BirdPage page = null;
        Connection c = this.connect();
        try {
            StringBuffer s = new StringBuffer(128);
            s.append("select id,title,folder,name");
            if (includeallitems) {
                s.append(",author,status,pagedate,startdate,enddate,modified,modified_by,pagetype,description,body");
            }
            s.append(" from bird_page where extid=?");
            try (PreparedStatement stmt = c.prepareStatement(s.toString());){
                stmt.setString(1, id);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        page = new BirdPage(this, false);
                        page.put("extid", id);
                        page.put("id", rs.getString(1));
                        page.put("title", rs.getString(2));
                        page.put("folder", rs.getString(3));
                        page.put("name", rs.getString(4));
                        if (includeallitems) {
                            page.put("author", rs.getString(5));
                            page.put("status", rs.getString(6));
                            Date date = rs.getDate(7);
                            if (date != null) {
                                page.put("pagedate", date);
                            }
                            if ((date = rs.getDate(8)) != null) {
                                page.put("startdate", date);
                            }
                            if ((date = rs.getDate(9)) != null) {
                                page.put("enddate", date);
                            }
                            if ((date = rs.getDate(10)) != null) {
                                page.put("modified", date);
                            }
                            page.put("modified_by", rs.getString(11));
                            page.put("pagetype", rs.getString(12));
                            page.put("description", rs.getString(13));
                            page.put("body", rs.getString(14));
                        }
                    }
                }
            }
            birdPage = page;
        }
        catch (Throwable throwable) {
            try {
                c.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
        c.close();
        return birdPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BirdFile getFileByID(String id) throws BirdException {
        BirdFile birdFile;
        Connection c = this.connect();
        try {
            BirdFile file = null;
            PreparedStatement stmt = c.prepareStatement("select name,folder from bird_file where id=?");
            stmt.setString(1, id);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                file = new BirdFile(this, false);
                file.put("id", id);
                file.put("name", rs.getString(1));
                file.put("folder", rs.getString(2));
            }
            rs.close();
            stmt.close();
            birdFile = file;
        }
        catch (Throwable throwable) {
            try {
                c.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
        c.close();
        return birdFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BirdFile getFileByName(String name) throws BirdException {
        BirdFile birdFile;
        Connection c = this.connect();
        try {
            BirdFile file = null;
            PreparedStatement stmt = c.prepareStatement("select id,category,filename,size,body from bird_file where name=?");
            stmt.setString(1, name);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                file = new BirdFile(this, false);
                file.put("name", name);
                file.put("id", rs.getString(1));
                file.put("category", rs.getString(2));
                file.put("filename", rs.getString(3));
                int size = rs.getInt(4);
                file.put("size", new Integer(size));
                ByteArrayOutputStreamEx out = new ByteArrayOutputStreamEx(size);
                InputStream in = rs.getBinaryStream(5);
                Util.writeStream(in, out);
                in.close();
                file.put("body", new ByteArrayInputStreamEx(out));
            }
            rs.close();
            stmt.close();
            birdFile = file;
        }
        catch (Throwable throwable) {
            try {
                c.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
            catch (IOException e) {
                throw new BirdException(e);
            }
        }
        c.close();
        return birdFile;
    }

    public final Connection connect() throws BirdException {
        try {
            return this.engine.connect();
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public final Connection connect(String name) throws BirdException {
        try {
            return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + name);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public final void clearCache() throws BirdException {
        this.engine.cache.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportData(OutputStream out) throws BirdException {
        try {
            ZipOutputStream zout = new ZipOutputStream(out);
            try (Connection c = this.connect();){
                Statement stmt = c.createStatement();
                BirdDatabase.doTableData(stmt, zout, "bird_page");
                BirdDatabase.doTableData(stmt, zout, "bird_pagetype");
                BirdDatabase.doTableData(stmt, zout, "bird_file");
                BirdDatabase.doTableData(stmt, zout, "bird_list");
                BirdDatabase.doTableData(stmt, zout, "bird_template");
                BirdDatabase.doTableData(stmt, zout, "bird_element");
                BirdDatabase.doTableData(stmt, zout, "bird_datapump");
                BirdDatabase.doTableData(stmt, zout, "bird_thread");
                BirdDatabase.doTableData(stmt, zout, "bird_pool");
                BirdDatabase.doTableData(stmt, zout, "bird_soap");
                BirdDatabase.doTableData(stmt, zout, "bird_menu");
                this.doClassesExport(zout);
                this.doGDRExport(zout);
                stmt.close();
            }
            zout.finish();
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    private static final boolean isRoleTable(String name) {
        if (name.equals("bird_page")) {
            return true;
        }
        if (name.equals("bird_pagetype")) {
            return true;
        }
        if (name.equals("bird_pagetype")) {
            return true;
        }
        if (name.equals("bird_element")) {
            return true;
        }
        if (name.equals("bird_file")) {
            return true;
        }
        return name.equals("bird_template");
    }

    private final void doClassesExport(ZipOutputStream out) throws IOException {
        File file = new File(this.engine.servletcontext.getRealPath("/"), "WEB-INF/classes");
        if (file.exists()) {
            FileEx fx = new FileEx(file);
            Enumeration e = fx.listFilesRecursive();
            while (e.hasMoreElements()) {
                File f = (File)e.nextElement();
                String path = f.getAbsolutePath();
                String filename = path.substring(file.getAbsolutePath().length() + 1).replace('\\', '/');
                out.putNextEntry(new ZipEntry("classes/" + filename));
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                Util.writeStream(in, out);
                ((InputStream)in).close();
                out.closeEntry();
            }
        }
    }

    private final void doGDRExport(ZipOutputStream out) throws IOException {
        File file = new File(this.engine.servletcontext.getRealPath("/"), "WEB-INF/router.xml");
        if (file.exists()) {
            out.putNextEntry(new ZipEntry("gdr/router.xml"));
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            Util.writeStream(in, out);
            ((InputStream)in).close();
            out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doTableData(Statement stmt, ZipOutputStream out, String table) throws IOException {
        String row = table.toLowerCase();
        Element root = df.createElement("data");
        Document doc = df.createDocument(root);
        int count = 0;
        try {
            StringBuffer s = new StringBuffer(128);
            s.append("select * from " + table);
            if (BirdDatabase.isRoleTable(table)) {
                s.append(" where isprivate is null or isprivate='0'");
            } else if (table.equals("bird_menu")) {
                s.append(" where alias is null or not(alias like 'bird:%')");
            }
            try (ResultSet rs = stmt.executeQuery(s.toString());){
                while (rs.next()) {
                    Element e = root.addElement(row);
                    BirdDatabase.resultSetToXML(rs, e);
                    ++count;
                }
            }
        }
        catch (SQLException e) {
            return;
        }
        if (count > 0) {
            out.putNextEntry(new ZipEntry("data/" + row + ".xml"));
            OutputFormat format = new OutputFormat("", true, "UTF-8");
            format.setIndent(true);
            XMLWriter xw = new XMLWriter((OutputStream)out, format);
            xw.write(doc);
            out.closeEntry();
        }
    }

    private static final void resultSetToXML(ResultSet rs, Element root) throws SQLException, IOException {
        ResultSetMetaData rsm = rs.getMetaData();
        int count = rsm.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String col_name = rsm.getColumnName(i).toLowerCase();
            int type = rsm.getColumnType(i);
            String col_type = SQLUtil.getTypeString(type);
            if (type == 93 && col_name.indexOf("date") > -1) {
                col_type = "date";
                type = 91;
            }
            if (type == 2004 || type == -4) {
                InputStream in = rs.getBinaryStream(i);
                if (in == null) continue;
                Element e = root.addElement(col_name);
                e.addAttribute("type", "blob");
                ByteArrayOutputStreamEx out = new ByteArrayOutputStreamEx(2048);
                Util.writeStream(in, out);
                in.close();
                String value = Base64.encodeBytes(out.getBuffer(), 0, out.size());
                e.addAttribute("encoding", "base64");
                e.addText(value);
                continue;
            }
            Element e = root.addElement(col_name);
            String value = SQLUtil.getString(rs, i, type);
            if (value == null) {
                e.addAttribute("type", "null." + col_type);
                continue;
            }
            value = value.replace('\u0002', ' ');
            value = value.replace('\u0000', ' ');
            e.addAttribute("type", col_type);
            if ((type == 2005 || type == -1) && value.indexOf(60) > -1) {
                e.addCDATA(value);
                continue;
            }
            e.addText(value);
        }
    }

    private final void doClassesImport(ZipInputStream in, String filename) throws IOException {
        File dir = new File(this.engine.servletcontext.getRealPath("/"), "WEB-INF");
        if (!dir.exists()) {
            return;
        }
        File f = new File(dir, filename);
        f.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(f);
        Util.writeStream(in, out);
        ((OutputStream)out).close();
    }

    private final void doGDRImport(ZipInputStream in) throws IOException {
        File dir = new File(this.engine.servletcontext.getRealPath("/"), "WEB-INF");
        if (!dir.exists()) {
            return;
        }
        File f = new File(dir, "router.xml");
        f.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(f);
        Util.writeStream(in, out);
        ((OutputStream)out).close();
    }

    private final void doEntry(Connection c, ZipEntry ze, ZipInputStream zin) throws Exception {
        if (!ze.isDirectory()) {
            String filename = ze.getName();
            if (filename.startsWith("classes/")) {
                this.doClassesImport(zin, filename);
                return;
            }
            if (filename.equals("gdr/router.xml")) {
                this.doGDRImport(zin);
                return;
            }
            String ext = Util.getFileExt(filename).toLowerCase();
            if (ext.equals(".xml")) {
                if (filename.startsWith("tables/")) {
                    this.doTables(zin);
                } else if (filename.startsWith("data/") || filename.indexOf(47) == -1) {
                    BirdDatabase.doXMLData(zin, c, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importData(InputStream in) throws BirdException {
        try {
            try (Connection dc = this.connect();){
                ZipInputStream zin = new ZipInputStream(in);
                ZipEntry ze = zin.getNextEntry();
                while (ze != null) {
                    this.doEntry(dc, ze, zin);
                    ze = zin.getNextEntry();
                }
            }
            this.engine.refreshComponents();
        }
        catch (BirdException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importXMLData(InputStream in, boolean hide) throws BirdException {
        try (Connection dc = this.connect();){
            BirdDatabase.doXMLData(in, dc, hide);
        }
        catch (BirdException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeData(InputStream in) throws BirdException {
        try (Connection dc = this.connect();){
            SAXReader reader = new SAXReader(false);
            Document document = reader.read((InputStream)new OpenInputStream(in));
            Element root = document.getRootElement();
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element e = (Element)it.next();
                String table = e.getName();
                try (PreparedStatement stmt = dc.prepareStatement("delete from " + table + " where id=?");){
                    String id = e.elementText("id");
                    if (id == null) continue;
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                }
            }
        }
        catch (BirdException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    private final void doTables(InputStream in) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new OpenInputStream(in));
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("table");
        while (it.hasNext()) {
            Element e = (Element)it.next();
            this.doCreateTable(e);
        }
    }

    private static final void doXMLData(InputStream in, Connection dc, boolean hide) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new OpenInputStream(in));
        Element root = document.getRootElement();
        Iterator it = root.elementIterator();
        NativeTypes n = new NativeTypes(dc);
        while (it.hasNext()) {
            Element e = (Element)it.next();
            BirdDatabase.doElement(e, dc, hide, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doElement(Element e, Connection dc, boolean hide, NativeTypes nativetypes) throws Exception {
        String table = e.getName();
        Iterator it = e.elementIterator();
        HashtableEx h = new HashtableEx();
        while (it.hasNext()) {
            int t;
            Element f = (Element)it.next();
            String name = f.getName();
            String type = f.attributeValue("type");
            Object value = null;
            if (type.startsWith("null.")) {
                t = SQLUtil.getTypeInt(type = type.substring(5));
                if (t == -4) {
                    t = nativetypes.getInt(2004);
                }
                value = new Null(t);
            } else {
                String encoding;
                t = SQLUtil.getTypeInt(type);
                String s = f.getText();
                value = t == 2004 || t == -4 ? ((encoding = f.attributeValue("encoding")) != null && encoding.equals("base64") ? new ByteArrayInputStreamEx(Base64.decode(s)) : new ByteArrayInputStreamEx(s.getBytes("ISO-8859-1"))) : SQLUtil.getObject(s, t);
            }
            ((Hashtable)h).put(name, value);
        }
        if (((Hashtable)h).containsKey("id") && ((Hashtable)h).containsKey("modified")) {
            PreparedStatement stmt = dc.prepareStatement("select modified from " + table + " where id=?");
            stmt.setString(1, (String)h.get("id"));
            ResultSet rd = stmt.executeQuery();
            try {
                if (rd.next()) {
                    boolean update = true;
                    Timestamp ts1 = rd.getTimestamp(1);
                    if (ts1 != null) {
                        java.util.Date d1 = Util.timestampToDate(ts1);
                        java.util.Date d2 = Util.timestampToDate((Timestamp)h.get("modified"));
                        update = d2.after(d1);
                    }
                    if (update) {
                        Hashtable key = new Hashtable();
                        key.put("id", h.get("id"));
                        BirdUtil.update(dc, table, h, key);
                    }
                    return;
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        if (hide) {
            ((Hashtable)h).put("isprivate", "1");
        }
        BirdUtil.insert(dc, table, h);
    }

    private final void doCreateTable(Element e) {
        String table = e.elementText("name");
        Iterator it = e.elementIterator("field");
        HashtableEx h = new HashtableEx();
        while (it.hasNext()) {
            Element f = (Element)it.next();
            String name = f.elementText("name");
            String type = f.elementText("type");
            String required = f.elementText("required");
            if (required != null && required.equals("1")) {
                type = type + " not null";
            }
            ((Hashtable)h).put(name, type);
        }
        try {
            this.createTable(table, h);
            Iterator it2 = e.elementIterator("index");
            while (it2.hasNext()) {
                Element f = (Element)it2.next();
                this.createIndex(f.elementText("name"), table, f.elementText("field"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Hashtable h = page_fields;
        h.put("id", "VARCHAR(64)");
        h.put("name", "VARCHAR(255)");
        h.put("author", "VARCHAR(255)");
        h.put("alias", "VARCHAR(255)");
        h.put("role", "VARCHAR(255)");
        h.put("status", "VARCHAR(50)");
        h.put("dynamic", "char(1)");
        h.put("startdate", "DATE");
        h.put("enddate", "DATE");
        h.put("pagedate", "DATE");
        h.put("modified", "TIMESTAMP");
        h.put("modified_by", "VARCHAR(100)");
        h.put("lists", "LONG VARCHAR");
        h.put("title", "VARCHAR(255)");
        h.put("pagetype", "VARCHAR(255)");
        h.put("templates", "LONG VARCHAR");
        h.put("elements", "LONG VARCHAR");
        h.put("listcategory", "VARCHAR(50)");
        h.put("listcount", "INTEGER");
        h.put("showlist", "VARCHAR(255)");
        h.put("host", "VARCHAR(255)");
        h.put("folder", "VARCHAR(255)");
        h.put("body", "CLOB");
        h.put("description", "LONG VARCHAR");
        h.put("textbody", "CLOB");
        h.put("data", "CLOB");
        h.put("visible", "CHAR(1)");
        h.put("listimage", "VARCHAR(100)");
        h.put("sort", "INTEGER");
        h.put("type", "VARCHAR(30)");
        h.put("alttitle", "VARCHAR(255)");
        h.put("defstatus", "VARCHAR(50)");
        h.put("extid", "VARCHAR(255)");
        h.put("webrole", "VARCHAR(255)");
        h.put("isprivate", "CHAR(1)");
        h.put("lang", "VARCHAR(10)");
    }
}

