/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.util.HashMapEx;
import is.hugvit.util.HashtableEx;
import is.hugvit.util.PropertiesEx;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

final class BirdConfig {
    private final HashMapEx h = new HashMapEx();

    BirdConfig() {
        this.h.put("name", "");
        this.h.put("mainpage", "index.html");
        this.h.put("errorpage", "");
        this.h.put("unauthorizedpage", "");
        this.h.put("xsl_parser", "saxon");
        this.h.put("gzip", new Boolean(true));
        this.h.put("doctype", "html5");
        this.h.put("indent", new Boolean(false));
        this.h.put("debug", new Boolean(true));
        this.h.put("cp1252", new Boolean(false));
        this.h.put("ignore_error", new Boolean(false));
        this.h.put("templates", new Integer(50));
        this.h.put("files", new Integer(500));
        this.h.put("encoding", "UTF-8");
        this.h.put("max_idle", new Integer(5));
        this.h.put("max_active", new Integer(20));
        this.h.put("exhausted_action", "block");
        this.h.put("max_wait", new Integer(10));
        this.h.put("abandoned_timeout", new Integer(300));
        this.h.put("log_level", new Integer(1));
        this.h.put("parameters", new PropertiesEx());
        this.h.put("namespaces", new PropertiesEx());
        this.h.put("unauthorizedpage", "");
        boolean b = false;
        this.h.put("webservice", new Boolean(b));
        this.h.put("server_id", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getValue(PreparedStatement stmt, String name) throws SQLException {
        String result = null;
        stmt.setString(1, "bird:" + name);
        try (ResultSet rs = stmt.executeQuery();){
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        return result;
    }

    final String getMainPage() {
        return (String)this.h.get("mainpage");
    }

    final String getErrorPage() {
        return (String)this.h.get("errorpage");
    }

    final String getUnAuthorizedPage() {
        return (String)this.h.get("unauthorizedpage");
    }

    final boolean getIgnoreError() {
        return (Boolean)this.h.get("ignore_error");
    }

    final Properties getParameters() {
        return (Properties)this.h.get("parameters");
    }

    final Properties getNamespaces() {
        return (Properties)this.h.get("namespaces");
    }

    final String getEncoding() {
        return (String)this.h.get("encoding");
    }

    final String getDocType() {
        return (String)this.h.get("doctype");
    }

    final String getName() {
        return (String)this.h.get("name");
    }

    final boolean getDebug() {
        return (Boolean)this.h.get("debug");
    }

    final boolean getCP1252() {
        return (Boolean)this.h.get("cp1252");
    }

    final boolean getWebService() {
        return (Boolean)this.h.get("webservice");
    }

    final String getXSLParserClassname() {
        String type = (String)this.h.get("xsl_parser");
        String name = "";
        if (type != null) {
            if (type.equals("xalan")) {
                name = "org.apache.xalan.processor.TransformerFactoryImpl";
            } else if (type.equals("xsltc")) {
                name = "org.apache.xalan.xsltc.trax.TransformerFactoryImpl";
            } else if (type.equals("xt")) {
                name = "is.hugvit.xml.jclark.XT_TransformerFactory";
            } else if (type.equals("saxon")) {
                name = "net.sf.saxon.TransformerFactoryImpl";
            }
        }
        return name;
    }

    final boolean useGZIP() {
        return (Boolean)this.h.get("gzip");
    }

    final int getLogLevel() {
        return (Integer)this.h.get("log_level");
    }

    final boolean useIndent() {
        return (Boolean)this.h.get("indent");
    }

    final byte getExhaustedAction() {
        String action = (String)this.h.get("exhausted_action");
        if (action.equals("grow")) {
            return 2;
        }
        return 1;
    }

    final int getTemplates() {
        return (Integer)this.h.get("templates");
    }

    final int getFiles() {
        return (Integer)this.h.get("files");
    }

    final int getMaxIdle() {
        return (Integer)this.h.get("max_idle");
    }

    final int getMaxActive() {
        return (Integer)this.h.get("max_active");
    }

    final int getMaxWait() {
        return (Integer)this.h.get("max_wait");
    }

    final int getAbandonedTimeout() {
        return (Integer)this.h.get("abandoned_timeout");
    }

    final Hashtable getConfig() {
        return new HashtableEx(this.h);
    }

    final void putConfig(Hashtable t) {
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.h.put(key, t.get(key));
        }
    }

    final void load(Connection c) throws SQLException {
        PreparedStatement stmt = c.prepareStatement("select nvalue from bird_info where name=?");
        Enumeration e = this.h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = BirdConfig.getValue(stmt, key);
            if (value == null) continue;
            Object obj = this.h.get(key);
            obj = obj instanceof Boolean ? new Boolean(value.equals("1")) : (obj instanceof Integer ? new Integer(value) : (key.equals("parameters") || key.equals("namespaces") ? new PropertiesEx(value) : value));
            this.h.put(key, obj);
        }
        stmt.close();
    }

    final void save(Connection c) throws SQLException {
        PreparedStatement select_stmt = c.prepareStatement("select nvalue from bird_info where name=?");
        PreparedStatement insert_stmt = c.prepareStatement("insert into bird_info (name,nvalue) values (?,?)");
        PreparedStatement update_stmt = c.prepareStatement("update bird_info set nvalue=? where name=?");
        Enumeration e = this.h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = this.h.get(key);
            if (value instanceof Boolean) {
                value = (Boolean)value != false ? "1" : "0";
            } else if (value instanceof PropertiesEx) {
                PropertiesEx p = (PropertiesEx)value;
                value = p.toString();
            }
            if (BirdConfig.getValue(select_stmt, key) == null) {
                insert_stmt.setString(1, "bird:" + key);
                insert_stmt.setString(2, value.toString());
                insert_stmt.executeUpdate();
                continue;
            }
            update_stmt.setString(1, value.toString());
            update_stmt.setString(2, "bird:" + key);
            update_stmt.executeUpdate();
        }
        select_stmt.close();
        insert_stmt.close();
        update_stmt.close();
    }
}

