/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.util.HashtableEx;
import is.hugvit.util.UID;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;

class BirdBaseObject {
    BirdDatabase db;
    HashtableEx h;
    boolean is_new = true;

    BirdBaseObject(BirdDatabase db) {
        this.db = db;
        this.h = new HashtableEx();
    }

    public final void put(String name, Object value) {
        this.h.put(name, value);
    }

    public final Object get(String name) {
        return this.h.get(name);
    }

    protected final void delete(String table) throws BirdException {
        try (Connection c = this.db.connect();){
            BirdUtil.delete(c, table, (String)this.h.get("id"));
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public final void put(Hashtable h2) {
        Enumeration e = h2.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this.h.put(key, h2.get(key));
        }
    }

    public final String getID() {
        return (String)this.h.get("id");
    }

    public final Hashtable getHashtable() {
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void save(String table) throws BirdException {
        try (Connection c = this.db.connect();){
            this.h.put("modified", new Timestamp(System.currentTimeMillis()));
            if (this.db.context != null) {
                this.h.put("modified_by", this.db.context.getRequest().getRemoteUser());
            }
            if (this.is_new) {
                this.h.put("id", UID.getUID());
                BirdUtil.insert(c, table, this.h);
            } else {
                Hashtable key = new Hashtable();
                key.put("id", this.h.get("id"));
                BirdUtil.update(c, table, this.h, key);
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }
}

