/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.utilities.io;

import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import com.ibm.form.api.internal.utilities.io.Base64Converter;
import com.ibm.form.api.internal.utilities.io.Base64GzipConverter;
import com.ibm.form.api.internal.utilities.io.BasicConverter;
import com.ibm.form.api.internal.utilities.io.IEncodingConverter;
import com.ibm.form.api.internal.utilities.io.MimeType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class IOManager {
    public static final String BASE64_GZIP_ENCODING = "base64-gzip";
    public static final String MIME_TYPE_ATTR_CONTENT_ENCODING = "content-encoding";
    public static final String MIME_TYPE_PRIMARY_APPLICATION = "application";
    public static final String MIME_TYPE_SUB_VND_XFDL = "vnd.xfdl";
    public static final String DEFAULT_ENCODING = "";
    private static final String UNABLE_TO_CREATE_OUTPUT_FOR = Messages.IOManager_UnableToCreateStream.toStringAsRequest();
    public static final String BASE64_ENCODING = "base64";
    private static ArrayList converters = null;

    public static void addConverter(IEncodingConverter converter) {
        if (!converters.contains(converter)) {
            converters.add(converter);
        }
    }

    public static OutputStream getOutputStream(String desiredEncoding, OutputStream basicStream, boolean writeEncoding) throws IOException {
        if (desiredEncoding == null) {
            desiredEncoding = DEFAULT_ENCODING;
        }
        if (writeEncoding && !desiredEncoding.equals(DEFAULT_ENCODING)) {
            StringBuffer buff = new StringBuffer(MIME_TYPE_PRIMARY_APPLICATION);
            buff.append("/");
            buff.append(MIME_TYPE_SUB_VND_XFDL);
            buff.append("; ");
            buff.append(MIME_TYPE_ATTR_CONTENT_ENCODING);
            buff.append("=\"");
            buff.append(desiredEncoding);
            buff.append("\"");
            buff.append("\n");
            basicStream.write(buff.toString().getBytes());
        }
        Iterator i = ((AbstractList)converters).iterator();
        while (i.hasNext()) {
            IEncodingConverter aConverter = (IEncodingConverter)i.next();
            if (!aConverter.toEncoding().equals(DEFAULT_ENCODING) || !aConverter.fromEncoding().equals(desiredEncoding)) continue;
            return aConverter.toStream(basicStream);
        }
        throw new IOException(LocalizedStringFormat.bind(UNABLE_TO_CREATE_OUTPUT_FOR, (Object)desiredEncoding));
    }

    public static InputStream getInputStream(String desiredEncoding, InputStream basicStream, String overrideInputEncoding, StringBuffer readEncoding, StringBuffer failureReason) throws IOException {
        String theContentEncoding;
        MimeType theType = null;
        String theTotalString = null;
        if (readEncoding != null) {
            readEncoding.setLength(0);
        }
        if (failureReason != null) {
            failureReason.setLength(0);
        }
        BufferedInputStream theBuffStream = new BufferedInputStream(basicStream);
        theBuffStream.mark(1000);
        if (null != overrideInputEncoding) {
            theContentEncoding = overrideInputEncoding;
        } else {
            String theLine;
            byte[] theBuffer = new byte[128];
            int theResult = theBuffStream.read(theBuffer);
            if ((theBuffer[0] & 0xEF) == 239) {
                int i;
                byte[] tmp = new byte[128];
                for (i = 0; i < theBuffer.length - 3; ++i) {
                    tmp[i] = theBuffer[i + 3];
                }
                theBuffer = new byte[128];
                for (i = 0; i < tmp.length; ++i) {
                    theBuffer[i] = tmp[i];
                }
            }
            if ((theLine = new String(theBuffer, "UTF-8")).startsWith(MIME_TYPE_PRIMARY_APPLICATION)) {
                int lineReturn;
                StringBuffer theFirstLine = new StringBuffer(theLine);
                while (theLine.indexOf(10) == -1) {
                    theResult = theBuffStream.read(theBuffer);
                    if (theResult > 0) {
                        theLine = new String(theBuffer);
                        theFirstLine.append(theLine);
                    }
                    if (theResult == theBuffer.length) continue;
                }
                if ((lineReturn = (theTotalString = theFirstLine.toString()).indexOf(10)) != -1) {
                    theTotalString = theTotalString.substring(0, lineReturn);
                }
                theType = new MimeType(theTotalString);
            }
            theBuffStream.reset();
            if (theType != null && theType.getPrimaryType().equals(MIME_TYPE_PRIMARY_APPLICATION) && theType.getSubType().equals(MIME_TYPE_SUB_VND_XFDL)) {
                byte[] dummyBytes = new byte[theTotalString.length() + 1];
                theResult = theBuffStream.read(dummyBytes);
                theContentEncoding = theType.getAttribute(MIME_TYPE_ATTR_CONTENT_ENCODING);
            } else {
                theContentEncoding = DEFAULT_ENCODING;
            }
        }
        if (readEncoding != null) {
            readEncoding.append(theContentEncoding);
        }
        Iterator i = ((AbstractList)converters).iterator();
        while (i.hasNext()) {
            IEncodingConverter aConverter = (IEncodingConverter)i.next();
            if (!aConverter.toEncoding().equals(desiredEncoding) || !aConverter.fromEncoding().equals(theContentEncoding)) continue;
            InputStream theStream = aConverter.fromStream(theBuffStream, failureReason);
            if (theStream != null) {
                return theStream;
            }
            theBuffStream.reset();
            return theBuffStream;
        }
        if (failureReason != null) {
            failureReason.append(LocalizedStringFormat.bind(Messages.IOManager_UnsupportedEncoding.toStringAsRequest(), (Object)theContentEncoding));
        }
        theBuffStream.reset();
        return theBuffStream;
    }

    static {
        if (converters == null) {
            converters = new ArrayList();
            converters.add(Base64GzipConverter.getInstance());
            converters.add(Base64Converter.getInstance());
            converters.add(BasicConverter.getInstance());
        }
    }
}

