/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.utilities.io;

import com.ibm.form.api.internal.utilities.Messages;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BufferingOutputStream
extends FilterOutputStream {
    protected byte[] theBuffer;
    protected int count;

    public BufferingOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException(Messages.BufferingOutputStream_BufferSize.toStringAsRequest());
        }
        this.theBuffer = new byte[size];
    }

    protected abstract void flushBuffer() throws IOException;

    public synchronized void write(int b) throws IOException {
        byte[] theByte = new byte[]{(byte)b};
        this.write(theByte, 0, 1);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        while (len > this.theBuffer.length - this.count) {
            int theBufferRemaining = this.theBuffer.length - this.count;
            System.arraycopy(b, off, this.theBuffer, this.count, theBufferRemaining);
            len -= theBufferRemaining;
            off += theBufferRemaining;
            this.count += theBufferRemaining;
            this.flushBuffer();
        }
        if (len > 0) {
            System.arraycopy(b, off, this.theBuffer, this.count, len);
        }
        this.count += len;
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

