/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.utilities.io;

import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import com.ibm.form.api.internal.utilities.io.Base64DecodeFromInputStream;
import com.ibm.form.api.internal.utilities.io.Base64EncodeToOutputStream;
import com.ibm.form.api.internal.utilities.io.IEncodingConverter;
import com.ibm.form.api.internal.utilities.io.NonClosingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Base64GzipConverter
implements IEncodingConverter {
    private static Base64GzipConverter theInstance = null;

    private Base64GzipConverter() {
    }

    public static Base64GzipConverter getInstance() {
        if (theInstance == null) {
            theInstance = new Base64GzipConverter();
        }
        return theInstance;
    }

    public String fromEncoding() {
        return "base64-gzip";
    }

    public String toEncoding() {
        return "";
    }

    public InputStream fromStream(InputStream inputStream, StringBuffer failureReason) {
        try {
            return new GZIPInputStream(new Base64DecodeFromInputStream(inputStream));
        }
        catch (IOException ex) {
            if (failureReason != null) {
                failureReason.append(LocalizedStringFormat.bind(Messages.Base64GzipConverter_ParseException.toStringAsRequest(), (Object)ex.getMessage()));
            }
            return null;
        }
    }

    public OutputStream toStream(OutputStream currentStream) throws IOException {
        return new GZIPOutputStream(new Base64EncodeToOutputStream(new NonClosingOutputStream(currentStream)));
    }
}

