/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.utilities.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64DecodeFromInputStream
extends FilterInputStream {
    private byte[] leftOverDecodedBytes = null;
    private byte[] leftOverEncodedBytes = null;
    private int decodedOffset = 0;
    private int numberOfUndecodedBytes = 0;
    private static byte[] codes;

    public Base64DecodeFromInputStream(InputStream in) {
        super(in);
    }

    private boolean hasLeftOvers() {
        return this.leftOverEncodedBytes != null && this.leftOverEncodedBytes.length > 0;
    }

    public synchronized int read() throws IOException {
        byte[] small = new byte[1];
        int result = this.read(small);
        if (result != -1) {
            return small[0] < 0 ? small[0] + 256 : small[0];
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized int read(byte[] arg0, int off, int len) throws IOException {
        byte[] baseData = new byte[len];
        int nextEncodedIndex = 0;
        boolean noMoreBytes = false;
        do {
            int counter;
            byte[] decodedData;
            block8: {
                block9: {
                    if (this.leftOverDecodedBytes != null) break block9;
                    int bytesRead = super.read(baseData, off, len);
                    if (bytesRead != -1) {
                        decodedData = this.base64Decode(baseData, bytesRead, false);
                        counter = 0;
                        break block8;
                    } else if (this.hasLeftOvers()) {
                        decodedData = this.base64Decode(baseData, 0, true);
                        counter = 0;
                        noMoreBytes = true;
                        break block8;
                    } else {
                        if (nextEncodedIndex != 0) {
                            return nextEncodedIndex;
                        }
                        return -1;
                    }
                }
                decodedData = this.leftOverDecodedBytes;
                counter = this.decodedOffset;
                this.leftOverDecodedBytes = null;
            }
            int copyLength = len - nextEncodedIndex > decodedData.length - counter ? decodedData.length - counter : len - nextEncodedIndex;
            System.arraycopy(decodedData, counter, arg0, nextEncodedIndex, copyLength);
            if (decodedData.length - counter >= len - nextEncodedIndex) {
                if (decodedData.length - counter != copyLength) {
                    this.leftOverDecodedBytes = decodedData;
                    this.decodedOffset = counter + copyLength;
                }
                return len;
            }
            nextEncodedIndex += copyLength;
        } while (!noMoreBytes);
        return nextEncodedIndex;
    }

    public int read(byte[] arg0) throws IOException {
        return this.read(arg0, 0, arg0.length);
    }

    private byte[] base64Decode(byte[] data, int length, boolean getLeftOvers) {
        byte aByte;
        int i;
        if (data == null) {
            return null;
        }
        byte[] outData = new byte[(this.leftOverEncodedBytes == null ? 0 : this.leftOverEncodedBytes.length) + length];
        int totalCount = 0;
        int accumulator = 0;
        int shiftedBits = 0;
        int partiallyDecodedFoursome = 0;
        int decodingStartIndex = -1;
        if (this.leftOverEncodedBytes != null) {
            for (i = 0; i < this.leftOverEncodedBytes.length; ++i) {
                aByte = codes[this.leftOverEncodedBytes[i]];
                if (aByte < 0) continue;
                accumulator <<= 6;
                accumulator |= aByte;
                if ((shiftedBits += 6) >= 8) {
                    ++partiallyDecodedFoursome;
                    outData[totalCount++] = (byte)(accumulator >> (shiftedBits -= 8) & 0xFF);
                }
                if (shiftedBits != 0) continue;
                partiallyDecodedFoursome = 0;
            }
        }
        if (getLeftOvers) {
            byte[] backData = new byte[totalCount];
            System.arraycopy(outData, 0, backData, 0, totalCount);
            this.leftOverEncodedBytes = null;
            return backData;
        }
        for (i = 0; i < length; ++i) {
            aByte = codes[data[i]];
            if (aByte < 0) continue;
            ++this.numberOfUndecodedBytes;
            if (shiftedBits == 0) {
                decodingStartIndex = i;
            }
            accumulator <<= 6;
            accumulator |= aByte;
            if ((shiftedBits += 6) >= 8) {
                ++partiallyDecodedFoursome;
                outData[totalCount++] = (byte)(accumulator >> (shiftedBits -= 8) & 0xFF);
            }
            if (shiftedBits != 0) continue;
            decodingStartIndex = -1;
            partiallyDecodedFoursome = 0;
            this.numberOfUndecodedBytes = 0;
            this.leftOverEncodedBytes = null;
        }
        if (this.leftOverEncodedBytes != null) {
            byte[] temp = new byte[this.leftOverEncodedBytes.length + data.length];
            System.arraycopy(this.leftOverEncodedBytes, 0, temp, 0, this.leftOverEncodedBytes.length);
            System.arraycopy(data, 0, temp, this.leftOverEncodedBytes.length, data.length);
            this.leftOverEncodedBytes = temp;
            return new byte[0];
        }
        if (decodingStartIndex != -1) {
            this.leftOverEncodedBytes = new byte[length - decodingStartIndex];
            System.arraycopy(data, decodingStartIndex, this.leftOverEncodedBytes, 0, length - decodingStartIndex);
        } else {
            this.leftOverEncodedBytes = null;
        }
        byte[] backData = new byte[totalCount - partiallyDecodedFoursome];
        System.arraycopy(outData, 0, backData, 0, totalCount - partiallyDecodedFoursome);
        return backData;
    }

    static {
        int i;
        codes = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64DecodeFromInputStream.codes[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64DecodeFromInputStream.codes[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64DecodeFromInputStream.codes[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64DecodeFromInputStream.codes[i] = (byte)(52 + i - 48);
        }
        Base64DecodeFromInputStream.codes[43] = 62;
        Base64DecodeFromInputStream.codes[47] = 63;
    }
}

