/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.utilities.i18n;

import com.ibm.form.api.internal.utilities.FormLogger;
import com.ibm.form.api.internal.utilities.i18n.LocaleUtils;
import com.ibm.form.api.internal.utilities.i18n.nl.Messages;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalizedString {
    protected String bundleName;
    protected String key;
    protected ClassLoader loader;

    public LocalizedString(String bundleName, String key, ClassLoader loader) {
        Logger logger;
        if (null == bundleName || 0 == bundleName.length()) {
            bundleName = null;
            logger = FormLogger.getLogger();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Messages.LocalizedString_InvalidBundleError.toStringAsRequest());
            }
        }
        if (null == key || 0 == key.length()) {
            key = null;
            logger = FormLogger.getLogger();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Messages.LocalizedString_InvalidKeyError.toStringAsRequest());
            }
        }
        if (null == loader) {
            logger = FormLogger.getLogger();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Messages.LocalizedString_InvalidLoaderError.toStringAsRequest());
            }
            loader = this.getClass().getClassLoader();
        }
        this.bundleName = bundleName;
        this.key = key;
        this.loader = loader;
    }

    public LocalizedString(String key) {
        this.key = key;
    }

    public String toString() {
        return this.getLocalizedString(LocaleUtils.getRequestLocale());
    }

    public String toStringAsApp() {
        return this.getLocalizedString(LocaleUtils.getAppLocale());
    }

    public String toStringAsRequest() {
        return this.getLocalizedString(LocaleUtils.getRequestLocale());
    }

    public String toStringAsForm() {
        return this.getLocalizedString(LocaleUtils.getFormLocale());
    }

    public String toString(Locale locale) {
        return this.getLocalizedString(locale);
    }

    protected String getLocalizedString(Locale locale) {
        if (null == this.key) {
            return null;
        }
        if (null == this.bundleName) {
            return this.key;
        }
        String returnValue = null;
        ResourceBundle bundle = this.getBundle(this.bundleName, locale, this.loader);
        if (null != bundle) {
            returnValue = bundle.getString(this.key);
        }
        return returnValue;
    }

    protected ResourceBundle getBundle(String name, Locale locale, ClassLoader loader) {
        ResourceBundle bundle;
        block3: {
            if (null == locale) {
                locale = LocaleUtils.getAppLocale();
            }
            bundle = null;
            try {
                bundle = ResourceBundle.getBundle(name, locale, loader);
            }
            catch (MissingResourceException mre) {
                Logger logger = FormLogger.getLogger();
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger.fine(mre.getMessage());
                logger.fine(mre.getStackTrace().toString());
            }
        }
        return bundle;
    }
}

