/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.utilities.i18n;

import java.util.Locale;

public class LocaleUtils {
    private static ThreadLocal formLocale;
    private static ThreadLocal requestLocale;
    private static Locale appLocale;

    public static void setRequestLocale(Locale locale) {
        if (null == requestLocale) {
            requestLocale = new ThreadLocal();
        }
        if (null == locale || 0 == locale.toString().length()) {
            locale = Locale.getDefault();
        }
        requestLocale.set(locale);
    }

    public static Locale getRequestLocale() {
        if (null == requestLocale) {
            return null;
        }
        return (Locale)requestLocale.get();
    }

    public static void setFormLocale(Locale locale) {
        if (null == formLocale) {
            formLocale = new ThreadLocal();
        }
        if (null == locale || 0 == locale.toString().length()) {
            locale = Locale.getDefault();
        }
        formLocale.set(locale);
    }

    public static Locale getFormLocale() {
        if (null == formLocale) {
            return null;
        }
        return (Locale)formLocale.get();
    }

    public static boolean isRTLRequestLocale() {
        Locale loc = LocaleUtils.getRequestLocale();
        return LocaleUtils.isRTLLocale(loc);
    }

    public static boolean isRTLLocale(Locale loc) {
        String language = loc.getLanguage();
        return "ar".equalsIgnoreCase(language) || "iw".equalsIgnoreCase(language) || "he".equalsIgnoreCase(language);
    }

    public static void setAppLocale(Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault();
        }
        appLocale = locale;
    }

    public static Locale getAppLocale() {
        if (null == appLocale) {
            appLocale = Locale.getDefault();
        }
        return appLocale;
    }
}

