/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.utilities;

import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class FormNamespaceSupport {
    private static final String XFDL_IBM_NAMESPACE_PREFIX = "http://www.ibm.com/xmlns/prod/XFDL/";
    private static final String XFDL_PUREEDGE_NAMESPACE_PREFIX = "http://www.PureEdge.com/XFDL/";
    private static final String XFDL71_NAMESPACE = "http://www.ibm.com/xmlns/prod/XFDL/7.1";
    private static final String XFDL75_NAMESPACE = "http://www.ibm.com/xmlns/prod/XFDL/7.5";
    private static final String XFDL76_NAMESPACE = "http://www.ibm.com/xmlns/prod/XFDL/7.6";
    public static final String XFDL_CURRENT_NAMESPACE = "http://www.ibm.com/xmlns/prod/XFDL/7.6";
    public static final String XFORMS_2002_NAMESPACE = "http://www.w3.org/2002/xforms";
    public static final String XFORMS_2003_NAMESPACE = "http://www.w3.org/2003/xforms";
    public static final String XML_SCHEMA_2001_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private Map namespace = new HashMap();

    public static boolean isXFDLNamespace(String uri) {
        char tempChar;
        int prefixLength = 0;
        if (uri.startsWith(XFDL_IBM_NAMESPACE_PREFIX)) {
            prefixLength = XFDL_IBM_NAMESPACE_PREFIX.length();
        } else if (uri.startsWith(XFDL_PUREEDGE_NAMESPACE_PREFIX)) {
            prefixLength = XFDL_PUREEDGE_NAMESPACE_PREFIX.length();
        }
        if (0 == prefixLength || uri.length() != prefixLength + 3) {
            return false;
        }
        return (tempChar = uri.charAt(prefixLength++)) >= '0' && tempChar <= '9' && uri.charAt(prefixLength++) == '.' && (tempChar = uri.charAt(prefixLength)) >= '0' && tempChar <= '9';
    }

    public static boolean isXFormsNamespace(String uri, boolean xmlmodel) {
        if (xmlmodel) {
            return XFORMS_2003_NAMESPACE.equals(uri);
        }
        return XFORMS_2002_NAMESPACE.equals(uri);
    }

    public void addNamespaceEntries(FormNamespaceSupport namespace) {
        Map m1 = this.namespace;
        HashMap m2 = new HashMap(namespace.namespace);
        m2.keySet().removeAll(m1.keySet());
        Iterator it = m2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry result = it.next();
            m1.put(result.getKey(), result.getValue());
        }
    }

    public void clear() {
        this.namespace.clear();
    }

    public boolean containsPrefix(String prefix) {
        if (this.namespace.isEmpty()) {
            return false;
        }
        return this.namespace.containsKey(prefix);
    }

    public boolean containsURI(String uri) {
        if (this.namespace.isEmpty()) {
            return false;
        }
        Iterator it = this.namespace.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry result = it.next();
            if (!uri.equals(result.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean declarePrefix(String prefix, String uri) {
        this.namespace.put(prefix, uri);
        return true;
    }

    public String getNamespaceDescription() {
        Vector keys = new Vector(this.namespace.keySet());
        Collections.sort(keys);
        String result = "";
        Iterator it = ((AbstractList)keys).iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            String uri = (String)this.namespace.get(prefix);
            result = result + this.generateNamespaceDescription(prefix, uri);
        }
        return result;
    }

    public String getNamespaceDescription(String prefix) {
        String uri = (String)this.namespace.get(prefix);
        return this.generateNamespaceDescription(prefix, uri);
    }

    public String getNamespacePrefix(String uri) {
        if (!this.namespace.isEmpty()) {
            Iterator it = this.namespace.entrySet().iterator();
            while (it.hasNext()) {
                String key;
                Map.Entry result = it.next();
                if (!uri.equals(result.getValue()) || "".equals(key = (String)result.getKey())) continue;
                return key;
            }
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if ("null".equals(prefix)) {
            return "";
        }
        if (!this.namespace.isEmpty()) {
            return (String)this.namespace.get(prefix);
        }
        return null;
    }

    public String getXFDLNamespaceURI() {
        if (this.namespace.isEmpty()) {
            return null;
        }
        Iterator it = this.namespace.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String uri = (String)entry.getValue();
            if (!FormNamespaceSupport.isXFDLNamespace(uri)) continue;
            return uri;
        }
        return null;
    }

    public void removeNamespaceEntries(FormNamespaceSupport namespace) {
        Map m1 = this.namespace;
        HashMap m2 = new HashMap(namespace.namespace);
        m1.entrySet().removeAll(m2.entrySet());
    }

    public String toString() {
        return this.getNamespaceDescription();
    }

    private String generateNamespaceDescription(String prefix, String uri) {
        String xmlns = prefix.equals("") ? " xmlns" : " xmlns:";
        uri = null == uri ? "" : uri;
        return xmlns + prefix + "=\"" + uri + "\"";
    }
}

