/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.utilities;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FormLogger {
    private static Logger logger;

    public static Logger getLogger() {
        return logger;
    }

    private static Level getLoggingLevel() {
        Level level = Level.INFO;
        int enablePathsCount = 0;
        String[] enablePaths = new String[7];
        enablePaths[enablePathsCount++] = "c:\\PureEdge.pel";
        enablePaths[enablePathsCount++] = "c:\\wpf.pel";
        enablePaths[enablePathsCount++] = "c:\\debug.pel";
        enablePaths[enablePathsCount++] = "PureEdge.pel";
        enablePaths[enablePathsCount++] = "wpf.pel";
        enablePaths[enablePathsCount++] = "/etc/wpf.pel";
        enablePaths[enablePathsCount++] = "/etc/PureEdge.pel";
        for (int i = 0; i < enablePathsCount; ++i) {
            File file = new File(enablePaths[i]);
            if (!file.exists()) continue;
            level = Level.FINE;
            break;
        }
        return level;
    }

    static {
        FileHandler fileHandler;
        logger = null;
        logger = Logger.getLogger("com.ibm.form.api");
        try {
            fileHandler = new FileHandler("%h/debug%u.log", true);
        }
        catch (IOException ex) {
            fileHandler = null;
        }
        fileHandler.setFormatter(new Formatter(){

            public String format(LogRecord rec) {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss.SSSZ");
                String ts = format.format(new Date(rec.getMillis()));
                String clazz = rec.getSourceClassName();
                String method = rec.getSourceMethodName();
                return ts + " " + rec.getThreadID() + " " + clazz + " " + method + " " + rec.getMessage() + "\n";
            }
        });
        logger.setLevel(FormLogger.getLoggingLevel());
        logger.setUseParentHandlers(false);
        logger.addHandler(fileHandler);
    }
}

