/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.parser.sax;

import com.ibm.form.api.internal.utilities.io.IOManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.InputSource;

public class XFDLParserData {
    private Map hintsMap = new HashMap(0);
    private Map fetchMap = new HashMap(0);
    private int numberOfPasses = 0;
    private String filePath;
    private InputSource inputSource;
    private String encoding = null;

    public XFDLParserData(String filePath) {
        this.filePath = filePath;
        this.inputSource = null;
    }

    public XFDLParserData(InputSource inputSource) {
        this.filePath = null;
        this.inputSource = inputSource;
    }

    public void addEntryToHintMap(String[] nameParts) {
        this.addMapEntries(nameParts, this.hintsMap);
    }

    public void addEntryToFetchMap(String[] nameParts) {
        int length = nameParts.length;
        String[] newParts = new String[length];
        System.arraycopy(nameParts, 0, newParts, 0, length);
        for (int i = 0; i < newParts.length; ++i) {
            if (!newParts[i].startsWith("null:")) continue;
            newParts[i] = newParts[i].substring("null:".length());
        }
        this.addMapEntries(newParts, this.fetchMap);
    }

    public void clearFetchMap() {
        this.fetchMap = new HashMap(0);
    }

    public void clearHintsMap() {
        this.hintsMap = new HashMap(0);
    }

    public void dispose() throws IOException {
        this.hintsMap = new HashMap(0);
        this.fetchMap = new HashMap(0);
        if (null != this.filePath) {
            this.filePath = null;
            if (null != this.inputSource) {
                this.disposeInputSource();
            }
        }
    }

    public Map getCacheMap() {
        return this.hintsMap;
    }

    public Map getCacheMap(Map root, String nodeId) {
        if (null == root) {
            return this.getMap(this.hintsMap, nodeId);
        }
        return this.getMap(root, nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getEncoding() {
        if (null == this.encoding) {
            block15: {
                encoding = new StringBuffer();
                stream = null;
                stream = IOManager.getInputStream("", new FileInputStream(this.filePath), null, encoding, null);
                var6_3 = null;
                ** if (null == stream) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block15;
                    catch (FileNotFoundException e) {
                        var4_13 = null;
                        var6_4 = null;
                        if (null != stream) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        return var4_13;
                    }
                    catch (IOException e) {
                        block17: {
                            try {
                                var4_14 = null;
                                var6_5 = null;
                                if (null == stream) break block17;
                            }
                            catch (Throwable var5_15) {
                                var6_6 = null;
                                if (null != stream) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                }
                                throw var5_15;
                            }
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        return var4_14;
                    }
                }
            }
            this.encoding = encoding.toString();
        }
        return this.encoding;
    }

    public InputSource getInputSource() throws UnsupportedEncodingException, IOException {
        if (null != this.filePath) {
            if (null != this.inputSource) {
                this.disposeInputSource();
            }
            StringBuffer encoding = null == this.encoding ? new StringBuffer() : null;
            this.inputSource = new InputSource(IOManager.getInputStream("", new FileInputStream(this.filePath), null, encoding, null));
            if (null != encoding) {
                this.encoding = encoding.toString();
            }
        }
        return this.inputSource;
    }

    public int getNumberOfPasses() {
        return this.numberOfPasses;
    }

    public void incrementNumberOfPasses() {
        ++this.numberOfPasses;
    }

    public void mergeMaps() {
        this.mergeMaps(this.fetchMap, this.hintsMap);
        this.clearFetchMap();
    }

    private void disposeInputSource() throws IOException {
        InputStream stream = this.inputSource.getByteStream();
        Reader reader = this.inputSource.getCharacterStream();
        this.inputSource = null;
        this.encoding = null;
        if (null != stream) {
            stream.close();
        }
        if (null != reader) {
            reader.close();
        }
    }

    private Map getMap(Map root, String key) {
        if (null == root || null == key) {
            return new HashMap(0);
        }
        Map map = root;
        HashMap newMap = new HashMap();
        if (map.containsKey("**")) {
            Map entry = (Map)map.get(key);
            if ("**".equals(key) && !entry.containsKey("**")) {
                entry.put("**", new HashMap(2));
            }
            newMap.put(key, entry);
        }
        if (map.containsKey("*")) {
            newMap.put("*", map.get("*"));
        }
        if (map.containsKey(key)) {
            newMap.put(key, map.get(key));
        }
        return newMap;
    }

    private void mergeMaps(Map source, Map dest) {
        if (null == source) {
            return;
        }
        if (null == dest) {
            dest = source;
        }
        Iterator it = source.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!dest.containsKey(key)) {
                dest.put(key, source.get(key));
                continue;
            }
            this.mergeMaps((Map)source.get(key), (Map)dest.get(key));
        }
    }

    private void addMapEntries(String[] nameParts, Map map) {
        Map currentMap = map;
        Map previousMap = map;
        for (int i = 0; i < nameParts.length; ++i) {
            String name = nameParts[i];
            currentMap = (Map)previousMap.get(name);
            if (null == currentMap) {
                previousMap.put(name, new HashMap(4));
                currentMap = (Map)previousMap.get(name);
            }
            previousMap = currentMap;
        }
    }
}

