/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.parser.sax;

import com.ibm.form.api.internal.action.Action;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.parser.sax.SAXHandler;
import com.ibm.form.api.internal.parser.sax.XFDLParserData;
import com.ibm.form.api.internal.utilities.FormLogger;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XFDLParser
extends DefaultHandler
implements LexicalHandler {
    public static final int PARSE_NOT_IN_DOCUMENT = -1;
    public static final int XFDL_LEVEL = 0;
    public static final int PAGE_LEVEL = 1;
    public static final int ITEM_LEVEL = 2;
    public static final int OPTION_LEVEL = 3;
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final boolean DEFAULT_NAMESPACES = true;
    private static final boolean DEFAULT_VALIDATION = false;
    private static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    private static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    private static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    private static SAXParserFactory parserFactory = null;
    private SAXParser saxParser;
    private XFDLParserData parserData;
    private Stack context = new Stack();
    private SAXHandler currentContext = null;
    private int currentLevel = -1;

    public XFDLParser(String filePath) throws ParserConfigurationException, SAXException {
        this.createParser();
        this.parserData = new XFDLParserData(filePath);
    }

    public XFDLParser(InputSource inputSource) throws ParserConfigurationException, SAXException {
        this.createParser();
        this.parserData = new XFDLParserData(inputSource);
    }

    public void dispose() throws IOException {
        this.saxParser = null;
        this.context = null;
        this.currentContext = null;
        if (null != this.parserData) {
            this.parserData.dispose();
            this.parserData = null;
        }
    }

    public XFDLParserData getParserData() {
        return this.parserData;
    }

    public void parse(SAXHandler firstHandler) throws ParserConfigurationException, SAXException, IOException {
        Logger logger = FormLogger.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Parser invoked (" + (this.parserData.getNumberOfPasses() + 1) + ")");
        }
        InputSource inputSource = this.parserData.getInputSource();
        this.pushContext(firstHandler);
        this.saxParser.parse(inputSource, (DefaultHandler)this);
        if (1 != this.context.size()) {
            throw new IllegalStateException();
        }
        this.context.pop();
        this.parserData.incrementNumberOfPasses();
        this.parserData.clearFetchMap();
        this.parserData.clearHintsMap();
    }

    public void parse(SAXHandler handler, FormNode node, List actions) throws ParserConfigurationException, SAXException, IOException {
        if (this.preParse(node, actions)) {
            this.parse(handler);
        }
    }

    public boolean process(FormNode node, List actions, boolean overrideAutoCreate) throws ParserConfigurationException, SAXException, IOException {
        if (null == actions) {
            return false;
        }
        if (0 != this.parserData.getNumberOfPasses()) {
            return !this.postParse(node, actions, overrideAutoCreate);
        }
        return false;
    }

    public void pushContext(SAXHandler parseContext) {
        this.context.push(parseContext);
        this.currentContext = parseContext;
    }

    public void popContext() throws EmptyStackException {
        this.currentContext.dispose();
        this.context.pop();
        this.currentContext = (SAXHandler)this.context.peek();
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return this.currentContext.resolveEntity(publicId, systemId);
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.currentContext.notationDecl(name, publicId, systemId);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.currentContext.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    public void setDocumentLocator(Locator locator) {
        this.currentContext.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.currentContext.startDocument();
        ++this.currentLevel;
    }

    public void endDocument() throws SAXException {
        --this.currentLevel;
        this.currentContext.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.currentContext.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.currentContext.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentContext.startElement(uri, localName, qName, attributes);
        ++this.currentLevel;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.currentLevel;
        this.currentContext.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentContext.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.currentContext.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.currentContext.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.currentContext.skippedEntity(name);
    }

    public void warning(SAXParseException e) throws SAXException {
        this.currentContext.warning(e);
    }

    public void error(SAXParseException e) throws SAXException {
        this.currentContext.error(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.currentContext.fatalError(e);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.currentContext.startDTD(name, publicId, systemId);
        ++this.currentLevel;
    }

    public void endDTD() throws SAXException {
        --this.currentLevel;
        this.currentContext.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this.currentContext.startEntity(name);
        ++this.currentLevel;
    }

    public void endEntity(String name) throws SAXException {
        --this.currentLevel;
        this.currentContext.endEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.currentContext.startCDATA();
        ++this.currentLevel;
    }

    public void endCDATA() throws SAXException {
        --this.currentLevel;
        this.currentContext.endCDATA();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.currentContext.comment(ch, start, length);
    }

    private void createParser() throws ParserConfigurationException, SAXException {
        if (null == parserFactory) {
            boolean defaultNamespaces = true;
            boolean validation = false;
            boolean schemaValidation = false;
            boolean schemaFullChecking = false;
            parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
            parserFactory.setFeature(NAMESPACES_FEATURE_ID, defaultNamespaces);
            try {
                parserFactory.setFeature(VALIDATION_FEATURE_ID, validation);
            }
            catch (SAXException ex) {
                // empty catch block
            }
            try {
                parserFactory.setFeature(SCHEMA_VALIDATION_FEATURE_ID, schemaValidation);
            }
            catch (SAXException ex) {
                // empty catch block
            }
            try {
                parserFactory.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, schemaFullChecking);
            }
            catch (SAXException ex) {
                // empty catch block
            }
        }
        this.saxParser = parserFactory.newSAXParser();
        this.saxParser.setProperty(LEXICAL_HANDLER_PROPERTY_ID, this);
    }

    private boolean postParse(FormNode node, List actions, boolean overrideAutoCreate) throws ParserConfigurationException, SAXException, IOException {
        boolean result = false;
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            Action action = (Action)it.next();
            if (action.postParse(node, overrideAutoCreate)) continue;
            result = true;
            node.getParser().getParserData().addEntryToFetchMap(action.getParseMapEntry());
        }
        return result;
    }

    private boolean preParse(FormNode node, List actions) {
        boolean result = true;
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            Action action = (Action)it.next();
            if (!action.preParse(node)) {
                result = false;
            }
            node.getParser().getParserData().addEntryToFetchMap(action.getParseMapEntry());
        }
        this.parserData.mergeMaps();
        return result;
    }
}

