/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.parser.sax;

import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.GlobalPage;
import com.ibm.form.api.internal.model.Page;
import com.ibm.form.api.internal.model.XFDL;
import com.ibm.form.api.internal.parser.sax.FormHandler;
import com.ibm.form.api.internal.parser.sax.GlobalPageHandler;
import com.ibm.form.api.internal.parser.sax.IgnoreHandler;
import com.ibm.form.api.internal.parser.sax.PageHandler;
import com.ibm.form.api.internal.parser.sax.SAXHandler;
import com.ibm.form.api.internal.parser.sax.XFDLParserData;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class XFDLHandler
extends SAXHandler {
    private XFDL xfdl;
    private int numberOfPages = 0;

    XFDLHandler(FormHandler parent, String uri, String qName, Attributes attributes) {
        super(parent);
        if (0 != this.parser.getParserData().getNumberOfPasses()) {
            throw new IllegalStateException();
        }
        this.xfdl = new XFDL(uri, qName, new AttributesImpl(attributes), parent.namespace, this.parser);
    }

    XFDLHandler(FormHandler parent, XFDL xfdl) {
        super(parent);
        if (0 == this.parser.getParserData().getNumberOfPasses()) {
            throw new IllegalStateException();
        }
        this.xfdl = xfdl;
        this.xfdl.setParseMaps(this.parser.getParserData().getCacheMap());
    }

    public void dispose() {
        this.xfdl = null;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (null == this.namespace) {
            this.namespace = new FormNamespaceSupport();
        }
        this.namespace.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.numberOfPages;
        XFDLParserData parserData = this.parser.getParserData();
        if (0 != parserData.getNumberOfPasses()) {
            this.processPage(uri, qName, FormNode.getAttributeValue(attributes, "sid"), attributes, "globalpage".equals(localName));
            return;
        }
        if (1 == this.numberOfPages) {
            String sid = GlobalPage.isGlobalPage(uri, localName, attributes);
            if (null == sid) {
                throw new SAXException(FormNode.errorCode);
            }
            this.processPage(uri, qName, sid, attributes, true);
            return;
        }
        String sid = Page.isPage(uri, localName, attributes);
        if (null == sid) {
            sid = GlobalPage.isGlobalPage(uri, localName, attributes);
            if (null == sid) {
                throw new SAXException(FormNode.errorCode);
            }
            this.processPage(uri, qName, sid, attributes, true);
        } else {
            this.processPage(uri, qName, sid, attributes, false);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        XFDLParserData parserData = this.parser.getParserData();
        if (0 == parserData.getNumberOfPasses() && null == XFDL.isXFDLElement(uri, localName)) {
            throw new SAXException(FormNode.errorCode);
        }
        this.xfdl.minimizeMemoryFootPrint();
        this.parser.popContext();
    }

    FormNode getNode() {
        return this.xfdl;
    }

    private void processPage(String uri, String qName, String pageSid, Attributes attributes, boolean isGlobal) {
        if (this.xfdl.shouldParseChild(pageSid)) {
            PageHandler newHandler = isGlobal ? new GlobalPageHandler(this, uri, qName, attributes) : new PageHandler(this, uri, qName, pageSid, attributes);
            if (newHandler.ignoreChild()) {
                ((SAXHandler)newHandler).dispose();
                this.parser.pushContext(new IgnoreHandler(this));
            } else {
                this.parser.pushContext(newHandler);
            }
        } else {
            this.parser.pushContext(new IgnoreHandler(this));
        }
        this.namespace = null;
    }
}

