/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.parser.sax;

import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.model.XFDL;
import com.ibm.form.api.internal.parser.sax.IgnoreHandler;
import com.ibm.form.api.internal.parser.sax.SAXHandler;
import com.ibm.form.api.internal.parser.sax.XFDLParser;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WriteHandler
extends SAXHandler {
    private char[] chars;
    private int charsLength;
    private StringBuffer charBuffer;
    private OptionCount optionCount = new OptionCount(5);
    private OutputStreamWriter out;
    private XFDL xfdl;
    private Stack nodes = new Stack();
    private OutputNode currentElement;
    private boolean echo = false;
    private int numberIgnored = 0;
    private boolean suppressCharacters = true;

    public static StringBuffer canonicalizeAttribute(String value) {
        StringBuffer buffer = new StringBuffer(value.length() + 16);
        int index = 0;
        int end = value.length();
        boolean formatComputes = true;
        block8: while (index < end) {
            char ch = value.charAt(index);
            switch (ch) {
                case '<': {
                    buffer.append("&lt;");
                    ++index;
                    continue block8;
                }
                case '\"': {
                    buffer.append("&quot;");
                    ++index;
                    continue block8;
                }
                case '\n': {
                    buffer.append("&#xA;");
                    if (++index >= end || !formatComputes || ' ' != value.charAt(index)) continue block8;
                    buffer.append("\n");
                    ++index;
                    continue block8;
                }
                case '\t': {
                    buffer.append("&#9;");
                    ++index;
                    continue block8;
                }
                case '\r': {
                    buffer.append("&#xD;");
                    ++index;
                    continue block8;
                }
                case '&': {
                    StringBuffer charValue = new StringBuffer();
                    int consumed = WriteHandler.isCharRef(charValue, value, index);
                    if (0 == consumed) {
                        buffer.append("&amp;");
                        ++index;
                        continue block8;
                    }
                    buffer.append(charValue.toString());
                    index += consumed;
                    continue block8;
                }
            }
            buffer.append(ch);
            ++index;
        }
        return buffer;
    }

    public static StringBuffer canonicalizeValue(String value) {
        StringBuffer buffer = new StringBuffer(value.length() + 16);
        int index = 0;
        int end = value.length();
        block7: while (index < end) {
            char ch = value.charAt(index);
            switch (ch) {
                case '<': {
                    buffer.append("&lt;");
                    ++index;
                    continue block7;
                }
                case '>': {
                    buffer.append("&gt;");
                    ++index;
                    continue block7;
                }
                case '\r': {
                    buffer.append("&#xD;");
                    ++index;
                    continue block7;
                }
                case '\n': {
                    buffer.append(ch);
                    ++index;
                    continue block7;
                }
                case '&': {
                    StringBuffer charValue = new StringBuffer();
                    int consumed = WriteHandler.isCharRef(charValue, value, index);
                    if (0 == consumed) {
                        buffer.append("&amp;");
                        ++index;
                        continue block7;
                    }
                    buffer.append(charValue.toString());
                    index += consumed;
                    continue block7;
                }
            }
            buffer.append(ch);
            ++index;
        }
        return buffer;
    }

    static int isCharRef(StringBuffer result, String string, int offset) {
        char[] charArray = string.substring(offset).toCharArray();
        int res = WriteHandler.isCharRef(result, charArray, 0, charArray.length);
        if (-1 == res) {
            return 0;
        }
        return res;
    }

    static int isCharRef(StringBuffer result, char[] ch, int offset, int length) {
        if ('&' != ch[offset]) {
            return 0;
        }
        int startOffset = offset++;
        if (offset >= length) {
            return -1;
        }
        if ('#' != ch[offset]) {
            return 0;
        }
        if (++offset >= length) {
            return -1;
        }
        if ('x' == ch[offset]) {
            if (++offset >= length) {
                return -1;
            }
            result.append("&#x");
            while (-1 != Character.digit(ch[offset], 16)) {
                result.append(ch[offset]);
                if (++offset < length) continue;
                return -1;
            }
        } else {
            result.append("&#");
            while (Character.isDigit(ch[offset])) {
                result.append(ch[offset]);
                if (++offset < length) continue;
                return -1;
            }
        }
        if (';' == ch[offset]) {
            result.append(";");
            return ++offset - startOffset;
        }
        return 0;
    }

    public WriteHandler(OutputStream outputStream, XFDL xfdl) throws IllegalArgumentException, UnsupportedEncodingException {
        super((XFDLParser)null);
        if (null == outputStream) {
            throw new IllegalArgumentException(Messages.ParameterNull.toStringAsRequest());
        }
        if (null == xfdl) {
            throw new IllegalArgumentException(Messages.ParameterNull.toStringAsRequest());
        }
        this.namespace = new FormNamespaceSupport();
        this.out = new OutputStreamWriter(outputStream, "UTF-8");
        this.xfdl = xfdl;
    }

    public void dispose() {
        this.chars = null;
        this.charBuffer = null;
        this.out = null;
        this.xfdl = null;
        this.nodes = null;
        this.namespace = null;
        super.dispose();
    }

    public void setParser(XFDLParser parser) {
        this.parser = parser;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (null == this.chars) {
            this.chars = ch;
        } else {
            char[] newChars = new char[length + this.charsLength + 16];
            System.arraycopy(this.chars, 0, newChars, 0, this.charsLength);
            System.arraycopy(ch, start, newChars, this.charsLength, length);
            this.chars = newChars;
            start = 0;
            length += this.charsLength;
        }
        if (null == this.charBuffer) {
            this.charBuffer = new StringBuffer(this.chars.length + 32);
        }
        this.charBuffer.ensureCapacity(this.charBuffer.length() + this.chars.length + 32);
        int i = start;
        int end = start + length;
        block10: while (i < end) {
            switch (this.chars[i]) {
                case '>': {
                    this.charBuffer.append("&gt;");
                    ++i;
                    continue block10;
                }
                case '<': {
                    this.charBuffer.append("&lt;");
                    ++i;
                    continue block10;
                }
                case '\r': {
                    this.charBuffer.append("&#xD;");
                    ++i;
                    continue block10;
                }
                case '&': {
                    StringBuffer buf = new StringBuffer();
                    int consumed = WriteHandler.isCharRef(buf, this.chars, i, end);
                    switch (consumed) {
                        case -1: {
                            this.charsLength = end - i;
                            char[] newChars = new char[this.charsLength + 16];
                            System.arraycopy(this.chars, i, newChars, 0, this.charsLength);
                            this.chars = newChars;
                            if (!this.suppressCharacters) {
                                this.output(this.charBuffer.toString());
                                this.charBuffer = null;
                            }
                            return;
                        }
                        case 0: {
                            this.charBuffer.append("&amp;");
                            ++i;
                            continue block10;
                        }
                    }
                    this.charBuffer.append(buf);
                    i += consumed;
                    continue block10;
                }
            }
            this.charBuffer.append(this.chars[i]);
            ++i;
        }
        if (!this.suppressCharacters) {
            this.output(this.charBuffer.toString());
            this.charBuffer = null;
        }
        this.chars = null;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.outputBuffers();
        this.output("<!--" + new String(ch, start, length) + "-->");
        if (0 == this.parser.getCurrentLevel()) {
            this.output("\n");
        }
    }

    public void startDocument() throws SAXException {
        this.output("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    public void endDocument() throws SAXException {
        try {
            this.outputBuffers();
            this.out.flush();
        }
        catch (IOException ex) {
            throw new SAXException(ex.getMessage(), ex);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.echo) {
            ++this.numberIgnored;
            this.outputStartElement(qName, attributes);
            this.clearNamespace();
            return;
        }
        int level = this.parser.getCurrentLevel();
        block0 : switch (level) {
            case 0: {
                this.optionCount.reset(level + 1);
                OutputNode node = new OutputNode(level, this.xfdl);
                this.pushContext(node);
                this.outputBuffers();
                this.outputStartElement(qName, attributes);
                break;
            }
            case 1: 
            case 2: {
                this.optionCount.reset(level + 1);
                String sid = FormNode.getAttributeValue(attributes, "sid");
                FormNode formNode = this.currentElement.getChild(sid);
                if (null == formNode) {
                    this.echoElement(qName, attributes, level);
                    break;
                }
                OutputNode node = new OutputNode(level, formNode);
                this.pushContext(node);
                this.processStartElement(qName, attributes, level);
                break;
            }
            case 3: {
                this.optionCount.reset(level + 1);
                this.optionCount.add(level);
                String optionName = this.getOptionSearchName(uri, qName);
                Option option = (Option)this.currentElement.getChild(optionName);
                if (null == option) {
                    this.echoElement(qName, attributes, level);
                    break;
                }
                OutputNode node = new OutputNode(level, option);
                this.pushContext(node);
                this.processStartElement(qName, attributes, level);
                break;
            }
            default: {
                this.optionCount.reset(level + 1);
                this.optionCount.add(level);
                while (true) {
                    OutputNode node;
                    Option option;
                    if (null == (option = this.currentElement.getNextChild())) {
                        this.echoElement(qName, attributes, level);
                        break block0;
                    }
                    if (4 != option.status) {
                        node = new OutputNode(level, option);
                        this.pushContext(node);
                        this.processStartElement(qName, attributes, level);
                        break block0;
                    }
                    node = new OutputNode(level, option);
                    this.pushContext(node);
                    this.processStartElement(qName, attributes, level);
                }
            }
        }
        this.clearNamespace();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.echo) {
            this.outputEndElement(qName);
            if (0 == this.numberIgnored) {
                this.echo = false;
                this.disableCharacterOutput();
            } else {
                --this.numberIgnored;
            }
            return;
        }
        int level = this.parser.getCurrentLevel();
        switch (level) {
            case 0: {
                this.outputBuffers();
                this.outputEndElement(qName);
                break;
            }
            case 1: 
            case 2: {
                this.outputBuffers();
                this.outputEndElement(qName);
                this.popContext();
                break;
            }
            default: {
                if (((Option)this.currentElement.node).hasValueChanged()) {
                    this.clearBuffers();
                    String value = ((Option)this.currentElement.node).getLiteral();
                    if (null != value) {
                        this.output(WriteHandler.canonicalizeValue(value).toString());
                    }
                } else {
                    this.outputNewNode();
                    this.outputBuffers();
                    this.disableCharacterOutput();
                }
                this.outputEndElement(qName);
                this.popContext();
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespace.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    FormNode getNode() {
        return null;
    }

    private void clearBuffers() {
        this.charBuffer = null;
        this.chars = null;
    }

    private void clearNamespace() {
        this.namespace.clear();
    }

    private void disableCharacterOutput() {
        this.suppressCharacters = true;
    }

    private void echoElement(String qName, Attributes attributes, int level) throws SAXException {
        if ("".equals(this.optionCount.getIndent(level))) {
            String remainingChars = this.getBuffers();
            int lastReturn = remainingChars.lastIndexOf(10);
            if (-1 != lastReturn && remainingChars.length() != lastReturn) {
                String indent = remainingChars.substring(lastReturn + 1);
                this.optionCount.setIndent(level, indent);
            }
            this.output(remainingChars);
        } else {
            this.outputBuffers();
        }
        this.enableCharacterOutput();
        this.echo = true;
        this.numberIgnored = 0;
        this.outputStartElement(qName, attributes);
    }

    private void enableCharacterOutput() {
        this.suppressCharacters = false;
    }

    private StringBuffer finishCharacters() {
        if (null == this.chars) {
            return null;
        }
        StringBuffer value = new StringBuffer(this.charsLength + 16);
        int i = 0;
        block6: while (i < this.charsLength) {
            switch (this.chars[i]) {
                case '>': {
                    value.append("&gt;");
                    ++i;
                    continue block6;
                }
                case '<': {
                    value.append("&lt;");
                    ++i;
                    continue block6;
                }
                case '\r': {
                    value.append("&#xD;");
                    ++i;
                    continue block6;
                }
                case '&': {
                    value.append("&amp;");
                    ++i;
                    continue block6;
                }
            }
            value.append(this.chars[i]);
            ++i;
        }
        this.chars = null;
        return value;
    }

    private String getBuffers() {
        StringBuffer finish;
        String result = "";
        if (null != this.charBuffer) {
            result = result + this.charBuffer.toString();
            this.charBuffer = null;
        }
        if (null != (finish = this.finishCharacters())) {
            result = result + finish.toString();
        }
        return result;
    }

    private String getOptionSearchName(String uri, String qName) {
        String[] name = qName.split(":");
        return uri + "#" + name[name.length - 1];
    }

    private void output(String string) throws SAXException {
        try {
            this.out.write(string.toCharArray(), 0, string.length());
        }
        catch (IOException ex) {
            throw new SAXException(ex.getMessage(), ex);
        }
    }

    private void outputBuffers() throws SAXException {
        this.output(this.getBuffers());
    }

    private void outputEndElement(String qName) throws SAXException {
        this.output("</" + qName + ">");
        if (qName.equals("XFDL")) {
            this.charBuffer = new StringBuffer("\n");
        }
    }

    private void outputNewNode() throws SAXException {
        String whiteSpace = null;
        if (this.currentElement.newChildExists()) {
            whiteSpace = this.getBuffers();
        }
        while (this.currentElement.newChildExists()) {
            this.outputNode(this.currentElement.getNextChild());
        }
        if (null != whiteSpace) {
            if ("".equals(whiteSpace)) {
                this.output("\n" + this.optionCount.indent[this.currentElement.level]);
            }
            this.output(whiteSpace);
        }
    }

    private void outputNode(FormNode node) throws SAXException {
        this.output("\n" + node.generateXML(this.currentElement.level + 1, this.optionCount.indent, new HashSet(0)));
    }

    private void outputStartElement(String qName, Attributes attributes) throws SAXException {
        this.output("<" + qName);
        if (this.echo) {
            this.output(this.namespace.getNamespaceDescription());
            if (null != attributes) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    StringBuffer value = WriteHandler.canonicalizeAttribute(attributes.getValue(i));
                    this.output(" " + attributes.getQName(i) + "=\"" + value.toString() + "\"");
                }
            }
        } else {
            this.output(this.currentElement.node.getNamespaceDescription(new HashSet()));
            this.output(this.currentElement.node.getAttributeDescription());
        }
        this.output(">");
    }

    private void popContext() throws EmptyStackException {
        this.nodes.pop();
        this.currentElement = (OutputNode)this.nodes.peek();
    }

    private void processStartElement(String qName, Attributes attributes, int level) throws SAXException {
        switch (this.currentElement.node.status) {
            case 1: {
                this.echoElement(qName, attributes, level);
                this.popContext();
                break;
            }
            case 2: {
                if ("".equals(this.optionCount.getIndent(level))) {
                    String remainingChars = this.getBuffers();
                    int lastReturn = remainingChars.lastIndexOf(10);
                    if (-1 != lastReturn && remainingChars.length() != lastReturn) {
                        String indent = remainingChars.substring(lastReturn + 1);
                        this.optionCount.setIndent(level, indent);
                    }
                    this.output(remainingChars);
                } else {
                    this.outputBuffers();
                }
                this.outputStartElement(qName, attributes);
                if (!(this.currentElement.node instanceof Option) || !((Option)this.currentElement.node).hasValueChanged()) break;
                String value = ((Option)this.currentElement.node).getLiteral();
                if (null != value) {
                    this.output(WriteHandler.canonicalizeValue(value).toString());
                }
                this.outputEndElement(qName);
                this.parser.pushContext(new IgnoreHandler(this));
                this.popContext();
                break;
            }
            case 8: {
                --this.currentElement.level;
                this.outputNode(this.currentElement.node);
                this.parser.pushContext(new IgnoreHandler(this));
                this.popContext();
                this.clearBuffers();
                break;
            }
            case 4: {
                String whiteSpace = this.getBuffers();
                --this.currentElement.level;
                this.outputNode(this.currentElement.node);
                this.popContext();
                this.clearBuffers();
                this.output(whiteSpace);
                break;
            }
            case 16: {
                this.parser.pushContext(new IgnoreHandler(this));
                this.clearBuffers();
                this.popContext();
                break;
            }
            default: {
                throw new SAXException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(this.currentElement.node.status).toString()));
            }
        }
    }

    private void pushContext(OutputNode element) {
        this.nodes.push(element);
        this.currentElement = element;
    }

    class OptionCount {
        static final int INITIAL_VALUE = -1;
        static final int GROW_SIZE = 4;
        int[] count;
        String[] indent;

        OptionCount(int size) {
            this.count = new int[size];
            this.indent = new String[size];
            for (int i = 0; i < size; ++i) {
                this.count[i] = -1;
                this.indent[i] = "";
            }
        }

        public void add(int level) {
            int n = level;
            this.count[n] = this.count[n] + 1;
        }

        public int getCount(int level) {
            return this.count[level];
        }

        public String getIndent(int level) {
            return this.indent[level];
        }

        public void reset(int level) {
            if (level >= this.count.length) {
                this.expand(level);
            }
            this.count[level] = -1;
        }

        public void setIndent(int level, String value) {
            this.indent[level] = value;
        }

        private void expand(int level) {
            int oldLength = this.count.length;
            int newLength = level - oldLength > 4 ? level + 4 : oldLength + 4;
            int[] newCount = new int[newLength];
            String[] newIndent = new String[newLength];
            System.arraycopy(this.count, 0, newCount, 0, oldLength);
            System.arraycopy(this.indent, 0, newIndent, 0, oldLength);
            for (int i = oldLength; i < newCount.length; ++i) {
                newCount[i] = -1;
                newIndent[i] = "";
            }
            this.count = newCount;
            this.indent = newIndent;
        }
    }

    class OutputNode {
        int level;
        FormNode node;
        private List children;
        private boolean ignoreChildren = false;

        OutputNode(int level, FormNode node) {
            this.level = level;
            this.node = node;
            if (16 != node.status) {
                List<FormNode> list = Arrays.asList(node.getAllChildren());
                this.children = new ArrayList<FormNode>(list);
                this.ignoreChildren = node instanceof Option ? ((Option)node).hasValueChanged() : false;
            }
        }

        public String toString() {
            return this.node.getReference(null);
        }

        FormNode getChild(String name) {
            FormNode child = this.node.getChild(name);
            this.children.remove(child);
            return child;
        }

        Option getNextChild() {
            if (this.children.isEmpty()) {
                return null;
            }
            return (Option)this.children.remove(0);
        }

        boolean getIgnoreChildren() {
            return this.ignoreChildren;
        }

        boolean newChildExists() {
            if (!this.children.isEmpty()) {
                Option option = (Option)this.children.get(0);
                if (1 == this.children.size()) {
                    return 4 == option.status || 8 == option.status;
                }
                return 4 == option.status;
            }
            return false;
        }
    }
}

