/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.parser.sax;

import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.GlobalItem;
import com.ibm.form.api.internal.model.Item;
import com.ibm.form.api.internal.model.Page;
import com.ibm.form.api.internal.model.XFDL;
import com.ibm.form.api.internal.parser.sax.GlobalItemHandler;
import com.ibm.form.api.internal.parser.sax.IgnoreHandler;
import com.ibm.form.api.internal.parser.sax.ItemHandler;
import com.ibm.form.api.internal.parser.sax.SAXHandler;
import com.ibm.form.api.internal.parser.sax.XFDLHandler;
import com.ibm.form.api.internal.parser.sax.XFDLParserData;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class PageHandler
extends SAXHandler {
    Page page;
    boolean createdNewPage;
    int numberOfItems = 0;

    PageHandler(XFDLHandler parent, String uri, String qName, String sid, Attributes attributes) {
        super(parent);
        this.page = (Page)parent.getNode().getChild(sid);
        boolean bl = this.createdNewPage = null == this.page;
        if (this.createdNewPage) {
            this.page = new Page((XFDL)parent.getNode(), uri, qName, sid, (Attributes)new AttributesImpl(attributes), parent.namespace);
        } else if (16 != this.page.status) {
            this.page.setParseMaps(this.page.parent.getParseMaps(sid));
        }
    }

    PageHandler(XFDLHandler parent) {
        super(parent);
    }

    public void dispose() {
        this.page = null;
        super.dispose();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (null == this.namespace) {
            this.namespace = new FormNamespaceSupport();
        }
        this.namespace.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.numberOfItems;
        XFDLParserData parserData = this.parser.getParserData();
        if (0 != parserData.getNumberOfPasses()) {
            this.processItem(uri, qName, FormNode.getAttributeValue(attributes, "sid"), attributes, "global".equals(localName));
            return;
        }
        if (1 == this.numberOfItems) {
            String sid = GlobalItem.isGlobalItem(uri, localName, attributes);
            if (null == sid) {
                throw new SAXException(FormNode.errorCode);
            }
            this.processItem(uri, qName, sid, attributes, true);
            return;
        }
        String sid = Item.isItem(uri, attributes);
        if (sid == null) {
            String errorCode = FormNode.errorCode;
            sid = GlobalItem.isGlobalItem(uri, localName, attributes);
            if (null == sid) {
                throw new SAXException(errorCode);
            }
            this.processItem(uri, qName, sid, attributes, true);
        } else {
            this.processItem(uri, qName, sid, attributes, false);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.createdNewPage) {
            this.page.add(false);
        }
        this.page.minimizeMemoryFootPrint();
        this.parser.popContext();
    }

    FormNode getNode() {
        return this.page;
    }

    void processItem(String uri, String qName, String itemSid, Attributes attributes, boolean isGlobal) {
        if (this.page.shouldParseChild(itemSid)) {
            ItemHandler newHandler = isGlobal ? new GlobalItemHandler(this, uri, qName, attributes) : new ItemHandler(this, uri, qName, itemSid, attributes);
            if (newHandler.ignoreChild()) {
                ((SAXHandler)newHandler).dispose();
                this.parser.pushContext(new IgnoreHandler(this));
            } else {
                this.parser.pushContext(newHandler);
            }
        } else {
            this.parser.pushContext(new IgnoreHandler(this));
        }
        this.namespace = null;
    }
}

