/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.parser.sax;

import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.parser.sax.ArrayOptionHandler;
import com.ibm.form.api.internal.parser.sax.IgnoreHandler;
import com.ibm.form.api.internal.parser.sax.InstanceOptionHandler;
import com.ibm.form.api.internal.parser.sax.ItemHandler;
import com.ibm.form.api.internal.parser.sax.SAXHandler;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class OptionHandler
extends SAXHandler {
    Option option;
    boolean createdNewOption;
    int numberArrayOptions = 0;
    boolean modelOption;

    OptionHandler(ItemHandler parent, String uri, String qName, Attributes attributes) {
        super(parent);
        this.option = this.getOption(parent, uri, qName);
        this.createdNewOption = null == this.option;
        this.modelOption = false;
        if (this.createdNewOption) {
            this.option = new Option(parent.getNode(), uri, qName, new AttributesImpl(attributes), parent.namespace);
        } else if (16 != this.option.status) {
            this.option.setParseMaps(this.option.parent.getParseMaps(qName));
        }
    }

    OptionHandler(OptionHandler parent) {
        super(parent);
    }

    public void dispose() {
        this.option = null;
        super.dispose();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.createdNewOption) {
            this.option.value = null == this.option.value ? new String(ch, start, length) : this.option.value + new String(ch, start, length);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (null == this.namespace) {
            this.namespace = new FormNamespaceSupport();
        }
        this.namespace.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.processArrayOption(uri, qName, attributes, false);
        this.namespace = null;
        ++this.numberArrayOptions;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.createdNewOption) {
            this.option.add(false);
        }
        this.option.minimizeMemoryFootPrint();
        this.parser.popContext();
    }

    FormNode getNode() {
        return this.option;
    }

    Option getOption(SAXHandler parent, String uri, String qName) {
        String[] name = qName.split(":");
        String searchName = uri + "#" + name[name.length - 1];
        return (Option)parent.getNode().getChild(searchName);
    }

    void processArrayOption(String uri, String qName, Attributes attributes, boolean modelOption) {
        if (this.option.shouldParseChild(qName, uri, this.namespace, this.numberArrayOptions)) {
            ArrayOptionHandler newHandler = modelOption ? new InstanceOptionHandler(this, uri, qName, attributes) : new ArrayOptionHandler(this, uri, qName, attributes);
            if (newHandler.ignoreChild()) {
                ((SAXHandler)newHandler).dispose();
                this.parser.pushContext(new IgnoreHandler(this));
            } else {
                this.parser.pushContext(newHandler);
            }
        } else {
            if (this.option.getChildCount() < this.numberArrayOptions + 1) {
                this.option.addChild(null, false);
            }
            this.parser.pushContext(new IgnoreHandler(this));
        }
    }
}

