/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.parser.sax;

import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.GlobalItem;
import com.ibm.form.api.internal.model.Item;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.model.Page;
import com.ibm.form.api.internal.parser.sax.IgnoreHandler;
import com.ibm.form.api.internal.parser.sax.ItemHandler;
import com.ibm.form.api.internal.parser.sax.PageHandler;
import com.ibm.form.api.internal.parser.sax.SAXHandler;
import com.ibm.form.api.internal.parser.sax.XFormsModelsHandler;
import com.ibm.form.api.internal.parser.sax.XMLModelHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class GlobalItemHandler
extends ItemHandler {
    private boolean xformsmodelsFound = false;
    private boolean xmlmodelFound = false;

    GlobalItemHandler(PageHandler parent, String uri, String qName, Attributes attributes) {
        super(parent);
        this.item = (Item)parent.getNode().getChild("global");
        boolean bl = this.createdNewItem = null == this.item;
        if (this.createdNewItem) {
            this.item = new GlobalItem((Page)parent.getNode(), uri, qName, new AttributesImpl(attributes), parent.namespace);
        } else if (16 != this.item.status) {
            this.item.setParseMaps(this.item.parent.getParseMaps("global"));
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.numberOfOptions;
        String uriQName = uri + "#" + localName;
        int optionType = null == this.item.getChild(uriQName) ? Option.isOption(this.item, uri, localName) : Option.getOptionType(localName);
        switch (optionType) {
            case 1: {
                this.processOption(uri, qName, attributes);
                break;
            }
            case 4: {
                this.processXFormsModel(uri, qName, attributes);
                break;
            }
            case 2: {
                this.processXMLModel(uri, qName, attributes);
                break;
            }
            default: {
                throw new SAXException(FormNode.errorCode);
            }
        }
    }

    void processXFormsModel(String uri, String qName, Attributes attributes) {
        if (this.xmlmodelFound) {
            throw new IllegalStateException();
        }
        this.xformsmodelsFound = true;
        if (this.item.shouldParseChild(qName, uri, this.namespace)) {
            XFormsModelsHandler newHandler = new XFormsModelsHandler(this, uri, qName, attributes);
            if (newHandler.ignoreChild()) {
                ((SAXHandler)newHandler).dispose();
                this.parser.pushContext(new IgnoreHandler(this));
            } else {
                this.parser.pushContext(newHandler);
            }
        } else {
            this.parser.pushContext(new IgnoreHandler(this));
        }
        this.namespace = null;
    }

    void processXMLModel(String uri, String qName, Attributes attributes) {
        if (this.xformsmodelsFound) {
            throw new IllegalStateException();
        }
        this.xmlmodelFound = true;
        if (this.item.shouldParseChild(qName, uri, this.namespace)) {
            XMLModelHandler newHandler = new XMLModelHandler(this, uri, qName, attributes);
            if (newHandler.ignoreChild()) {
                ((SAXHandler)newHandler).dispose();
                this.parser.pushContext(new IgnoreHandler(this));
            } else {
                this.parser.pushContext(newHandler);
            }
        } else {
            this.parser.pushContext(new IgnoreHandler(this));
        }
        this.namespace = null;
    }
}

