/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.form.api.internal.parser.sax;

import com.ibm.form.api.internal.model.ArrayOption;
import com.ibm.form.api.internal.model.FormNode;
import com.ibm.form.api.internal.model.Option;
import com.ibm.form.api.internal.parser.sax.SAXHandler;
import com.ibm.form.api.internal.parser.sax.XFDLParser;
import com.ibm.form.api.internal.utilities.FormNamespaceSupport;
import com.ibm.form.api.internal.utilities.Messages;
import com.ibm.form.api.internal.utilities.i18n.LocalizedStringFormat;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EncloseHandler
extends SAXHandler {
    private ArrayOption option;
    private int updateMode;
    private int index;

    public EncloseHandler(Option instanceParent, int index, int updateMode) {
        super((XFDLParser)null);
        this.option = (ArrayOption)instanceParent;
        this.index = index;
        this.updateMode = updateMode;
    }

    EncloseHandler(EncloseHandler parent, String uri, String qName, Attributes attributes) {
        super(parent);
        this.option = new ArrayOption(parent.option, uri, qName, parent.option.getChildCount(), new AttributesImpl(attributes), parent.namespace, false);
        this.option.status = 4;
    }

    public void dispose() {
        this.option = null;
        super.dispose();
    }

    public Option getInstance() {
        return (Option)this.option.getChild(this.index);
    }

    public void setParser(XFDLParser parser) {
        this.parser = parser;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        Option newChild;
        int childIndex = this.option.getChildCount() - 1;
        switch (this.updateMode) {
            case 1: {
                newChild = this.option.removeLastChild();
                newChild.setStatus(8);
                Option oldChild = this.option.replaceChildAt(this.index, newChild, true);
                if (null != oldChild) {
                    FormNamespaceSupport oldNamespace = oldChild.getDefinedNamespace();
                    FormNamespaceSupport newNamespace = newChild.getDefinedNamespace();
                    if (null != oldNamespace) {
                        if (null != newNamespace) {
                            newNamespace.addNamespaceEntries(oldNamespace);
                        } else {
                            newChild.setNamespace(oldNamespace);
                        }
                    }
                    oldChild.dispose();
                }
                childIndex = this.index;
                break;
            }
            case 2: {
                int newStatus = 1 == this.option.getChildCount() ? 8 : 2;
                this.option.setStatus(newStatus);
                this.option.setParentStatus(2);
                break;
            }
            case 4: {
                newChild = this.option.removeLastChild();
                this.option.addChildAt(this.index, newChild, true);
                childIndex = this.index;
                break;
            }
            default: {
                throw new IllegalStateException(LocalizedStringFormat.bind(Messages.InternalError1.toStringAsRequest(), (Object)new Integer(this.updateMode).toString()));
            }
        }
        newChild = (Option)this.option.getChild(childIndex);
        FormNamespaceSupport newChildNS = newChild.getDefinedNamespace();
        if (null != newChildNS) {
            FormNamespaceSupport parentNS = this.option.getActiveNamespace();
            if (null != parentNS) {
                newChildNS.removeNamespaceEntries(parentNS);
            }
            newChild.setNamespace(newChildNS);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.parser.pushContext(new EncloseHandler(this, uri, qName, attributes));
        this.namespace = null;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.option.add(false);
        this.option.minimizeMemoryFootPrint();
        this.parser.popContext();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (null == this.namespace) {
            this.namespace = new FormNamespaceSupport();
        }
        this.namespace.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.option.value = null == this.option.value ? new String(ch, start, length) : this.option.value + new String(ch, start, length);
    }

    FormNode getNode() {
        return this.option;
    }
}

